package hiro.yoshioka.sql.resource;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public interface IDBResource extends INameFamily {


	IDBResource[] EMPTY_DBRESOURCE_ARRAY = new IDBResource[0];

	// ----------------------------------------------------------------------------
	// METHODS
	// ----------------------------------------------------------------------------
	void setName(String name);

	DBRoot getRoot();

	void slimUp();

	String getNameWithComment();

	String getNameWithComment(Charset charset, int maxColumnNameLen);

	String getNameWithAsComment();

	String getNameWithParentName();

	String getNameWithAsComment(Charset charset, int maxColumnNameLen);

	String getUName();

	boolean startsNameWith(String string);

	List<IDBResource> startsWithResourceLists(String pattern);

	boolean startsCommentWith(String string);

	void setPropertyValue(String key, String value);

	String getPropertyValue(String key);

	boolean isValid();

	void setValid(boolean valid);

	Object getImage();

	String getUComment();

	String getImageString();

	void setComment(String comment);

	IDBResource[] listArrayResources();

	void setResources(Map<String, IDBResource> map);

	IDBResource getResource(String key);

	IDBResource getResource(String key, boolean considerAlias);

	void putResource(String key, IDBResource child);

	IDBResource getParent();

	int childrenNum();

	boolean contain(String pattern);

	void setValueFromOld(IDBResource tbl);

}