package sql.notes;

import hiro.yoshioka.ast.sql.util.BindInfo;
import hiro.yoshioka.ast.sql.util.IProposalableParserUtil;
import hiro.yoshioka.ast.sql.util.ProposalParserFactory;
import hiro.yoshioka.ast.sql.util.WolfMongoProposalParserUtil;
import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.notes.NotesRunnerMeta;
import hiro.yoshioka.sql.notes.NotesRunnerSelection;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.DBResourceCapturingFilter;
import hiro.yoshioka.sql.params.DBUserPass;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class SelectSatementTester {

	private static IProposalableParserUtil getParserUtil(
			ConnectionProperties connectionProperties, String sql_statement) {
		ProposalParserFactory factory = ProposalParserFactory
				.createFactory(connectionProperties.getDriverName());
		return factory.createParserUtil(sql_statement,
				connectionProperties.getDBRootResource());
	}

	public static void main(String[] args) {

		ConnectionProperties p = new ConnectionProperties();

		// dom
		p.setHost("192.168.1.21");
		p.setAuthenticate(new DBUserPass("yuko admin/org", "password"));

		p.setCaptureWithDDL(false);
		p.setCaptureWithColumnInfo(false);
		p.setCaptureWithViewInfo(false);

		p.setCapturingFilter(DBResourceCapturingFilter.MATCHES);
		p.addFilePathRegrex(".*hoge.*");
		ClassManager cm = new ClassManager();

		try {
			cm.add_lib(new File(
					"C:/Program Files/IBM/Lotus/Domino/data/domino/java/NCSO.jar"));
			ExecutorService ex = Executors.newSingleThreadExecutor();
			Future<DBRoot> future = null;

			future = ex.submit(new NotesRunnerMeta(cm, p));

			try {
				System.out.println(future.get());
			} catch (InterruptedException e) {
				e.printStackTrace();
			} catch (ExecutionException e) {
				e.printStackTrace();
			}
			ex.shutdown();
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		String sql = "SELECT  $REF,dbname,Synonym,AppSpecID,NHDIDS,Context ,Subject,Book_1,Book  FROM hoge.ReportDoc";

		IProposalableParserUtil util = getParserUtil(p, sql);
		util.parse();

		if (!util.doQuery()) {
			MessageDialog
					.openWarning(Display.getCurrent().getActiveShell(), null,
							"Chihuahua can't accept Transactional Request..., only DML.");
			return;
		}

		TransactionRequest tran_request = null;

		tran_request = util.createTransactionRequest(p);

		// req.setMaxRownum(fMaxRowsFromDB.getSelection());
		tran_request.setPartName(util.getFirstTable().getName());

		try {
			cm.add_lib(new File(
					"C:/Program Files/IBM/Lotus/Domino/data/domino/java/NCSO.jar"));
			ExecutorService ex = Executors.newSingleThreadExecutor();
			Future<ResultSetDataHolder2> future = null;

			future = ex.submit(new NotesRunnerSelection(cm, null, p, util
					.getFirstTable(), "Form=\"ReportDoc\"", 100, false, false));

			try {
				System.out.println(future.get());
			} catch (InterruptedException e) {
				e.printStackTrace();
			} catch (ExecutionException e) {
				e.printStackTrace();
			}
			ex.shutdown();
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

	}
}
