package sql.mirroring;

import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.SQLServerSQL;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;

import java.io.File;

public class MsSQLServerTest {
	static File macConnections = new File(
			"/Users/yonsama/tools/eclipse36/wk/WolfSQLParser/config/");
	static File winConnections = new File(
			"C:/tools/eclipse/wk/WolfSQLParser/config/");

	protected ConnectionSettingBean bean = null;
	protected ConnectionProperties con_prop = null;

	public static void main(String[] args) {
		MsSQLServerTest obj = new MsSQLServerTest();
		obj.init();
		obj.doWorkd();
	}

	public void init() {
		if (hiro.yoshioka.util.Util.isWindowsOs()) {
			SQLServerThread.getSQLServer().init(winConnections);
		} else {
			SQLServerThread.getSQLServer().init(macConnections);
		}
		this.bean = SQLServerThread.getSQLServer().getConnectionSettingBean();
		for (ConnectionProperties p : bean.getConnectionSet()) {
			if (p.getDatabaseType().equals(DatabaseType.MS_SQLSERVER)) {
				con_prop = p;
				break;
			}
		}
		Request request = new Request(SQLOperationType.CONNECT, con_prop);

		boolean ret = SQLServerThread.runNowThisRequest(request);
		System.out.println("ret=" + ret);
	}

	private void doWorkd() {
		ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(
				con_prop);
		try {
			SQLServerSQL ssql = (SQLServerSQL) sql;
			boolean ret = sql.createUser("suzuki", null);
			System.out.println("exec ret =" + ret);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
