package hiro.yoshioka.sql.util;

import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.MirroringRequest;
import hiro.yoshioka.sql.engine.MirroringRequest.SQL_TYPES_CONVERT_MODE;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.view.DBResourceTreeSelection;
import hiro.yoshioka.util.StringUtil;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class DefaultMirroringDialog extends TitleAreaDialog implements
		SelectionListener {
	private static final int BTN_ID_EXECUTE = 5500;

	final ConnectionProperties originalConnectionProperties;
	Button btCasdade;
	Button btDropSchema;
	Button btDropTable;
	Button bt10Num, bt100Num, btAllNum;
	Button btMakeBlob, btRichTextToHtml;
	Combo cmbBooleanCnv;
	List renameColumnList;
	private static final String DEF_RENAME_SPLITTER = " => "; //$NON-NLS-1$
	private static final String DEF_SELECT_TARGET_SCHEMA = Messages
			.getString("DefaultMirroringDialog.SelectTargetSchema"); //$NON-NLS-1$
	private static final String DEF_ACTIVE_CONNECTION_IS_NOTHING = Messages
			.getString("DefaultMirroringDialog.SelectAnotherConnection"); //$NON-NLS-1$
	private static final String DEF_SELECT_CONNECTION = Messages
			.getString("DefaultMirroringDialog.SelectConnection"); //$NON-NLS-1$
	private static final String DEF_CREATE_NEW_SCHEMA = Messages
			.getString("DefaultMirroringDialog.CreateNewSchema"); //$NON-NLS-1$
	private static final String DEF_USE_DEFAULT_SCHEMA = "||- DEFAULT SCHEMA -||";
	Button btContinue;
	private ConnectionProperties targetConnectionProperties;
	Composite innerSchema;
	ScrolledForm root;
	private DBResourceTreeSelection fDBResourceTreeSelection;
	private Map<String, Combo> private_schemaMapping = new HashMap<String, Combo>();
	protected MirroringRequest mirroring_request;
	private Label mainTaskLabel, subTaskLabel;
	private ProgressBar progressBar;
	private Display display;
	private Set<String> columnNameSet = new TreeSet<String>();

	public DefaultMirroringDialog(Shell shell, ConnectionProperties p,
			DBResourceTreeSelection treeSelection) {
		super(shell);
		originalConnectionProperties = p;
		fDBResourceTreeSelection = treeSelection;
		for (IDBTable table : fDBResourceTreeSelection.getTableAndViewSet(true)) {
			for (IDBColumn column : table.getColumns()) {
				columnNameSet.add(column.getName());
			}
		}
		System.out.println("column=" + columnNameSet); //$NON-NLS-1$
	}

	@Override
	protected Point getInitialSize() {
		int width = 600;
		if (getParentShell().getBounds().width >= 900) {
			width = 900;
		} else if (getParentShell().getBounds().width >= 800) {
			width = 800;
		} else if (getParentShell().getBounds().width >= 700) {
			width = 700;
		}
		return new Point(width, 600);
	}

	@Override
	protected boolean isResizable() {
		return true;
	}

	@Override
	public void create() {
		super.create();
		validate();
	}

	private void resetTitle() {
		String targetDisp = "XXX"; //$NON-NLS-1$
		if (targetConnectionProperties != null) {
			targetDisp = targetConnectionProperties.getDisplayString();
		}
		root.setText(String.format(
				Messages.getString("DefaultMirroringDialog.MirroringToFrom"), targetDisp, //$NON-NLS-1$
				originalConnectionProperties.getDisplayString()));
	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		GridLayout gl = (GridLayout) parent.getLayout();
		gl.verticalSpacing = 0;
		gl.marginBottom = 0;
		gl.marginTop = 0;
		gl.marginHeight = 1;
		Button btExec = createButton(
				parent,
				BTN_ID_EXECUTE,
				Messages.getString("DefaultMirroringDialog.ExecuteMirroring"), false); //$NON-NLS-1$

		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, true);
	}

	protected void mirroring() {
		try {
			System.out.println("start mirroring"); //$NON-NLS-1$
			mirroring_request.addListener(new RequestAdaptor() {
				@Override
				public void beginTask(final String taskName, final int row) {
					System.out.println(String.format("  BEGINE %s [%d]", //$NON-NLS-1$
							taskName, row));
					if (showProgressSection()) {
						DefaultMirroringDialog.this.display
								.syncExec(new Runnable() {
									@Override
									public void run() {
										progressBar.setMaximum(row);
										mainTaskLabel.setText(taskName);
									}
								});
					}
				}

				@Override
				public void worked(int i) {
					if (showProgressSection()) {
						DefaultMirroringDialog.this.display
								.syncExec(new Runnable() {
									@Override
									public void run() {
										int now = progressBar.getSelection();
										progressBar.setSelection(now++);
									}
								});
					}
				}

				@Override
				public void subTask(final String subTaskName) {
					System.out.println("subTask::" + subTaskName); //$NON-NLS-1$
					if (showProgressSection()) {
						DefaultMirroringDialog.this.display
								.syncExec(new Runnable() {
									@Override
									public void run() {
										subTaskLabel.setText(subTaskName);
									}
								});
					}
					System.out.println(String.format("  SUB_TASK %s", //$NON-NLS-1$
							subTaskName));
				}

				@Override
				public void called_done(final Request request,
						final SQLOperationType operation,
						final ConnectionProperties properteis, Object o) {
					System.out.println(String.format("  DONE %s [%s]", //$NON-NLS-1$
							operation, properteis.getDisplayString()));
					if (showProgressSection()) {
						DefaultMirroringDialog.this.display
								.syncExec(new Runnable() {
									@Override
									public void run() {
										mainTaskLabel.setText(String.format(
												"  DONE %s [%s]", operation, //$NON-NLS-1$
												properteis.getDisplayString()));

										close();
									}
								});
					}
				}
			});
			boolean result = SQLServerThread
					.runNowThisRequest(mirroring_request);
			System.out.println("result=" + result);
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	public MirroringRequest getMirroringRequest() {
		return mirroring_request;
	}

	@Override
	protected void buttonPressed(int buttonId) {
		if (BTN_ID_EXECUTE == buttonId) {
			mirroring_request = new MirroringRequest(
					this.originalConnectionProperties,
					this.targetConnectionProperties);
			mirroring_request.continuing = this.btContinue.getSelection();
			mirroring_request.cascade = this.btCasdade.getSelection();
			mirroring_request.dropSchema = btDropSchema.getSelection();
			mirroring_request.dropTable = btDropTable.getSelection();
			mirroring_request.makeBlob = this.btMakeBlob.getSelection();
			if (this.bt10Num.getSelection()) {
				mirroring_request.maxRowNum = 10;
			} else if (this.bt100Num.getSelection()) {
				mirroring_request.maxRowNum = 100;
			} else {
				mirroring_request.maxRowNum = Integer.MAX_VALUE;
			}
			mirroring_request.richTextConvertHtml = this.btRichTextToHtml
					.getSelection();
			mirroring_request
					.addConvertMode((SQL_TYPES_CONVERT_MODE) cmbBooleanCnv
							.getData(cmbBooleanCnv.getText()));
			for (String key : private_schemaMapping.keySet()) {
				Combo c = private_schemaMapping.get(key);
				String cText = c.getText();
				if (DEF_USE_DEFAULT_SCHEMA.equals(cText)) {
					mirroring_request.mapToDefaultSchema(key);
				} else if (!DEF_SELECT_TARGET_SCHEMA.equals(cText)) {
					if (c.getText().startsWith("!-")) { //$NON-NLS-1$
						mirroring_request.putSchemaMapping(key,
								c.getToolTipText());
					} else {
						mirroring_request.putSchemaMapping(key, c.getText());
					}
				}
			}
			for (IDBTable table : fDBResourceTreeSelection
					.getTableAndViewSet(true)) {
				mirroring_request.putMirroringTable(
						table.getParent().getName(), table.getName(),
						table.isTable());
			}
			for (String rename : renameColumnList.getItems()) {
				String[] strs = rename.split(DEF_RENAME_SPLITTER);
				if (strs.length == 2) {
					mirroring_request.putColumnNameSubstitution(strs[0].trim(),
							strs[1].trim());
				}
			}
			mirroring();
		}
		super.buttonPressed(buttonId);
	}

	private GridData createGridData2() {
		GridData gd = new GridData(GridData.FILL_HORIZONTAL
				| GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 2;
		return gd;
	}

	protected Control createDialogArea(Composite parent) {
		getShell().setText(
				Messages.getString("DefaultMirroringDialog.MirroringDialog")); //$NON-NLS-1$
		try {
			display = parent.getDisplay();
			FormToolkit toolkit = new FormToolkit(parent.getDisplay());
			root = toolkit.createScrolledForm(parent);
			resetTitle();

			root.setLayoutData(new GridData(GridData.FILL_BOTH));
			GridLayout gll = new GridLayout(2, true);
			root.getBody().setLayout(gll);
			root.getBody().setLayoutData(new GridData(GridData.FILL_BOTH));

			Section section = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section.setText(Messages
					.getString("DefaultMirroringDialog.[1]DropOption")); //$NON-NLS-1$

			Composite inner = toolkit.createComposite(section);
			inner.setLayout(new FillLayout());

			btDropSchema = toolkit
					.createButton(
							inner,
							Messages.getString("DefaultMirroringDialog.DropSchema"), SWT.CHECK); //$NON-NLS-1$
			btDropSchema.addSelectionListener(this);
			btDropSchema.setSelection(false);
			btDropTable = toolkit
					.createButton(
							inner,
							Messages.getString("DefaultMirroringDialog.DropTable"), SWT.CHECK); //$NON-NLS-1$
			btDropTable.addSelectionListener(this);
			btDropTable.setSelection(true);

			btCasdade = toolkit
					.createButton(
							inner,
							Messages.getString("DefaultMirroringDialog.Cascade"), SWT.CHECK); //$NON-NLS-1$
			btCasdade.addSelectionListener(this);
			btCasdade.setSelection(true);

			section.setClient(inner);
			section.setLayoutData(createGridData2());
			// --------------------------------------------------------------------
			Section fuzzyOptionSection = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			fuzzyOptionSection
					.setText(Messages
							.getString("DefaultMirroringDialog.[2]TypeTranslateOptions")); //$NON-NLS-1$
			Composite fuzzyOptionComposite = toolkit
					.createComposite(fuzzyOptionSection);
			fuzzyOptionComposite.setLayout(new GridLayout(2, false));
			toolkit.createLabel(fuzzyOptionComposite, Messages
					.getString("DefaultMirroringDialog.BOOLEANConvertTo")); //$NON-NLS-1$
			cmbBooleanCnv = new Combo(fuzzyOptionComposite, SWT.READ_ONLY);
			for (SQL_TYPES_CONVERT_MODE mode : SQL_TYPES_CONVERT_MODE.BOOLEAN_LIST) {
				cmbBooleanCnv.add(mode.getLabel());
				cmbBooleanCnv.setData(mode.getLabel(), mode);
			}
			cmbBooleanCnv.select(0);

			fuzzyOptionSection.setClient(fuzzyOptionComposite);
			fuzzyOptionSection.setLayoutData(new GridData(
					GridData.FILL_HORIZONTAL
							| GridData.VERTICAL_ALIGN_BEGINNING));
			// --------------------------------------------------------------------
			Section numberOfTransitionSection = toolkit.createSection(
					root.getBody(), Section.EXPANDED | Section.TITLE_BAR);
			numberOfTransitionSection
					.setText(Messages
							.getString("DefaultMirroringDialog.[3]NumberOfMirroringRecords")); //$NON-NLS-1$
			Composite numberOfTransitionComposite = toolkit
					.createComposite(numberOfTransitionSection);
			numberOfTransitionComposite.setLayout(new FillLayout(SWT.VERTICAL));
			bt10Num = toolkit.createButton(numberOfTransitionComposite, "10", //$NON-NLS-1$
					SWT.RADIO);
			bt100Num = toolkit.createButton(numberOfTransitionComposite, "100", //$NON-NLS-1$
					SWT.RADIO);
			btAllNum = toolkit.createButton(numberOfTransitionComposite,
					Messages.getString("DefaultMirroringDialog.All"), //$NON-NLS-1$
					SWT.RADIO);
			btAllNum.setSelection(true);

			numberOfTransitionSection.setClient(numberOfTransitionComposite);
			numberOfTransitionSection.setLayoutData(new GridData(
					GridData.VERTICAL_ALIGN_BEGINNING
							| GridData.FILL_HORIZONTAL));

			// --------------------------------------------------------------------
			Section theOtherOptionSection = toolkit.createSection(
					root.getBody(), Section.EXPANDED | Section.TITLE_BAR);
			theOtherOptionSection.setText(Messages
					.getString("DefaultMirroringDialog.[4]TheOthersOptions")); //$NON-NLS-1$
			Composite theOtherOption = toolkit
					.createComposite(theOtherOptionSection);
			theOtherOption.setLayout(new FillLayout());

			btContinue = toolkit.createButton(theOtherOption,
					Messages.getString("DefaultMirroringDialog.IgnoreError"), //$NON-NLS-1$
					SWT.CHECK);
			btContinue.setSelection(true);
			btContinue.addSelectionListener(this);

			btMakeBlob = toolkit
					.createButton(
							theOtherOption,
							Messages.getString("DefaultMirroringDialog.withBlobAttachFiles"), SWT.CHECK); //$NON-NLS-1$
			btMakeBlob.setSelection(false);
			btMakeBlob.addSelectionListener(this);

			btRichTextToHtml = toolkit
					.createButton(
							theOtherOption,
							Messages.getString("DefaultMirroringDialog.RichTextConverttoHtml"), SWT.CHECK); //$NON-NLS-1$
			btRichTextToHtml.setSelection(false);
			btRichTextToHtml.addSelectionListener(this);

			theOtherOptionSection.setClient(theOtherOption);
			theOtherOptionSection.setLayoutData(createGridData2());
			// --------------------------------------------------------------------
			Section connectionSection = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			connectionSection.setText(Messages
					.getString("DefaultMirroringDialog.[5]TargetConnection")); //$NON-NLS-1$
			Composite innerC = toolkit.createComposite(connectionSection);
			GridLayout glcon = new GridLayout(1, false);
			innerC.setLayout(glcon);

			ConnectionSettingBean cbean = SQLServerThread.getSQLServer()
					.getConnectionSettingBean();

			final Combo targetConnectionCombo = new Combo(innerC, SWT.READ_ONLY);
			Collection<ConnectionProperties> cons = cbean
					.getConnectedConnectionSet();
			if (cons.size() <= 1) {
				targetConnectionCombo.add(DEF_ACTIVE_CONNECTION_IS_NOTHING);
			} else {
				targetConnectionCombo.add(DEF_SELECT_CONNECTION);
			}
			for (ConnectionProperties con : cons) {
				if (!con.equals(originalConnectionProperties)) {
					targetConnectionCombo.add(con.getDisplayString());
					targetConnectionCombo.setData(con.getDisplayString(), con);
				}
			}
			targetConnectionCombo.select(0);

			targetConnectionCombo.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					Object o = targetConnectionCombo
							.getData(targetConnectionCombo.getText());
					if (o != null) {
						DefaultMirroringDialog.this.targetConnectionProperties = (ConnectionProperties) o;
						resetTargetConnection();
					}
				}

			});
			connectionSection.setClient(innerC);
			connectionSection.setLayoutData(new GridData(
					GridData.VERTICAL_ALIGN_BEGINNING
							| GridData.FILL_HORIZONTAL));
			// --------------------------------------------------------------------
			Section schemaSection = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			schemaSection.setText(Messages
					.getString("DefaultMirroringDialog.[6]SchemaMapping")); //$NON-NLS-1$
			innerSchema = toolkit.createComposite(schemaSection);
			innerSchema.setLayout(new GridLayout(2, false));
			System.out.println("fsel.size=" //$NON-NLS-1$
					+ fDBResourceTreeSelection.getSchemaSet(true).size());
			for (IDBSchema schema : fDBResourceTreeSelection.getSchemaSet(true)) {
				Label schemaFrom = new Label(innerSchema, SWT.NONE);
				schemaFrom.setText(String.format("%s -> ", schema.getName())); //$NON-NLS-1$
				Combo mappingCombo = new Combo(innerSchema, SWT.READ_ONLY);
				mappingCombo.setToolTipText(schema.getName());
				mappingCombo.setLayoutData(new GridData(
						GridData.FILL_HORIZONTAL));
				mappingCombo
						.add(Messages
								.getString("DefaultMirroringDialog.SelectTargetConnection")); //$NON-NLS-1$
				mappingCombo.select(0);
				System.out.println("  schema.getName()=" + schema.getName()); //$NON-NLS-1$
				private_schemaMapping.put(schema.getName(), mappingCombo);
				mappingCombo.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						validate();
					}
				});
			}

			schemaSection.setClient(innerSchema);
			schemaSection.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
					| GridData.VERTICAL_ALIGN_BEGINNING));
			// --------------------------------------------------------------------
			Section renameMappingSection = toolkit.createSection(
					root.getBody(), Section.EXPANDED | Section.TITLE_BAR);
			renameMappingSection
					.setText(Messages
							.getString("DefaultMirroringDialog.[7]ColumnNameSubstitution")); //$NON-NLS-1$
			Composite renameSchemaComposite = toolkit
					.createComposite(renameMappingSection);
			renameSchemaComposite.setLayout(new GridLayout(2, false));

			this.renameColumnList = new List(renameSchemaComposite,
					SWT.READ_ONLY | SWT.BORDER);
			Composite renameColumnButtonComposite = toolkit
					.createComposite(renameSchemaComposite);
			GridData gdd = new GridData(GridData.FILL_BOTH);
			this.renameColumnList.setLayoutData(gdd);
			gdd = new GridData(GridData.FILL_VERTICAL
					| GridData.VERTICAL_ALIGN_BEGINNING);
			renameColumnButtonComposite.setLayoutData(gdd);
			renameColumnButtonComposite.setLayout(new RowLayout(SWT.VERTICAL));
			final Button addRnBtn = toolkit.createButton(
					renameColumnButtonComposite,
					Messages.getString("DefaultMirroringDialog.ADD"), SWT.PUSH); //$NON-NLS-1$
			addRnBtn.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					RenameColumnDialog rDialog = new RenameColumnDialog(
							getShell());
					if (rDialog.open() == RenameColumnDialog.OK) {
						renameColumnList.add(rDialog.renameBefore
								+ DEF_RENAME_SPLITTER + rDialog.renameAfter);
					}
				};
			});
			final Button delRnBtn = toolkit.createButton(
					renameColumnButtonComposite,
					Messages.getString("DefaultMirroringDialog.DEL"), SWT.PUSH); //$NON-NLS-1$
			delRnBtn.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					for (String str : renameColumnList.getSelection()) {
						renameColumnList.remove(str);
					}
				}
			});
			delRnBtn.setEnabled(false);
			this.renameColumnList.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					delRnBtn.setEnabled(renameColumnList.getSelectionCount() > 0);
				}
			});

			renameMappingSection.setClient(renameSchemaComposite);
			renameMappingSection.setLayoutData(createGridData2());
			// --------------------------------------------------------------------
			if (showProgressSection()) {
				Section progress_section = toolkit.createSection(
						root.getBody(), Section.EXPANDED | Section.TITLE_BAR);
				progress_section.setText(Messages
						.getString("DefaultMirroringDialog.MirroringProgress")); //$NON-NLS-1$
				Composite innerProgress = toolkit
						.createComposite(progress_section);
				innerProgress.setLayout(new FillLayout(SWT.VERTICAL));
				progressBar = new ProgressBar(innerProgress, SWT.SMOOTH);
				mainTaskLabel = new Label(innerProgress, SWT.NONE);
				subTaskLabel = new Label(innerProgress, SWT.NONE);

				progress_section.setClient(innerProgress);
				// GridData gd = new GridData(GridData.FILL_HORIZONTAL);
				// gd.horizontalSpan = 3;
				progress_section.setLayoutData(createGridData2());
			}

			return root;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return root;
	}

	protected boolean showProgressSection() {
		return true;
	}

	private void resetTargetConnection() {
		resetTitle();
		for (Entry<String, Combo> entry : private_schemaMapping.entrySet()) {
			Combo combo = entry.getValue();
			combo.clearSelection();
			combo.removeAll();
			ITransactionSQL sql = SQLServerThread.getSQLServer()
					.getTransactionSQL(targetConnectionProperties);
			combo.add(DEF_SELECT_TARGET_SCHEMA);
			int selectIdx = -1;
			for (String schemaName : sql.getSchemas()) {
				combo.add(schemaName);
				if (schemaName.equalsIgnoreCase(entry.getKey())) {
					selectIdx = combo.getItemCount() - 1;
				}
			}
			combo.add(DEF_USE_DEFAULT_SCHEMA);

			if (selectIdx < 0) {
				if (sql.canDoOperation(SQLOperationType.CREATE_SCHEMA)) {
					combo.add(String.format(DEF_CREATE_NEW_SCHEMA,
							combo.getToolTipText()));
				}
				combo.select(0);
			} else {
				combo.select(selectIdx);
			}
		}
		validate();
	}

	private void validate() {
		String newErrorMessage = null;
		IDBSchema schema = this.fDBResourceTreeSelection.getNoChildSchema();
		if (schema != null) {
			newErrorMessage = String.format(Messages
					.getString("DefaultMirroringDialog.SchemaHasNoTable"), //$NON-NLS-1$
					originalConnectionProperties.getDisplayString(), schema
							.getNameWithAsComment());
		} else {
			if (this.targetConnectionProperties == null) {
				if (SQLServerThread.getSQLServer().getConnectionSettingBean()
						.getConnectedConnectionSet().size() <= 1) {
					newErrorMessage = Messages
							.getString("DefaultMirroringDialog.AnotherConnectionIsNothing"); //$NON-NLS-1$
				} else {
					newErrorMessage = Messages
							.getString("DefaultMirroringDialog.SetTargetConnection"); //$NON-NLS-1$
				}
			}
			if (StringUtil.isEmpty(newErrorMessage)) {
				for (String key : private_schemaMapping.keySet()) {
					Combo c = private_schemaMapping.get(key);
					if (c.getText().equals(DEF_SELECT_TARGET_SCHEMA)) {
						newErrorMessage = String
								.format(Messages
										.getString("DefaultMirroringDialog.SchemaMappingIsNothing"), key); //$NON-NLS-1$
						break;
					}
				}
			}
		}
		setErrorMessage(newErrorMessage);
		getButton(BTN_ID_EXECUTE).setEnabled(newErrorMessage == null);
	}

	public ConnectionProperties getOriginalConnectionProperties() {
		return originalConnectionProperties;
	}

	public ConnectionProperties getTargetConnectionProperties() {
		return targetConnectionProperties;
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent arg0) {
		// TODO Auto-generated method stub

	}

	@Override
	public void widgetSelected(SelectionEvent evnt) {
		if (evnt.widget == btDropSchema || evnt.widget == btDropTable) {
			if (btDropSchema.getSelection() || btDropTable.getSelection()) {
				btCasdade.setEnabled(true);
			} else {
				btCasdade.setEnabled(false);
				btCasdade.setSelection(false);
			}
		}

	}

	class RenameColumnDialog extends Dialog {
		public String renameBefore, renameAfter;
		Combo columnCombo;
		Text text;

		protected RenameColumnDialog(Shell parentShell) {
			super(parentShell);
		}

		@Override
		public void create() {
			super.create();
			getShell()
					.setText(
							Messages.getString("DefaultMirroringDialog.ColumnNameSubstitutionDialog")); //$NON-NLS-1$
		}

		@Override
		protected boolean isResizable() {
			return true;
		}

		@Override
		protected void okPressed() {
			renameBefore = columnCombo.getText();
			renameAfter = text.getText();
			super.okPressed();
		}

		@Override
		protected void createButtonsForButtonBar(Composite parent) {
			super.createButtonsForButtonBar(parent);
			getButton(IDialogConstants.OK_ID).setEnabled(false);
		}

		@Override
		protected Control createDialogArea(Composite parent) {
			Composite ret = new Composite(parent, SWT.NONE);
			ret.setLayout(new GridLayout(2, false));
			new Label(ret, SWT.NONE).setText(Messages
					.getString("DefaultMirroringDialog.substitutionBefore")); //$NON-NLS-1$
			columnCombo = new Combo(ret, SWT.READ_ONLY);
			columnCombo.setItems(columnNameSet.toArray(new String[columnNameSet
					.size()]));
			columnCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			new Label(ret, SWT.NONE).setText(Messages
					.getString("DefaultMirroringDialog.substitutionAfter")); //$NON-NLS-1$
			text = new Text(ret, SWT.SINGLE);
			text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			columnCombo.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					text.setText(columnCombo.getText());
					getButton(IDialogConstants.OK_ID).setEnabled(
							columnCombo.getText().length() > 0
									&& text.getText().length() > 0);
				}
			});
			text.addKeyListener(new KeyAdapter() {
				@Override
				public void keyReleased(KeyEvent e) {
					getButton(IDialogConstants.OK_ID).setEnabled(
							columnCombo.getText().length() > 0
									&& text.getText().length() > 0);
				}
			});
			return ret;
		}
	}
}