package hiro.yoshioka.sql.notes;

import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sdh.ResultSetMetaCopy;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.DominoTransactionRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.notes.reflect.WolfDatabase;
import hiro.yoshioka.sql.notes.reflect.WolfDocument;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.INameFamily;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.concurrent.Callable;

public class NotesRunnerUpdate extends AbsNotesRunner implements
		Callable<ResultSetDataHolder2> {
	INameFamily table;
	String dominoSearchQuery;
	Set<String> unidSet;
	ResultSetDataHolder2 rdh2;
	List<ResultSetMetaCopy.MetaInfo> metaList = new ArrayList<ResultSetMetaCopy.MetaInfo>();

	public NotesRunnerUpdate(ClassManager manager, Request request) {
		super(manager, request, request.getConnectionProperties());
		TransactionRequest transaction_request = (TransactionRequest) request;
		this.table = transaction_request.getIDBTable();
	}

	public NotesRunnerUpdate(ClassManager manager, Request request,
			ConnectionProperties properties, IDBTable table,
			Set<String> unidSet, boolean makeBlobData) {
		super(manager, request, properties);
		this.table = table;
		this.unidSet = unidSet;
	}

	@Override
	public ResultSetDataHolder2 call() throws Exception {
		initClass();
		createSession();

		try {
			return callTable();
		} finally {
			wolf_session.recycle();
		}
	}

	public ResultSetDataHolder2 callTable() throws Exception {
		WolfDatabase database = getDatabaseByTable(table);

		if (database == null) {
			return null;
		}
		if (!database.isOpen()) {
			database.open();
		}
		DominoTransactionRequest domino_request = (DominoTransactionRequest) request;
		try {
			System.out.println("doinsert !!!!!!!!!!!! ");
			List<Map<String, Object>> list = domino_request.getParamsList();

			List<String> titleList = new ArrayList<String>();
			titleList.add("result");
			if (list.size() > 0) {
				for (String title : list.get(0).keySet()) {
					titleList.add(title);
					if (titleList.size() >= 6) {
						break;
					}
				}
			}

			rdh2 = new ResultSetDataHolder2(
					titleList.toArray(new String[titleList.size()]), null,
					DatabaseType.DOMINO);
			System.out.println("keys=" + titleList);
			request.beginTask("Record update ", list.size());
			for (int i = 0; i < list.size(); i++) {
				Map<String, Object> params = list.get(i);
				if (i % 2 == 0 && params.containsKey("Subject")) {
					request.subTask("Create Document[" + params.get("Subject"));
				}
				WolfDocument doc = database.createDocument();
				doc.appendItemValue("Form", "ReportDoc");
				String[] resultRow = new String[titleList.size()];
				for (Entry<String, Object> entry : params.entrySet()) {
					doc.appendItemValue(entry.getKey(), entry.getValue());
					int keyIdx = titleList.indexOf(entry.getKey());
					if (keyIdx >= 0) {
						resultRow[keyIdx] = String.valueOf(entry.getValue());
					}
				}
				boolean ret = doc.save();
				resultRow[0] = String.valueOf(ret);
				rdh2.addRow(resultRow);
				if (i % 2 == 0) {
					request.worked(2);
				}
				doc.recycle();
			}
		} catch (Exception ne) {
			ne.printStackTrace();

			System.out.println(ne.getLocalizedMessage());
		} finally {
			if (database != null) {
				database.recycle();
			}
		}

		return rdh2;
	}
}
