package hiro.yoshioka.sql.engine;

import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sdh.diff.DiffCatalog;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBResourceType;

import java.util.Set;
import java.util.TreeSet;

public class DifferenceInStructureRequest extends TwoDatabasesRequest {

	static final String[] TITLE = { "TYPE", "DIFF_COUNT", "RESULT", "THROWABLE" };
	private Set<DBResourceType> diffTargetResourceTypeSet = new TreeSet<DBResourceType>();
	DiffCatalog diffCatalog;
	boolean withValue;

	public DifferenceInStructureRequest(
			ConnectionProperties originalConnectionProperties,
			ConnectionProperties targetConnectionProperties) {
		super(SQLOperationType.DIFFERENCE_IN_STRUCTURE,
				originalConnectionProperties, targetConnectionProperties);
		setRDH(new ResultSetDataHolder2(TITLE, null, DatabaseType.UNKNOWN));
		diffCatalog = new DiffCatalog();
	}

	public DiffCatalog getDiffCatalog() {
		return diffCatalog;
	}

	public void addResourceType(DBResourceType type) {
		this.diffTargetResourceTypeSet.add(type);
	}

	public boolean containResourceType(DBResourceType type) {
		return this.diffTargetResourceTypeSet.contains(type);
	}

	public boolean withValue() {
		return withValue;
	}

}