package hiro.yoshioka.sql.resource.twitter;

import hiro.yoshioka.sql.resource.DBColumn.SearchableType;
import hiro.yoshioka.sql.resource.DBDictionaryRoot;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TwitterDBTable extends DBTable implements Serializable {
	private static final long serialVersionUID = -4159112809428279981L;
	private TwitterTableType twitterTableType;

	public TwitterDBTable(IDBSchema schema, TwitterTableType tableType) {
		super(schema);
		this.twitterTableType = tableType;
		setName(tableType.name());
		setComment(tableType.getTableName());
	}

	public TwitterDBTable(DBDictionaryRoot droot) {
		super(droot);
	}

	@Override
	public IDBColumn[] getColumnsForSelectionDialog() {
		TwitterDBSchema parent = (TwitterDBSchema) getParent();
		List<TwitterColumnType> clist = TwitterColumnType
				.getSearchColumnTypeListOf(parent.getSchemaType(),
						twitterTableType);
		if (clist.size() == 0) {
			return super.getColumnsForSelectionDialog();
		}
		List list = new ArrayList();
		for (TwitterColumnType ct : clist) {
			TwitterDBColumn column = new TwitterDBColumn(this, ct);
			column.setName(ct.name());
			column.setConditionParameter(SearchableType.SEARCHABLE_INVISIBLE);
			list.add(column);
		}
		list.addAll(listResources());

		return (IDBColumn[]) list.toArray(new IDBColumn[list.size()]);
	}

	public TwitterTableType getTwitterTableType() {
		return twitterTableType;
	}

	@Override
	public void setValueFromOld(IDBResource tbl) {
		System.out.println("old form=" + twitterTableType);
		this.twitterTableType = ((TwitterDBTable) tbl).twitterTableType;
	}

}