package hiro.yoshioka.sql.resource;

import hiro.yoshioka.util.StringUtil;

import java.util.List;

public interface IDBSchema extends IDBResource {
	IDBTable[] getTables();

	IDBTable[] getProcedures();

	IDBTrigger[] getTriggers();

	IDBSequence getSequence(String name);

	IDBSequence[] getSequences();

	void putSequence(IDBSequence sequence);

	IDBTable[] getFunctions();

	IDBTable getTable(String name);

	IDBTrigger getTrigger(String name);

	IDBTable getProcedure(String name);

	void putTable(IDBTable table);

	void putProcedure(IDBTable table);

	void putTrigger(IDBTrigger trigger);

	String getCurrentDefaultString();

	boolean isDefault();

	boolean isCurrent();

	/**
	 * @param tableNameString
	 * @return
	 */
	List getResourceListStartsWith(String tableNameString);
}