package hiro.yoshioka.sql.resource;

import hiro.yoshioka.util.StringUtil;

import java.nio.charset.Charset;
import java.sql.DatabaseMetaData;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.swt.graphics.Image;

public class DBColumn extends DBResource implements IDBColumn {
	private static final long serialVersionUID = 9999846456L;
	int maxColumnNameLength;

	public static transient Image image;
	private String fAlias;

	public DBColumn(IDBTable table) {
		super(table);
	}

	public int getSize() {
		return size;
	}

	public String getSizeString() {
		StringBuffer buf = new StringBuffer();
		buf.append(getSize());
		if (decimalDigits != 0) {
			buf.append(".").append(decimalDigits);
		}
		return buf.toString();
	}

	public boolean isIndex() {
		return false;
		// return ((DBTable) _parent).hasIndex(this);
	}

	public int getDecimalDigits() {
		return decimalDigits;
	}

	public boolean isNotNull() {
		return notnull;
	}

	public boolean isBlob() {
		return dataType == Types.BLOB;
	}

	public boolean isBinary() {
		return dataType == Types.BINARY || dataType == Types.VARBINARY
				|| dataType == Types.LONGVARBINARY;
	}

	public boolean isDate() {
		return dataType == Types.DATE;
	}

	public boolean isTime() {
		return dataType == Types.TIME;
	}

	public boolean isTimeStamp() {
		return dataType == Types.TIMESTAMP;
	}

	public boolean isNumeric() {
		return dataType == 4 || dataType == 6 || dataType == 8
				|| dataType == -5 || dataType == 3 || dataType == 2
				|| dataType == 5 || dataType == -6;
	}

	public boolean isBigDecimal() {
		return dataType == 3;
	}

	public boolean isString() {
		return dataType == 1 || dataType == -1 || dataType == 12;
	}

	public void setDecimalDigits(int decimalDigits) {
		this.decimalDigits = decimalDigits;
	}

	public void setNotNull(boolean notnull) {
		this.notnull = notnull;
	}

	public void setSize(int size) {
		this.size = size;
	}

	public void setDataType(int type) {
		this.dataType = type;
	}

	public void setPKey(boolean pkey) {
		this.pkey = pkey;
	}

	public void setPKey(ArrayList pkeys) {
		for (Iterator ite = pkeys.iterator(); ite.hasNext();) {
			String pkey = (String) ite.next();
			if (super.name.equalsIgnoreCase(pkey)) {
				this.pkey = true;
				return;
			}
		}

	}

	public boolean isPkey() {
		return pkey;
	}

	public boolean isIndexColumn() {
		return indexColumn;
	}

	public void setIndexColumn(boolean value) {
		indexColumn = value;
	}

	/*
	 * 
	 */
	public static String cnvColumnType(short type) {
		switch (type) {
		case DatabaseMetaData.procedureColumnIn:
			return "\u24be\u24dd";
		case DatabaseMetaData.procedureColumnInOut:
			return "\u24be\u24c4";
		case DatabaseMetaData.procedureColumnOut:
			return "\u24c4\u24e3";
		case DatabaseMetaData.procedureColumnResult:
			return "\u24c7\u24e2";
		case DatabaseMetaData.procedureColumnReturn:
			return "\u24c7\u24e3";
		case DatabaseMetaData.procedureColumnUnknown:
			return "\u24ca\u24da";
		default:
			return "";
		}
	}

	public IDBTable getTable() {
		return table;
	}

	public String toString() {
		if (-1 != columnType) {
			return cnvColumnType(getColumnType()) + " " + getName() + " "
					+ getDataTypeString() + "(" + getSizeString() + ")";
		} else {
			if (getComment().length() == 0) {
				return getName() + " " + getDataTypeString() + "("
						+ getSizeString() + ")";
			}
			return getName() + " " + getDataTypeString() + "("
					+ getSizeString() + ") y" + getComment() + "z";
		}
	}

	/**
	 * RecAVXgpԋpB fASTExpr==null?getName():fASTExpr
	 * 
	 * @return AVXgp
	 */
	public String getProposalString() {
		return getName();
	}

	public String toStringWithIndexInfo() {
		return toString();// + " " + ((DBTable) _parent).getIndexNames(this);
	}

	public String getNameWithCommentLimLen(Charset charset) {
		return getNameWithAsComment(charset, this.maxColumnNameLength);
	}

	public String getNameWithAsComment() {
		return getNameWithAsComment(Charset.defaultCharset());
	}

	public String getNameWithAsComment(Charset charset) {
		return getNameWithAsComment(charset, this.maxColumnNameLength);
	}

	private IDBTable table;

	private int size;

	private int dataType;

	private String dataTypeString;

	private int decimalDigits;

	private boolean notnull;

	private boolean pkey;

	private boolean indexColumn;

	// -1̓vVWȊO
	private short columnType = -1;

	public void setComment(String remarks) {
		this.comment = remarks;
	}

	/**
	 * VARCHER,TIMESTAMP
	 */
	public int getDataType() {
		return dataType;
	}

	public void setColumnType(short columnType) {
		this.columnType = columnType;
	}

	public short getColumnType() {
		return columnType;
	}

	/**
	 * @param short1
	 */
	public void setNullable(short short1) {
		notnull = (DatabaseMetaData.columnNoNulls == short1);
	}

	public boolean contain(String pattern) {
		if (containKeyInNameOrComment(pattern)) {
			return true;
		}
		return false;
	}

	public String getAlias() {
		return fAlias == null ? "" : fAlias;
	}

	public String getImageString() {
		String key = this.getClass().toString();
		if (isPkey()) {
			return "\u24ab";
		} else if (isNotNull()) {
			return "\u24a9";
		} else {
			return "";
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * hiro.yoshioka.sql.resource.IAliasExtention#setAlias(java.lang.String)
	 */
	public void setAlias(String alias) {
		fAlias = alias;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.resource.IDBTable#hasAlias()
	 */
	public boolean hasAlias() {
		return getAlias().length() > 0;
	}

	public Image getImage() {
		return image;
	}

	public String getUAlias() {
		return getAlias().toUpperCase();
	}

	public int getMaxColumnNameLength() {
		return maxColumnNameLength;
	}

	public void setMaxColumnNameLength(int maxColumnNameLength) {
		this.maxColumnNameLength = maxColumnNameLength;
	}

	public boolean isColumnIn() {
		return DatabaseMetaData.procedureColumnIn == columnType;
	}

	public boolean isColumnInOut() {
		return DatabaseMetaData.procedureColumnInOut == columnType;
	}

	public boolean isColumnOut() {
		return DatabaseMetaData.procedureColumnOut == columnType;
	}

	public boolean isColumnReturn() {
		return DatabaseMetaData.procedureColumnReturn == columnType;
	}

	public String getDataTypeString() {
		return dataTypeString;
	}

	public void setDataTypeString(String dataTypeString) {
		this.dataTypeString = dataTypeString;
	}
}