package hiro.yoshioka.ast.sql;

import hiro.yoshioka.ast.sql.util.ASTAssist;
import hiro.yoshioka.sql.resource.DBRoot;

import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbsSQLParser {

	public static IParserException _INTERNAL_EXCEPTION;

	protected Log fLogger = LogFactory.getLog(this.getClass());

	protected int lastDML = 0;

	protected ASTAssist fAssist;

	protected DBRoot fDBRoot;

	protected boolean fOpen;

	protected boolean hasDBRoot() {
		return this.fDBRoot != null;
	}

	public boolean parse(DBRoot root) {
		this.fDBRoot = root;
		return parse();
	}

	public abstract boolean parse();

	public boolean hasException() {
		return _INTERNAL_EXCEPTION != null;
	}

	public IParserException getException() {
		return _INTERNAL_EXCEPTION;
	}

	public Iterator getExpectedTokens() {
		return _INTERNAL_EXCEPTION.getExpectedTokenIterator();
	}

	public abstract AbsSimpleNode getRoot();

	public abstract boolean nodeCreated();

	protected void open() {
		this.fOpen = true;
	}

	protected void close() {
		this.fOpen = false;
	}

	protected String printToken(IToken t) {
		return "This Token [" + t.getImage() + "] [" + t.getBeginLine() + "/"
				+ t.getBeginColumn() + "]";
	}

	public abstract void enable_tracing();

	public abstract void disable_tracing();

}
