/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.PlainConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DoubleConverter
implements Converter {
    public static final DoubleConverter INSTANCE = new DoubleConverter();

    DoubleConverter() {
    }

    @Override
    public Object convert(JSON json, JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        NumberFormat f;
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value instanceof String && (f = context.format(NumberFormat.class)) != null) {
            value = f.parse((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : Double.NaN;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = value.toString().trim();
            if (str.length() > 0) {
                return Double.valueOf(str);
            }
            return PlainConverter.getDefaultValue(c);
        }
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        return PlainConverter.getDefaultValue(c);
    }
}

