/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.store.ObjectCacheHashMap;

public class TextCache
extends DataFileCache {
    public static final String NL = System.getProperty("line.separator");
    public String fs;
    public String vs;
    public String lvs;
    public String stringEncoding;
    public boolean isQuoted;
    public boolean isAllQuoted;
    public boolean ignoreFirst;
    protected String header;
    protected Table table;
    private ObjectCacheHashMap uncommittedCache;
    static final char DOUBLE_QUOTE_CHAR = '\"';
    static final char BACKSLASH_CHAR = '\\';
    static final char LF_CHAR = '\n';
    static final char CR_CHAR = '\r';

    TextCache(Table table, String string) {
        super(table.database, string);
        this.table = table;
        this.uncommittedCache = new ObjectCacheHashMap(5);
    }

    @Override
    protected void initParams(Database database, String string) {
        this.dataFileName = this.dataFileName;
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        HsqlProperties hsqlProperties = HsqlProperties.delimitedArgPairsToProps(string, "=", ";", "textdb");
        HsqlDatabaseProperties hsqlDatabaseProperties = database.getProperties();
        switch (hsqlProperties.errorCodes.length) {
            case 0: {
                throw Error.error(301);
            }
            case 1: {
                this.dataFileName = hsqlProperties.errorKeys[0].trim();
                break;
            }
            default: {
                throw Error.error(302);
            }
        }
        this.fs = hsqlDatabaseProperties.getStringProperty("textdb.fs");
        this.fs = hsqlProperties.getProperty("textdb.fs", this.fs);
        this.vs = hsqlDatabaseProperties.getStringProperty("textdb.vs");
        this.vs = hsqlProperties.getProperty("textdb.vs", this.vs);
        this.lvs = hsqlDatabaseProperties.getStringProperty("textdb.lvs");
        this.lvs = hsqlProperties.getProperty("textdb.lvs", this.lvs);
        if (this.vs == null) {
            this.vs = this.fs;
        }
        if (this.lvs == null) {
            this.lvs = this.fs;
        }
        this.fs = TextCache.translateSep(this.fs);
        this.vs = TextCache.translateSep(this.vs);
        this.lvs = TextCache.translateSep(this.lvs);
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Error.error(303);
        }
        this.ignoreFirst = hsqlDatabaseProperties.isPropertyTrue("textdb.ignore_first");
        this.ignoreFirst = hsqlProperties.isPropertyTrue("textdb.ignore_first", this.ignoreFirst);
        this.isQuoted = hsqlDatabaseProperties.isPropertyTrue("textdb.quoted");
        this.isQuoted = hsqlProperties.isPropertyTrue("textdb.quoted", this.isQuoted);
        this.isAllQuoted = hsqlDatabaseProperties.isPropertyTrue("textdb.all_quoted");
        this.isAllQuoted = hsqlProperties.isPropertyTrue("textdb.all_quoted", this.isAllQuoted);
        this.stringEncoding = hsqlDatabaseProperties.getStringProperty("textdb.encoding");
        this.stringEncoding = hsqlProperties.getProperty("textdb.encoding", this.stringEncoding);
        int n = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_scale");
        n = hsqlProperties.getIntegerProperty("textdb.cache_scale", n);
        int n2 = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_size_scale");
        n2 = hsqlProperties.getIntegerProperty("textdb.cache_size_scale", n2);
        this.maxCacheRows = (1 << n) * 3;
        this.maxCacheRows = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_rows", this.maxCacheRows);
        this.maxCacheRows = hsqlProperties.getIntegerProperty("textdb.cache_rows", this.maxCacheRows);
        this.maxCacheBytes = (1 << n2) * this.maxCacheRows / 1024;
        if (this.maxCacheBytes < 4L) {
            this.maxCacheBytes = 4L;
        }
        this.maxCacheBytes = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_size", (int)this.maxCacheBytes);
        this.maxCacheBytes = hsqlProperties.getIntegerProperty("textdb.cache_size", (int)this.maxCacheBytes);
        this.maxCacheBytes *= 1024L;
        this.maxDataFileSize = Integer.MAX_VALUE;
        this.cachedRowPadding = 1;
        this.cacheFileScale = 1;
    }

    @Override
    protected void initBuffers() {
        if (this.isQuoted || this.isAllQuoted) {
            this.rowIn = new RowInputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted);
            this.rowOut = new RowOutputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted, this.stringEncoding);
        } else {
            this.rowIn = new RowInputText(this.fs, this.vs, this.lvs, false);
            this.rowOut = new RowOutputText(this.fs, this.vs, this.lvs, false, this.stringEncoding);
        }
    }

    private static String translateSep(String string) {
        return TextCache.translateSep(string, false);
    }

    private static String translateSep(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(92);
        if (n != -1) {
            int n2 = 0;
            char[] cArray = string.toCharArray();
            int n3 = 0;
            int n4 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n4);
            do {
                stringBuffer.append(cArray, n2, n - n2);
                n2 = ++n;
                if (n >= n4) {
                    stringBuffer.append('\\');
                    break;
                }
                if (!bl) {
                    n3 = cArray[n];
                }
                if (n3 == 110) {
                    stringBuffer.append('\n');
                    ++n2;
                    continue;
                }
                if (n3 == 114) {
                    stringBuffer.append('\r');
                    ++n2;
                    continue;
                }
                if (n3 == 116) {
                    stringBuffer.append('\t');
                    ++n2;
                    continue;
                }
                if (n3 == 92) {
                    stringBuffer.append('\\');
                    ++n2;
                    continue;
                }
                if (n3 == 117) {
                    stringBuffer.append((char)Integer.parseInt(string.substring(++n2, n2 + 4), 16));
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("semi", n)) {
                    stringBuffer.append(';');
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("space", n)) {
                    stringBuffer.append(' ');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("quote", n)) {
                    stringBuffer.append('\"');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("apos", n)) {
                    stringBuffer.append('\'');
                    n2 += 4;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(cArray[n]);
                ++n2;
            } while ((n = string.indexOf(92, n2)) != -1);
            stringBuffer.append(cArray, n2, n4 - n2);
            string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public void open(boolean bl) {
        this.fileFreePosition = 0L;
        try {
            int n = this.database.getType() == "res:" ? 2 : 5;
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
            this.fileFreePosition = this.dataFile.length();
            if (this.fileFreePosition > Integer.MAX_VALUE) {
                throw Error.error(468);
            }
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0, 0L);
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 42, new Object[]{throwable.toString(), this.dataFileName});
        }
        this.cacheReadonly = bl;
    }

    void reopen() {
        this.open(this.cacheReadonly);
    }

    @Override
    public void close(boolean bl) {
        if (this.dataFile == null) {
            return;
        }
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            boolean bl2 = this.dataFile.length() <= (long)NL.length();
            this.dataFile.synch();
            this.dataFile.close();
            this.dataFile = null;
            if (bl2 && !this.cacheReadonly) {
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
            this.uncommittedCache.clear();
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 43, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void purge() {
        this.writeLock.lock();
        try {
            this.uncommittedCache.clear();
            if (this.cacheReadonly) {
                this.close(false);
            } else {
                if (this.dataFile != null) {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 44, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    int setFilePos(CachedObject cachedObject) {
        int n = cachedObject.getStorageSize();
        long l = this.fileFreePosition + (long)n;
        if (l > this.maxDataFileSize) {
            this.database.logger.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
            throw Error.error(468);
        }
        int n2 = (int)this.fileFreePosition;
        cachedObject.setPos(n2);
        this.clearRowImage(cachedObject);
        this.fileFreePosition = l;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int n, PersistentStore persistentStore) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = (CachedObject)this.uncommittedCache.remove(n);
            if (cachedObject != null) {
                return;
            }
            cachedObject = this.cache.release(n);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePersistence(int n, PersistentStore persistentStore) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = (CachedObject)this.uncommittedCache.remove(n);
            if (cachedObject == null && (cachedObject = this.get(n, persistentStore, false)) != null) {
                this.clearRowImage(cachedObject);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void clearRowImage(CachedObject cachedObject) {
        try {
            int n = cachedObject.getStorageSize() - ScriptWriterText.BYTES_LINE_SEP.length;
            this.rowOut.reset();
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = this.rowOut.getOutputStream();
            hsqlByteArrayOutputStream.fill(32, n);
            hsqlByteArrayOutputStream.write(ScriptWriterText.BYTES_LINE_SEP);
            this.dataFile.seek(cachedObject.getPos());
            this.dataFile.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            throw Error.runtimeError(201, iOException.getMessage());
        }
    }

    @Override
    protected RowInputInterface readObject(int n) {
        try {
            ByteArray byteArray = new ByteArray(80);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            n = this.findNextUsedLinePos(n);
            if (n == -1) {
                return null;
            }
            this.dataFile.seek(n);
            while (!bl) {
                bl4 = false;
                int n2 = this.dataFile.read();
                if (n2 == -1) {
                    if (byteArray.length() == 0) {
                        return null;
                    }
                    bl = true;
                    if (bl2 || this.cacheReadonly) break;
                    this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
                    break;
                }
                switch (n2) {
                    case 34: {
                        bl4 = true;
                        bl = bl2;
                        bl2 = false;
                        if (!this.isQuoted) break;
                        bl3 = !bl3;
                        break;
                    }
                    case 13: {
                        bl2 = !bl3;
                        break;
                    }
                    case 10: {
                        bl = !bl3;
                        break;
                    }
                    default: {
                        bl4 = true;
                        bl = bl2;
                        bl2 = false;
                    }
                }
                byteArray.append(n2);
            }
            if (bl) {
                int n3 = (int)this.dataFile.getFilePointer() - n;
                if (bl4) {
                    --n3;
                }
                ((RowInputText)this.rowIn).setSource(byteArray.toString(), n, n3);
                return this.rowIn;
            }
            return null;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    public int readHeaderLine() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ByteArray byteArray = new ByteArray(80);
        while (!bl) {
            bl3 = false;
            try {
                n = this.dataFile.read();
                if (n == -1) {
                    if (byteArray.length() == 0) {
                        return 0;
                    }
                    bl = true;
                    if (this.cacheReadonly) break;
                    this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
                    break;
                }
            }
            catch (IOException iOException) {
                throw Error.error(483);
            }
            switch (n) {
                case 13: {
                    bl2 = true;
                    break;
                }
                case 10: {
                    bl = true;
                    break;
                }
                default: {
                    bl3 = true;
                    bl = bl2;
                    bl2 = false;
                }
            }
            if (bl2 || bl) continue;
            byteArray.append(n);
        }
        this.header = byteArray.toString();
        try {
            n = (int)this.dataFile.getFilePointer();
            if (bl3) {
                --n;
            }
            return n;
        }
        catch (IOException iOException) {
            throw Error.error(483);
        }
    }

    int findNextUsedLinePos(int n) {
        try {
            int n2 = n;
            int n3 = n;
            boolean bl = false;
            this.dataFile.seek(n);
            block8: while (true) {
                int n4 = this.dataFile.read();
                ++n3;
                switch (n4) {
                    case 13: {
                        bl = true;
                        continue block8;
                    }
                    case 10: {
                        bl = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        n2 = n3;
                        continue block8;
                    }
                    case 32: {
                        if (!bl) continue block8;
                        bl = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        continue block8;
                    }
                    case -1: {
                        return -1;
                    }
                }
                break;
            }
            if (bl) {
                bl = false;
                ((RowInputText)this.rowIn).skippedLine();
            }
            return n2;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.setFilePos(cachedObject);
            this.uncommittedCache.put(cachedObject.getPos(), cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(CachedObject cachedObject, PersistentStore persistentStore, boolean bl) {
        if (cachedObject == null) {
            return null;
        }
        return this.get(cachedObject.getPos(), persistentStore, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject get(int n, PersistentStore persistentStore, boolean bl) {
        CachedObject cachedObject;
        if (n < 0) {
            return null;
        }
        this.readLock.lock();
        try {
            cachedObject = (CachedObject)this.uncommittedCache.get(n);
            if (cachedObject != null) {
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        cachedObject = super.get(n, persistentStore, bl);
        return cachedObject;
    }

    @Override
    protected void saveRows(CachedObject[] cachedObjectArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        for (int i = n; i < n + n2; ++i) {
            CachedObject cachedObject = cachedObjectArray[i];
            this.uncommittedCache.put(cachedObject.getPos(), cachedObject);
            cachedObjectArray[i] = null;
        }
    }

    @Override
    public void saveRow(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.setFileModified();
            this.saveRowNoLock(cachedObject);
            this.uncommittedCache.remove(cachedObject.getPos());
            this.cache.put(cachedObject.getPos(), cachedObject);
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("saveRow failed", throwable);
            throw Error.error(466, throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String string) {
        if (this.ignoreFirst && this.fileFreePosition == 0L) {
            try {
                this.writeHeader(string);
                this.header = string;
            }
            catch (HsqlException hsqlException) {
                throw new HsqlException(hsqlException, Error.getMessage(467), 467);
            }
            return;
        }
        throw Error.error(486);
    }

    private void writeHeader(String string) {
        try {
            byte[] byArray = null;
            String string2 = string + NL;
            try {
                byArray = string2.getBytes(this.stringEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string2.getBytes();
            }
            this.dataFile.write(byArray, 0, byArray.length);
            this.fileFreePosition = byArray.length;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    public int getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    @Override
    protected void setFileModified() {
        this.fileModified = true;
    }

    private class ByteArray {
        private byte[] buffer;
        private int buflen;

        public ByteArray(int n) {
            this.buffer = new byte[n];
            this.buflen = 0;
        }

        public void append(int n) {
            if (this.buflen >= this.buffer.length) {
                byte[] byArray = new byte[this.buflen + 80];
                System.arraycopy(this.buffer, 0, byArray, 0, this.buflen);
                this.buffer = byArray;
            }
            this.buffer[this.buflen] = (byte)n;
            ++this.buflen;
        }

        public int length() {
            return this.buflen;
        }

        public void setLength(int n) {
            this.buflen = n;
        }

        public String toString() {
            try {
                return new String(this.buffer, 0, this.buflen, TextCache.this.stringEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.buffer, 0, this.buflen);
            }
        }
    }
}

