/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hsqldb.cmdline.SqlTool;
import org.hsqldb.cmdline.SqlToolError;
import org.hsqldb.cmdline.SqltoolRB;
import org.hsqldb.cmdline.sqltool.SqlFileScanner;
import org.hsqldb.cmdline.sqltool.Token;
import org.hsqldb.cmdline.sqltool.TokenList;
import org.hsqldb.cmdline.sqltool.TokenSource;
import org.hsqldb.lib.AppendableException;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.RCData;
import org.hsqldb.lib.StringUtil;

public class SqlFile {
    private static FrameworkLogger logger = FrameworkLogger.getLog(SqlFile.class);
    private static final int DEFAULT_HISTORY_SIZE = 40;
    private boolean executing;
    private boolean permitEmptySqlStatements;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private static String rawPrompt;
    private static Method createArrayOfMethod;
    private String contPrompt = "  +> ";
    private boolean htmlMode;
    private TokenList history;
    private String nullRepToken;
    private String dsvTargetFile;
    private String dsvTargetTable;
    private String dsvConstCols;
    private String dsvRejectFile;
    private String dsvRejectReport;
    private int dsvRecordsPerCommit = 0;
    public static String LS;
    private int maxHistoryLength = 1;
    private boolean reportTimes;
    private Reader reader;
    private String inputStreamLabel;
    private File baseDir;
    static String DEFAULT_FILE_ENCODING;
    private static Pattern specialPattern;
    private static Pattern plPattern;
    private static Pattern foreachPattern;
    private static Pattern ifwhilePattern;
    private static Pattern varsetPattern;
    private static Pattern substitutionPattern;
    private static Pattern slashHistoryPattern;
    private static Pattern historyPattern;
    private static Pattern wincmdPattern;
    private static Pattern useMacroPattern;
    private static Pattern editMacroPattern;
    private static Pattern spMacroPattern;
    private static Pattern sqlMacroPattern;
    private static Pattern integerPattern;
    private static Pattern nameValPairPattern;
    private static Pattern dotPattern;
    private static Pattern commitOccursPattern;
    private static Pattern logPattern;
    private static Pattern arrayPattern;
    private static Map<String, Pattern> nestingPLCommands;
    private SharedFields shared;
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static String revnum;
    private static String DSV_OPTIONS_TEXT;
    private static String D_OPTIONS_TEXT;
    private boolean recursed;
    private PrintWriter pwQuery;
    private PrintWriter pwDsv;
    private boolean continueOnError;
    private SqlFileScanner scanner;
    private Token buffer;
    private boolean preempt;
    private String lastSqlStatement;
    private boolean autoClose = true;
    private boolean doPrepare;
    private String prepareVar;
    private String dsvColDelim;
    private String dsvColSplitter;
    private String dsvSkipPrefix;
    private String dsvRowDelim;
    private String dsvRowSplitter;
    private String dsvSkipCols;
    private boolean dsvTrimAll;
    private static String DSV_X_SYNTAX_MSG;
    private static String DSV_M_SYNTAX_MSG;
    private static String nobufferYetString;
    private static final char[] nonVarChars;
    private boolean plMode;
    private String fetchingVar;
    private boolean silentFetch;
    private boolean fetchBinary;
    private static final String DEFAULT_NULL_REP = "[null]";
    private static final String DEFAULT_ROW_DELIM;
    private static final String DEFAULT_ROW_SPLITTER = "\\r\\n|\\r|\\n";
    private static final String DEFAULT_COL_DELIM = "|";
    private static final String DEFAULT_COL_SPLITTER = "\\|";
    private static final String DEFAULT_SKIP_PREFIX = "#";
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[] listMDSchemaCols;
    private static final int[] listMDIndexCols;
    private static final int[][] listMDTableCols;
    private static final String[] oracleSysSchemas;
    private boolean excludeSysSchemas;
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR = "    ";
    private static final String PRE_TD = "        ";
    int oldestHist = 1;
    byte[] binBuffer;
    private static final int JDBC3_BOOLEAN = 16;
    private static final int JDBC3_DATALINK = 70;

    private void updateUserSettings() {
        this.dsvSkipPrefix = SqlFile.convertEscapes(this.shared.userVars.get("*DSV_SKIP_PREFIX"));
        if (this.dsvSkipPrefix == null) {
            this.dsvSkipPrefix = DEFAULT_SKIP_PREFIX;
        }
        this.dsvSkipCols = this.shared.userVars.get("*DSV_SKIP_COLS");
        this.dsvTrimAll = Boolean.parseBoolean(this.shared.userVars.get("*DSV_TRIM_ALL"));
        this.dsvColDelim = SqlFile.convertEscapes(this.shared.userVars.get("*DSV_COL_DELIM"));
        if (this.dsvColDelim == null) {
            this.dsvColDelim = SqlFile.convertEscapes(this.shared.userVars.get("*CSV_COL_DELIM"));
        }
        if (this.dsvColDelim == null) {
            this.dsvColDelim = DEFAULT_COL_DELIM;
        }
        this.dsvColSplitter = this.shared.userVars.get("*DSV_COL_SPLITTER");
        if (this.dsvColSplitter == null) {
            this.dsvColSplitter = DEFAULT_COL_SPLITTER;
        }
        this.dsvRowDelim = SqlFile.convertEscapes(this.shared.userVars.get("*DSV_ROW_DELIM"));
        if (this.dsvRowDelim == null) {
            this.dsvRowDelim = SqlFile.convertEscapes(this.shared.userVars.get("*CSV_ROW_DELIM"));
        }
        if (this.dsvRowDelim == null) {
            this.dsvRowDelim = DEFAULT_ROW_DELIM;
        }
        this.dsvRowSplitter = this.shared.userVars.get("*DSV_ROW_SPLITTER");
        if (this.dsvRowSplitter == null) {
            this.dsvRowSplitter = DEFAULT_ROW_SPLITTER;
        }
        this.dsvTargetFile = this.shared.userVars.get("*DSV_TARGET_FILE");
        if (this.dsvTargetFile == null) {
            this.dsvTargetFile = this.shared.userVars.get("*CSV_FILEPATH");
        }
        this.dsvTargetTable = this.shared.userVars.get("*DSV_TARGET_TABLE");
        if (this.dsvTargetTable == null) {
            this.dsvTargetTable = this.shared.userVars.get("*CSV_TABLENAME");
        }
        this.dsvConstCols = this.shared.userVars.get("*DSV_CONST_COLS");
        this.dsvRejectFile = this.shared.userVars.get("*DSV_REJECT_FILE");
        this.dsvRejectReport = this.shared.userVars.get("*DSV_REJECT_REPORT");
        if (this.shared.userVars.get("*DSV_RECORDS_PER_COMMIT") != null) {
            try {
                this.dsvRecordsPerCommit = Integer.parseInt(this.shared.userVars.get("*DSV_RECORDS_PER_COMMIT"));
            }
            catch (NumberFormatException numberFormatException) {
                logger.error(SqltoolRB.reject_rpc.getString(this.shared.userVars.get("*DSV_RECORDS_PER_COMMIT")));
                this.shared.userVars.remove("*DSV_REJECT_REPORT");
                this.dsvRecordsPerCommit = 0;
            }
        }
        this.nullRepToken = this.shared.userVars.get("*NULL_REP_TOKEN");
        if (this.nullRepToken == null) {
            this.nullRepToken = this.shared.userVars.get("*CSV_NULL_REP");
        }
        if (this.nullRepToken == null) {
            this.nullRepToken = DEFAULT_NULL_REP;
        }
    }

    public SqlFile(File file) throws IOException {
        this(file, null);
    }

    public SqlFile(File file, String string) throws IOException {
        this(file, string, false);
    }

    public SqlFile(File file, String string, boolean bl) throws IOException {
        this(new InputStreamReader((InputStream)new FileInputStream(file), string == null ? DEFAULT_FILE_ENCODING : string), file.toString(), System.out, string, bl, file.getParentFile());
    }

    public SqlFile(String string, boolean bl) throws IOException {
        this(string == null ? new InputStreamReader(System.in) : new InputStreamReader(System.in, string), "<stdin>", System.out, string, bl, null);
    }

    public SqlFile(Reader reader, String string, PrintStream printStream, String string2, boolean bl, File file) throws IOException {
        this(reader, string, file);
        try {
            this.shared = new SharedFields(printStream);
            this.setEncoding(string2);
            this.continueOnError = this.interactive = bl;
            if (bl) {
                this.history = new TokenList();
                this.maxHistoryLength = 40;
            }
            this.updateUserSettings();
        }
        catch (IOException iOException) {
            this.closeReader();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.closeReader();
            throw runtimeException;
        }
    }

    private SqlFile(SqlFile sqlFile, File file) throws IOException {
        this(sqlFile, new InputStreamReader((InputStream)new FileInputStream(file), sqlFile.shared.encoding == null ? DEFAULT_FILE_ENCODING : sqlFile.shared.encoding), file.toString(), file.getParentFile());
    }

    private SqlFile(SqlFile sqlFile, Reader reader, String string, File file) {
        this(reader, string, file);
        try {
            this.recursed = true;
            this.shared = sqlFile.shared;
            this.plMode = sqlFile.plMode;
            this.interactive = false;
            this.continueOnError = sqlFile.continueOnError;
            this.updateUserSettings();
        }
        catch (RuntimeException runtimeException) {
            this.closeReader();
            throw runtimeException;
        }
    }

    private SqlFile(Reader reader, String string, File file) {
        logger.privlog(Level.FINER, "<init>ting SqlFile instance", null, 2, FrameworkLogger.class);
        if (reader == null) {
            throw new IllegalArgumentException("'reader' may not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("'inputStreamLabel' may not be null");
        }
        this.reader = reader;
        this.inputStreamLabel = string;
        this.baseDir = file == null ? new File(".") : file;
    }

    public void setConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("We don't yet support unsetting the JDBC Connection");
        }
        this.shared.jdbcConn = connection;
    }

    public Connection getConnection() {
        return this.shared.jdbcConn;
    }

    public void setContinueOnError(boolean bl) {
        this.continueOnError = bl;
    }

    public void setMaxHistoryLength(int n) {
        if (this.executing) {
            throw new IllegalStateException("Can't set maxHistoryLength after execute() has been called");
        }
        if (this.reader == null) {
            throw new IllegalStateException("Can't set maxHistoryLength execute() has run");
        }
        this.maxHistoryLength = n;
    }

    public void addMacros(Map<String, Token> map) {
        this.shared.macros.putAll(map);
    }

    public void addUserVars(Map<String, String> map) {
        this.shared.userVars.putAll(map);
    }

    public Map<String, String> getUserVars() {
        return this.shared.userVars;
    }

    public Map<String, Token> getMacros() {
        return this.shared.macros;
    }

    private void setEncoding(String string) throws UnsupportedEncodingException {
        if (string == null) {
            this.shared.encoding = null;
            this.shared.userVars.remove("ENCODING");
            return;
        }
        if (!Charset.isSupported(string)) {
            throw new UnsupportedEncodingException(string);
        }
        this.shared.userVars.put("*ENCODING", string);
        this.shared.encoding = string;
    }

    public void setAutoClose(boolean bl) {
        this.autoClose = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute() throws SqlToolError, SQLException {
        if (this.reader == null) {
            throw new IllegalStateException("Can't call execute() more than once for a single SqlFile instance");
        }
        try {
            this.scanner = new SqlFileScanner(this.reader);
            this.scanner.setStdPrintStream(this.shared.psStd);
            this.scanner.setRawLeadinPrompt(SqltoolRB.raw_leadin.getString());
            if (this.interactive) {
                this.stdprintln(SqltoolRB.SqlFile_banner.getString(revnum));
                this.scanner.setRawPrompt(rawPrompt);
                this.scanner.setSqlPrompt(this.contPrompt);
                this.scanner.setSqltoolPrompt(this.primaryPrompt);
                this.scanner.setInteractive(true);
                if (this.shared.jdbcConn == null) {
                    this.stdprintln("To connect to a data source, use '\\j urlid' or '\\j account password jdbc:url...'");
                }
                this.stdprint(this.primaryPrompt);
            }
            this.scanpass(this.scanner);
        }
        finally {
            try {
                this.closeQueryOutputStream();
                if (this.autoClose) {
                    this.closeReader();
                }
            }
            finally {
                this.reader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReader() {
        if (this.reader == null) {
            return;
        }
        try {
            if (this.scanner != null) {
                try {
                    this.scanner.yyclose();
                }
                catch (IOException iOException) {
                    this.errprintln("Failed to close pipes");
                }
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.reader = null;
        }
    }

    private String nestingCommand(Token token) throws BadSpecial {
        if (token.type != 2) {
            return null;
        }
        String string = token.val.replaceFirst("\\s.*", "");
        if (!nestingPLCommands.containsKey(string)) {
            return null;
        }
        Pattern pattern = nestingPLCommands.get(string);
        if (pattern.matcher(token.val).matches()) {
            return string;
        }
        throw new BadSpecial(SqltoolRB.pl_malformat.getString());
    }

    /*
     * Exception decompiling
     */
    protected synchronized void scanpass(TokenSource var1_1) throws SqlToolError, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[UNCONDITIONALDOLOOP]], but top level block is 55[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBuffHist(Token token) throws BadSpecial, SQLException, SqlToolError {
        if (token.val.length() < 1) {
            throw new BadSpecial(SqltoolRB.bufhist_unspecified.getString());
        }
        char c = token.val.charAt(0);
        String string = token.val.substring(1);
        if (string.trim().length() == 0) {
            string = null;
        }
        switch (c) {
            case 'b': 
            case 'l': {
                this.enforce1charBH(string, 'l');
                if (this.buffer == null) {
                    this.stdprintln(nobufferYetString);
                } else {
                    this.stdprintln(SqltoolRB.editbuffer_contents.getString(this.buffer.reconstitute()));
                }
                return;
            }
            case 'h': {
                this.enforce1charBH(string, 'h');
                this.showHistory();
                return;
            }
            case '?': {
                this.stdprintln(SqltoolRB.buffer_help.getString());
                return;
            }
        }
        Integer n = null;
        Matcher matcher = slashHistoryPattern.matcher(token.val);
        if (matcher.matches()) {
            n = this.historySearch(matcher.group(1));
            if (n == null) {
                this.stdprintln(SqltoolRB.substitution_nomatch.getString());
                return;
            }
        } else {
            matcher = historyPattern.matcher(token.val);
            if (!matcher.matches()) {
                throw new BadSpecial(SqltoolRB.edit_malformat.getString());
            }
            Integer n2 = n = matcher.group(1) == null || matcher.group(1).length() < 1 ? null : Integer.valueOf(matcher.group(1));
        }
        if (matcher.groupCount() != 2) {
            throw new BadSpecial(SqltoolRB.edit_malformat.getString());
        }
        c = matcher.group(2) == null || matcher.group(2).length() < 1 ? (char)'\u0000' : matcher.group(2).charAt(0);
        String string2 = string = c == '\u0000' ? null : matcher.group(2).substring(1);
        if (string != null && string.length() < 1) {
            string = null;
        }
        Token token2 = n == null ? null : this.commandFromHistory(n);
        switch (c) {
            case '\u0000': {
                this.setBuf(token2);
                this.stdprintln(SqltoolRB.buffer_restored.getString(this.buffer.reconstitute()));
                return;
            }
            case ';': {
                this.enforce1charBH(string, ';');
                if (token2 != null) {
                    this.setBuf(token2);
                }
                if (this.buffer == null) {
                    throw new BadSpecial(SqltoolRB.nobuffer_yet.getString());
                }
                this.stdprintln(SqltoolRB.buffer_executing.getString(this.buffer.reconstitute()));
                this.preempt = true;
                return;
            }
            case 'a': {
                if (token2 == null) {
                    token2 = this.buffer;
                }
                if (token2 == null) {
                    throw new BadSpecial(SqltoolRB.nobuffer_yet.getString());
                }
                boolean bl = false;
                if (string != null && string.trim().charAt(string.trim().length() - 1) == ';') {
                    if ((string = string.substring(0, string.lastIndexOf(59))).trim().length() < 1) {
                        throw new BadSpecial(SqltoolRB.append_empty.getString());
                    }
                    bl = true;
                }
                Token token3 = new Token(token2.type, token2.val, token2.line);
                if (string != null) {
                    token3.val = token3.val + string;
                }
                this.setBuf(token3);
                if (bl) {
                    this.stdprintln(SqltoolRB.buffer_executing.getString(this.buffer.reconstitute()));
                    this.preempt = true;
                    return;
                }
                if (this.interactive) {
                    this.scanner.setMagicPrefix(token3.reconstitute());
                }
                switch (token3.type) {
                    case 0: {
                        this.scanner.setRequestedState(2);
                        break;
                    }
                    case 1: {
                        this.scanner.setRequestedState(12);
                        break;
                    }
                    case 2: {
                        this.scanner.setRequestedState(14);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal assertion failed.  Appending to unexpected type: " + token3.getTypeString());
                    }
                }
                this.scanner.setCommandBuffer(token3.val);
                return;
            }
            case 'w': {
                if (token2 == null) {
                    token2 = this.buffer;
                }
                if (token2 == null) {
                    throw new BadSpecial(SqltoolRB.nobuffer_yet.getString());
                }
                if (string == null) {
                    throw new BadSpecial(SqltoolRB.destfile_demand.getString());
                }
                String string3 = this.dereferenceAt(this.dereference(string.trim(), false));
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3, true), this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding));
                    printWriter.println(token2.reconstitute(true));
                    printWriter.flush();
                }
                catch (Exception exception) {
                    throw new BadSpecial(SqltoolRB.file_appendfail.getString(string3), exception);
                }
                finally {
                    if (printWriter != null) {
                        try {
                            printWriter.close();
                        }
                        finally {
                            printWriter = null;
                        }
                    }
                }
                return;
            }
            case 's': {
                boolean bl = false;
                boolean bl2 = false;
                if (token2 == null) {
                    token2 = this.buffer;
                }
                if (token2 == null) {
                    throw new BadSpecial(SqltoolRB.nobuffer_yet.getString());
                }
                try {
                    String string4;
                    if (string == null || string.length() < 3) {
                        throw new BadSubst(SqltoolRB.substitution_malformat.getString());
                    }
                    Matcher matcher2 = substitutionPattern.matcher(string);
                    if (!matcher2.matches()) {
                        throw new BadSubst(SqltoolRB.substitution_malformat.getString());
                    }
                    if (matcher2.groupCount() < 3 || matcher2.groupCount() > 4) {
                        throw new RuntimeException("Internal assertion failed.  Matched substitution pattern, but captured " + matcher2.groupCount() + " groups");
                    }
                    String string5 = string4 = matcher2.groupCount() > 3 && matcher2.group(4) != null ? new String(matcher2.group(4)) : null;
                    if (string4 != null) {
                        if (string4.indexOf(59) > -1) {
                            bl = true;
                            string4 = string4.replaceFirst(";", "");
                        }
                        if (string4.indexOf(103) > -1) {
                            bl2 = true;
                            string4 = string4.replaceFirst("g", "");
                        }
                    }
                    Matcher matcher3 = Pattern.compile("(?s" + (string4 == null ? "" : string4) + ')' + matcher2.group(2)).matcher(token2.val);
                    Token token4 = new Token(token2.type, bl2 ? matcher3.replaceAll(matcher2.group(3)) : matcher3.replaceFirst(matcher2.group(3)), token2.line);
                    if (token4.val.equals(token2.val)) {
                        this.stdprintln(SqltoolRB.substitution_nomatch.getString());
                        return;
                    }
                    this.setBuf(token4);
                    this.stdprintln(bl ? SqltoolRB.buffer_executing.getString(this.buffer.reconstitute()) : SqltoolRB.editbuffer_contents.getString(this.buffer.reconstitute()));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new BadSpecial(SqltoolRB.substitution_syntax.getString(), patternSyntaxException);
                }
                catch (BadSubst badSubst) {
                    throw new BadSpecial(SqltoolRB.substitution_syntax.getString());
                }
                if (bl) {
                    this.preempt = true;
                }
                return;
            }
        }
        throw new BadSpecial(SqltoolRB.buffer_unknown.getString(Character.toString(c)));
    }

    private void enforce1charSpecial(String string, char c) throws BadSpecial {
        if (string.length() != 1) {
            throw new BadSpecial(SqltoolRB.special_extrachars.getString(Character.toString(c), string.substring(1)));
        }
    }

    private void enforce1charBH(String string, char c) throws BadSpecial {
        if (string != null) {
            throw new BadSpecial(SqltoolRB.buffer_extrachars.getString(Character.toString(c), string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSpecial(String string) throws BadSpecial, QuitNow, SQLException, SqlToolError {
        String string2;
        String string3 = string2 = string == null ? this.buffer.val : string;
        if (string2.length() < 1) {
            throw new BadSpecial(SqltoolRB.special_unspecified.getString());
        }
        Matcher matcher = specialPattern.matcher(this.plMode ? this.dereference(string2, false) : string2);
        if (!matcher.matches()) {
            throw new BadSpecial(SqltoolRB.special_malformat.getString());
        }
        if (matcher.groupCount() < 1 || matcher.groupCount() > 2) {
            throw new RuntimeException("Internal assertion failed.  Pattern matched, yet captured " + matcher.groupCount() + " groups");
        }
        String string4 = matcher.group(1);
        String string5 = matcher.groupCount() > 1 ? matcher.group(2) : null;
        switch (string4.charAt(0)) {
            case 'q': {
                this.enforce1charSpecial(string4, 'q');
                if (string5 != null) {
                    throw new QuitNow(string5);
                }
                throw new QuitNow();
            }
            case 'H': {
                this.enforce1charSpecial(string4, 'H');
                this.htmlMode = !this.htmlMode;
                this.stdprintln(SqltoolRB.html_mode.getString(Boolean.toString(this.htmlMode)));
                return;
            }
            case 'm': {
                int n;
                if (string4.equals("m?") || string4.equals("m") && string5 != null && string5.equals("?")) {
                    this.stdprintln(DSV_OPTIONS_TEXT + LS + DSV_M_SYNTAX_MSG);
                    return;
                }
                if (string4.length() != 1 || string5 == null) {
                    throw new BadSpecial(DSV_M_SYNTAX_MSG);
                }
                boolean bl = string5.charAt(string5.length() - 1) == '*';
                String string6 = null;
                if (bl) {
                    if ((string5 = string5.substring(0, string5.length() - 1).trim()).length() < 1) {
                        throw new BadSpecial(DSV_M_SYNTAX_MSG);
                    }
                } else {
                    string6 = this.dsvSkipPrefix;
                }
                if ((n = string5.indexOf(" :")) > -1 && n < string5.length() - 2) {
                    string6 = string5.substring(n + 2);
                    string5 = string5.substring(0, n).trim();
                }
                this.importDsv(this.dereferenceAt(string5), string6);
                return;
            }
            case 'x': {
                this.requireConnection();
                if (string4.equals("x?") || string4.equals("x") && string5 != null && string5.equals("?")) {
                    this.stdprintln(DSV_OPTIONS_TEXT + LS + DSV_X_SYNTAX_MSG);
                    return;
                }
                try {
                    String string7;
                    if (string4.length() != 1 || string5 == null) {
                        throw new BadSpecial(DSV_X_SYNTAX_MSG);
                    }
                    String string8 = string7 = string5.indexOf(32) > 0 ? null : string5;
                    if (this.dsvTargetFile == null && string7 == null) {
                        throw new BadSpecial(SqltoolRB.dsv_targetfile_demand.getString());
                    }
                    File file = new File(this.dsvTargetFile == null ? string7 + ".dsv" : this.dereferenceAt(this.dsvTargetFile));
                    this.pwDsv = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding));
                    ResultSet resultSet = this.shared.jdbcConn.createStatement().executeQuery(string7 == null ? string5 : "SELECT * FROM " + string7);
                    try {
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        int[] nArray = null;
                        if (this.dsvSkipCols != null) {
                            int n;
                            HashSet<String> hashSet = new HashSet<String>();
                            for (String string9 : this.dsvSkipCols.split(this.dsvColDelim, -1)) {
                                hashSet.add(string9.trim().toLowerCase());
                            }
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                                if (hashSet.remove(resultSetMetaData.getColumnName(n).toLowerCase())) continue;
                                arrayList.add(n);
                            }
                            if (arrayList.size() < 1) {
                                throw new BadSpecial(SqltoolRB.dsv_nocolsleft.getString(this.dsvSkipCols));
                            }
                            if (hashSet.size() > 0) {
                                throw new BadSpecial(SqltoolRB.dsv_skipcols_missing.getString(((Object)hashSet).toString()));
                            }
                            nArray = new int[arrayList.size()];
                            for (n = 0; n < nArray.length; ++n) {
                                nArray[n] = (Integer)arrayList.get(n);
                            }
                        }
                        this.displayResultSet(null, resultSet, nArray, null);
                    }
                    finally {
                        resultSet.close();
                    }
                    this.pwDsv.flush();
                    this.stdprintln(SqltoolRB.file_wrotechars.getString(Long.toString(file.length()), file.toString()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new BadSpecial(SqltoolRB.file_writefail.getString(string5), fileNotFoundException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new BadSpecial(SqltoolRB.file_writefail.getString(string5), unsupportedEncodingException);
                }
                finally {
                    if (this.pwDsv != null) {
                        try {
                            this.pwDsv.close();
                        }
                        finally {
                            this.pwDsv = null;
                        }
                    }
                }
                return;
            }
            case 'd': {
                this.requireConnection();
                if (string4.equals("d?") || string4.equals("d") && string5 != null && string5.equals("?")) {
                    this.stdprintln(D_OPTIONS_TEXT);
                    return;
                }
                if (string4.length() == 2) {
                    this.listTables(string4.charAt(1), string5);
                    return;
                }
                if (string4.length() == 1 && string5 != null) {
                    try {
                        int n = string5.indexOf(32);
                        if (n < 0) {
                            this.describe(string5, null);
                        } else {
                            this.describe(string5.substring(0, n), string5.substring(n + 1).trim());
                        }
                        return;
                    }
                    catch (SQLException sQLException) {
                        throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString(), sQLException);
                    }
                }
                throw new BadSpecial(SqltoolRB.special_d_like.getString());
            }
            case 'o': {
                this.enforce1charSpecial(string4, 'o');
                if (string5 == null) {
                    if (this.pwQuery == null) {
                        throw new BadSpecial(SqltoolRB.outputfile_nonetoclose.getString());
                    }
                    this.closeQueryOutputStream();
                    return;
                }
                if (this.pwQuery != null) {
                    this.stdprintln(SqltoolRB.outputfile_reopening.getString());
                    this.closeQueryOutputStream();
                }
                try {
                    this.pwQuery = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.dereferenceAt(string5), true), this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding));
                    this.pwQuery.println((this.htmlMode ? "<HTML>" + LS + "<!--" : DEFAULT_SKIP_PREFIX) + " " + new Date() + ".  " + SqltoolRB.outputfile_header.getString(this.getClass().getName()) + (this.htmlMode ? " -->" + LS + LS + "<BODY>" : LS));
                    this.pwQuery.flush();
                }
                catch (Exception exception) {
                    throw new BadSpecial(SqltoolRB.file_writefail.getString(string5), exception);
                }
                return;
            }
            case 'i': {
                this.enforce1charSpecial(string4, 'i');
                if (string5 == null) {
                    throw new BadSpecial(SqltoolRB.sqlfile_name_demand.getString());
                }
                try {
                    new SqlFile(this, new File(this.dereferenceAt(string5))).execute();
                }
                catch (ContinueException continueException) {
                    throw continueException;
                }
                catch (BreakException breakException) {
                    String string10 = breakException.getMessage();
                    if (string10 != null && !string10.equals("file")) {
                        throw breakException;
                    }
                }
                catch (QuitNow quitNow) {
                    throw quitNow;
                }
                catch (Exception exception) {
                    throw new BadSpecial(SqltoolRB.sqlfile_execute_fail.getString(string5), exception);
                }
                return;
            }
            case 'p': {
                this.enforce1charSpecial(string4, 'p');
                if (string5 == null) {
                    this.stdprintln(true);
                } else {
                    this.stdprintln(string5, true);
                }
                return;
            }
            case 'l': {
                if (string4.equals("l?") && string5 == null || string4.equals("l") && string5 != null && string5.equals("?")) {
                    this.stdprintln(SqltoolRB.log_syntax.getString());
                } else {
                    Matcher matcher2;
                    this.enforce1charSpecial(string4, 'l');
                    Matcher matcher3 = matcher2 = string5 == null ? null : logPattern.matcher(string5.trim());
                    if (matcher2 == null || !matcher2.matches()) {
                        throw new BadSpecial(SqltoolRB.log_syntax_error.getString());
                    }
                    String string11 = matcher2.group(1);
                    Level level = null;
                    if (string11.equalsIgnoreCase("FINER")) {
                        level = Level.FINER;
                    } else if (string11.equalsIgnoreCase("WARNING")) {
                        level = Level.WARNING;
                    } else if (string11.equalsIgnoreCase("SEVERE")) {
                        level = Level.SEVERE;
                    } else if (string11.equalsIgnoreCase("INFO")) {
                        level = Level.INFO;
                    } else if (string11.equalsIgnoreCase("FINEST")) {
                        level = Level.FINEST;
                    }
                    if (level == null) {
                        throw new RuntimeException("Internal assertion failed.   Unexpected Level string: " + string11);
                    }
                    logger.enduserlog(level, matcher2.group(2));
                }
                return;
            }
            case 'a': {
                this.requireConnection();
                this.enforce1charSpecial(string4, 'a');
                if (string5 != null) {
                    this.shared.jdbcConn.setAutoCommit(Boolean.parseBoolean(string5));
                    this.shared.possiblyUncommitteds = false;
                }
                this.stdprintln(SqltoolRB.a_setting.getString(Boolean.toString(this.shared.jdbcConn.getAutoCommit())));
                return;
            }
            case 'j': {
                try {
                    this.enforce1charSpecial(string4, 'j');
                    String string12 = null;
                    String string13 = null;
                    String string14 = null;
                    String string15 = null;
                    boolean bl = false;
                    String[] stringArray = string5 == null ? new String[]{} : string5.split("\\s+", 3);
                    switch (stringArray.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            string12 = stringArray[0];
                            break;
                        }
                        case 2: {
                            string13 = stringArray[0];
                            string14 = "";
                            string15 = stringArray[1];
                            break;
                        }
                        case 3: {
                            string13 = stringArray[0];
                            string14 = stringArray[1];
                            string15 = stringArray[2];
                        }
                    }
                    if (stringArray.length > 0 && this.shared.jdbcConn != null) {
                        try {
                            bl = this.shared.jdbcConn.getAutoCommit();
                            this.shared.jdbcConn.close();
                            this.shared.possiblyUncommitteds = false;
                            this.shared.jdbcConn = null;
                            this.stdprintln(SqltoolRB.disconnect_success.getString());
                        }
                        catch (SQLException sQLException) {
                            throw new BadSpecial(SqltoolRB.disconnect_failure.getString(), sQLException);
                        }
                    }
                    if (string12 != null || string13 != null) {
                        try {
                            if (string12 != null) {
                                this.shared.jdbcConn = new RCData(new File(SqlTool.DEFAULT_RCFILE), string12).getConnection();
                            } else if (string13 != null) {
                                this.shared.jdbcConn = DriverManager.getConnection(string15, string13, string14);
                            }
                            this.shared.possiblyUncommitteds = false;
                            this.shared.jdbcConn.setAutoCommit(bl);
                        }
                        catch (Exception exception) {
                            throw new BadSpecial("Failed to connect", exception);
                        }
                    }
                    this.displayConnBanner();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return;
                }
                return;
            }
            case 'v': {
                this.requireConnection();
                this.enforce1charSpecial(string4, 'v');
                if (string5 != null) {
                    if (integerPattern.matcher(string5).matches()) {
                        this.shared.jdbcConn.setTransactionIsolation(Integer.parseInt(string5));
                    } else {
                        RCData.setTI(this.shared.jdbcConn, string5);
                    }
                }
                this.stdprintln(SqltoolRB.transiso_report.getString(this.shared.jdbcConn.isReadOnly() ? "R/O " : "R/W ", RCData.tiToString(this.shared.jdbcConn.getTransactionIsolation())));
                return;
            }
            case '=': {
                this.requireConnection();
                this.enforce1charSpecial(string4, '=');
                this.shared.jdbcConn.commit();
                this.shared.possiblyUncommitteds = false;
                this.stdprintln(SqltoolRB.committed.getString());
                return;
            }
            case 'b': {
                if (string4.length() == 1) {
                    if (string5 != null) {
                        throw new BadSpecial(SqltoolRB.special_b_malformat.getString());
                    }
                    this.fetchBinary = true;
                    return;
                }
                if (string4.charAt(1) == 'p') {
                    if (string5 != null) {
                        throw new BadSpecial(SqltoolRB.special_b_malformat.getString());
                    }
                    this.doPrepare = true;
                    return;
                }
                if (string4.charAt(1) != 'd' && string4.charAt(1) != 'l' || string5 == null) {
                    throw new BadSpecial(SqltoolRB.special_b_malformat.getString());
                }
                File file = new File(this.dereferenceAt(string5));
                try {
                    if (string4.charAt(1) == 'd') {
                        this.dump(file);
                    } else {
                        this.binBuffer = SqlFile.loadBinary(file);
                        this.stdprintln(SqltoolRB.binary_loadedbytesinto.getString(this.binBuffer.length));
                    }
                }
                catch (BadSpecial badSpecial) {
                    throw badSpecial;
                }
                catch (IOException iOException) {
                    throw new BadSpecial(SqltoolRB.binary_filefail.getString(string5), iOException);
                }
                return;
            }
            case 't': {
                this.enforce1charSpecial(string4, '=');
                if (string5 != null) {
                    this.reportTimes = Boolean.parseBoolean(string5);
                }
                this.stdprintln(SqltoolRB.exectime_reporting.getString(Boolean.toString(this.reportTimes)));
                return;
            }
            case '*': 
            case 'c': {
                this.enforce1charSpecial(string4, '=');
                if (string5 != null) {
                    this.continueOnError = Boolean.parseBoolean(string5);
                }
                this.stdprintln(SqltoolRB.c_setting.getString(Boolean.toString(this.continueOnError)));
                return;
            }
            case '?': {
                this.stdprintln(SqltoolRB.special_help.getString());
                return;
            }
            case '!': {
                byte[] byArray = new byte[1024];
                String string16 = (string4.length() == 1 ? "" : string4.substring(1)) + (string4.length() > 1 && string5 != null ? " " : "") + (string5 == null ? "" : string5);
                if (string16.trim().length() < 1) {
                    throw new BadSpecial(SqltoolRB.bang_incomplete.getString());
                }
                Process process = null;
                try {
                    int n;
                    Runtime runtime = Runtime.getRuntime();
                    process = wincmdPattern == null ? runtime.exec(string16) : runtime.exec(SqlFile.genWinArgs(string16));
                    process.getOutputStream().close();
                    InputStream inputStream = process.getInputStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        this.stdprint(new String(byArray, 0, n));
                    }
                    inputStream.close();
                    inputStream = process.getErrorStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        String string17 = new String(byArray, 0, n);
                        if (string17.endsWith(LS)) {
                            if (string17.length() == LS.length()) continue;
                            string17 = string17.substring(0, string17.length() - LS.length());
                        }
                        logger.severe(string17);
                    }
                    inputStream.close();
                    inputStream = null;
                    if (process.waitFor() != 0) {
                        throw new BadSpecial(SqltoolRB.bang_command_fail.getString(string16));
                    }
                }
                catch (BadSpecial badSpecial) {
                    throw badSpecial;
                }
                catch (Exception exception) {
                    throw new BadSpecial(SqltoolRB.bang_command_fail.getString(string16), exception);
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                }
                return;
            }
        }
        throw new BadSpecial(SqltoolRB.special_unknown.getString(Character.toString(string4.charAt(0))));
    }

    static int pastName(String string, int n) {
        String string2 = string.substring(n);
        int n2 = string.length();
        for (char c : nonVarChars) {
            int n3 = string2.indexOf(c);
            if (n3 <= -1 || n3 >= n2) continue;
            n2 = n3;
        }
        return n + n2;
    }

    private String dereference(String string, boolean bl) throws SqlToolError {
        boolean bl2;
        String string2;
        int n;
        String string3;
        String string4;
        int n2;
        if (string.length() < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl && string.trim().charAt(0) == '/') {
            int n3 = string.indexOf(47);
            n2 = SqlFile.pastName(string.substring(n3 + 1), 0);
            if (n2 < 1) {
                throw new SqlToolError(SqltoolRB.plalias_malformat.getString());
            }
            string4 = string.substring(n3 + 1, n3 + 1 + n2);
            string3 = this.shared.userVars.get(string4);
            if (string3 == null) {
                throw new SqlToolError(SqltoolRB.plvar_undefined.getString(string4));
            }
            stringBuffer.replace(n3, n3 + 1 + n2, this.shared.userVars.get(string4));
        }
        int n4 = 0;
        while ((n = (string2 = stringBuffer.toString()).indexOf("${")) >= 0) {
            n2 = string2.indexOf(125, n + 2);
            if (n2 == n + 2) {
                throw new SqlToolError(SqltoolRB.sysprop_empty.getString());
            }
            if (n2 < 0) {
                throw new SqlToolError(SqltoolRB.sysprop_unterminated.getString());
            }
            bl2 = string2.charAt(n + 2) == ':';
            string4 = string2.substring(n + (bl2 ? 3 : 2), n2);
            if (n4++ > 10000) {
                throw new SqlToolError(SqltoolRB.var_infinite.getString(string4));
            }
            string3 = System.getProperty(string4);
            if (string3 == null) {
                if (bl2) {
                    string3 = "";
                } else {
                    throw new SqlToolError(SqltoolRB.sysprop_undefined.getString(string4));
                }
            }
            stringBuffer.replace(n, n2 + 1, string3);
        }
        n4 = 0;
        while ((n = (string2 = stringBuffer.toString()).indexOf("*{")) >= 0) {
            n2 = string2.indexOf(125, n + 2);
            if (n2 == n + 2) {
                throw new SqlToolError(SqltoolRB.plvar_nameempty.getString());
            }
            if (n2 < 0) {
                throw new SqlToolError(SqltoolRB.plvar_unterminated.getString());
            }
            bl2 = string2.charAt(n + 2) == ':';
            string4 = string2.substring(n + (bl2 ? 3 : 2), n2);
            if (n4++ > 100000) {
                throw new SqlToolError(SqltoolRB.var_infinite.getString(string4));
            }
            string3 = this.shared.userVars.get(string4);
            if (string3 == null) {
                if (bl2) {
                    string3 = "";
                } else {
                    throw new SqlToolError(SqltoolRB.plvar_undefined.getString(string4));
                }
            }
            stringBuffer.replace(n, n2 + 1, string3);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBlock(Token token) throws BadSpecial, SqlToolError {
        Matcher matcher = plPattern.matcher(this.dereference(token.val, false));
        if (!matcher.matches()) {
            throw new BadSpecial(SqltoolRB.pl_malformat.getString());
        }
        if (matcher.groupCount() < 1 || matcher.group(1) == null) {
            this.plMode = true;
            this.stdprintln(SqltoolRB.pl_expansionmode.getString("on"));
            return;
        }
        String[] stringArray = matcher.group(1).split("\\s+", -1);
        this.plMode = true;
        if (stringArray[0].equals("foreach")) {
            Matcher matcher2 = foreachPattern.matcher(this.dereference(token.val, false));
            if (!matcher2.matches()) {
                throw new BadSpecial(SqltoolRB.foreach_malformat.getString());
            }
            if (matcher2.groupCount() != 2) {
                throw new RuntimeException("Internal assertion failed.  foreach pattern matched, but captured " + matcher2.groupCount() + " groups");
            }
            String string = matcher2.group(1);
            if (string.indexOf(58) > -1) {
                throw new BadSpecial(SqltoolRB.plvar_nocolon.getString());
            }
            String[] stringArray2 = matcher2.group(2).split("\\s+", -1);
            String string2 = this.shared.userVars.get(string);
            try {
                for (String string3 : stringArray2) {
                    try {
                        this.shared.userVars.put(string, string3);
                        this.updateUserSettings();
                        boolean bl = this.recursed;
                        this.recursed = true;
                        try {
                            this.scanpass(token.nestedBlock.dup());
                        }
                        finally {
                            this.recursed = bl;
                        }
                    }
                    catch (ContinueException continueException) {
                        String string4 = continueException.getMessage();
                        if (string4 == null || string4.equals("foreach")) continue;
                        throw continueException;
                    }
                }
            }
            catch (BreakException breakException) {
                String string5 = breakException.getMessage();
                if (string5 != null && !string5.equals("foreach")) {
                    throw breakException;
                }
            }
            catch (QuitNow quitNow) {
                throw quitNow;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BadSpecial(SqltoolRB.pl_block_fail.getString(), exception);
            }
            if (string2 == null) {
                this.shared.userVars.remove(string);
                this.updateUserSettings();
                return;
            } else {
                this.shared.userVars.put(string, string2);
            }
            return;
        }
        if (!stringArray[0].equals("if") && !stringArray[0].equals("while")) throw new BadSpecial(SqltoolRB.pl_unknown.getString(stringArray[0]));
        Matcher matcher3 = ifwhilePattern.matcher(this.dereference(token.val, false));
        if (!matcher3.matches()) {
            throw new BadSpecial(SqltoolRB.ifwhile_malformat.getString());
        }
        if (matcher3.groupCount() != 1) {
            throw new RuntimeException("Internal assertion failed.  if/while pattern matched, but captured " + matcher3.groupCount() + " groups");
        }
        String[] stringArray3 = matcher3.group(1).replaceAll("!([a-zA-Z0-9*])", "! $1").replaceAll("([a-zA-Z0-9*])!", "$1 !").split("\\s+", -1);
        if (stringArray[0].equals("if")) {
            try {
                if (!this.eval(stringArray3)) return;
                boolean bl = this.recursed;
                this.recursed = true;
                try {
                    this.scanpass(token.nestedBlock.dup());
                    return;
                }
                finally {
                    this.recursed = bl;
                }
            }
            catch (BreakException breakException) {
                String string = breakException.getMessage();
                if (string != null && string.equals("if")) return;
                throw breakException;
            }
            catch (ContinueException continueException) {
                throw continueException;
            }
            catch (QuitNow quitNow) {
                throw quitNow;
            }
            catch (BadSpecial badSpecial) {
                badSpecial.appendMessage(SqltoolRB.if_malformat.getString());
                throw badSpecial;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BadSpecial(SqltoolRB.pl_block_fail.getString(), exception);
            }
        }
        if (!stringArray[0].equals("while")) throw new RuntimeException(SqltoolRB.pl_unknown.getString(stringArray[0]));
        try {
            while (this.eval(stringArray3)) {
                try {
                    boolean bl = this.recursed;
                    this.recursed = true;
                    try {
                        this.scanpass(token.nestedBlock.dup());
                    }
                    finally {
                        this.recursed = bl;
                    }
                }
                catch (ContinueException continueException) {
                    String string = continueException.getMessage();
                    if (string == null || string.equals("while")) continue;
                    throw continueException;
                    return;
                }
            }
        }
        catch (BreakException breakException) {
            String string = breakException.getMessage();
            if (string == null || string.equals("while")) return;
            throw breakException;
        }
        catch (QuitNow quitNow) {
            throw quitNow;
        }
        catch (BadSpecial badSpecial) {
            badSpecial.appendMessage(SqltoolRB.while_malformat.getString());
            throw badSpecial;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BadSpecial(SqltoolRB.pl_block_fail.getString(), exception);
        }
    }

    private void processPL(String string) throws BadSpecial, SqlToolError {
        String string2 = string == null ? this.buffer.val : string;
        Matcher matcher = plPattern.matcher(this.dereference(string2, false));
        if (!matcher.matches()) {
            throw new BadSpecial(SqltoolRB.pl_malformat.getString());
        }
        if (matcher.groupCount() < 1 || matcher.group(1) == null) {
            this.plMode = true;
            this.stdprintln(SqltoolRB.pl_expansionmode.getString("on"));
            return;
        }
        String[] stringArray = matcher.group(1).split("\\s+", -1);
        if (stringArray[0].charAt(0) == '?') {
            this.stdprintln(SqltoolRB.pl_help.getString());
            return;
        }
        this.plMode = true;
        if (stringArray[0].equals("end")) {
            throw new BadSpecial(SqltoolRB.end_noblock.getString());
        }
        if (stringArray[0].equals("continue")) {
            if (stringArray.length > 1) {
                if (stringArray.length == 2 && (stringArray[1].equals("foreach") || stringArray[1].equals("while"))) {
                    throw new ContinueException(stringArray[1]);
                }
                throw new BadSpecial(SqltoolRB.continue_syntax.getString());
            }
            throw new ContinueException();
        }
        if (stringArray[0].equals("break")) {
            if (stringArray.length > 1) {
                if (stringArray.length == 2 && (stringArray[1].equals("foreach") || stringArray[1].equals("if") || stringArray[1].equals("while") || stringArray[1].equals("file"))) {
                    throw new BreakException(stringArray[1]);
                }
                throw new BadSpecial(SqltoolRB.break_syntax.getString());
            }
            throw new BreakException();
        }
        if (stringArray[0].equals("list") || stringArray[0].equals("listvalues") || stringArray[0].equals("listsysprops")) {
            boolean bl;
            boolean bl2 = stringArray[0].equals("listsysprops");
            boolean bl3 = bl = stringArray[0].equals("listvalues") || bl2;
            if (stringArray.length == 1) {
                this.stdprint(this.formatNicely(bl2 ? System.getProperties() : this.shared.userVars, bl));
            } else {
                if (bl) {
                    this.stdprintln(SqltoolRB.pl_list_parens.getString());
                } else {
                    this.stdprintln(SqltoolRB.pl_list_lengths.getString());
                }
                String[] stringArray2 = stringArray;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string3;
                    String string4 = (String)(bl2 ? System.getProperties() : this.shared.userVars).get(string3 = stringArray2[i]);
                    if (string4 == null) continue;
                    this.stdprintln(PRE_TR + string3 + ": " + (bl ? "(" + string4 + ')' : Integer.toString(string4.length())));
                }
            }
            return;
        }
        if (stringArray[0].equals("dump") || stringArray[0].equals("load")) {
            if (stringArray.length != 3) {
                throw new BadSpecial(SqltoolRB.dumpload_malformat.getString());
            }
            String string5 = stringArray[1];
            if (string5.indexOf(58) > -1) {
                throw new BadSpecial(SqltoolRB.plvar_nocolon.getString());
            }
            File file = new File(this.dereferenceAt(stringArray[2]));
            try {
                if (stringArray[0].equals("dump")) {
                    this.dump(string5, file);
                } else {
                    this.load(string5, file, this.shared.encoding);
                }
            }
            catch (IOException iOException) {
                throw new BadSpecial(SqltoolRB.dumpload_fail.getString(string5, file.toString()), iOException);
            }
            return;
        }
        if (stringArray[0].equals("prepare")) {
            if (stringArray.length != 2) {
                throw new BadSpecial(SqltoolRB.prepare_malformat.getString());
            }
            if (this.shared.userVars.get(stringArray[1]) == null) {
                throw new BadSpecial(SqltoolRB.plvar_undefined.getString(stringArray[1]));
            }
            this.prepareVar = stringArray[1];
            this.doPrepare = true;
            return;
        }
        matcher = varsetPattern.matcher(this.dereference(string2, false));
        if (!matcher.matches()) {
            throw new BadSpecial(SqltoolRB.pl_unknown.getString(stringArray[0]));
        }
        if (matcher.groupCount() < 2 || matcher.groupCount() > 3) {
            throw new RuntimeException("varset pattern matched but captured " + matcher.groupCount() + " groups");
        }
        String string6 = matcher.group(1);
        if (string6.indexOf(58) > -1) {
            throw new BadSpecial(SqltoolRB.plvar_nocolon.getString());
        }
        switch (matcher.group(2).charAt(0)) {
            case '_': {
                this.silentFetch = true;
            }
            case '~': {
                if (matcher.groupCount() > 2 && matcher.group(3) != null) {
                    throw new BadSpecial(SqltoolRB.plvar_tildedash_nomoreargs.getString(matcher.group(3)));
                }
                this.shared.userVars.remove(string6);
                this.updateUserSettings();
                this.fetchingVar = string6;
                return;
            }
            case '=': {
                if (this.fetchingVar != null && this.fetchingVar.equals(string6)) {
                    this.fetchingVar = null;
                }
                if (string6.equals("*ENCODING")) {
                    try {
                        this.setEncoding(matcher.group(3));
                        return;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new BadSpecial(SqltoolRB.encode_fail.getString(matcher.group(3)));
                    }
                }
                if (matcher.groupCount() > 2 && matcher.group(3) != null) {
                    this.shared.userVars.put(string6, matcher.group(3));
                } else {
                    this.shared.userVars.remove(string6);
                }
                this.updateUserSettings();
                return;
            }
        }
        throw new BadSpecial(SqltoolRB.pl_unknown.getString(stringArray[0]));
    }

    private void stdprint(String string) {
        this.stdprint(string, false);
    }

    private void stdprintln(String string) {
        this.stdprintln(string, false);
    }

    private void stdprintln(boolean bl) {
        if (this.shared.psStd != null) {
            if (this.htmlMode) {
                this.shared.psStd.println("<BR>");
            } else {
                this.shared.psStd.println();
            }
        }
        if (bl && this.pwQuery != null) {
            if (this.htmlMode) {
                this.pwQuery.println("<BR>");
            } else {
                this.pwQuery.println();
            }
            this.pwQuery.flush();
        }
    }

    private void errprintln(String string) {
        if (this.shared.psStd != null && this.htmlMode) {
            this.shared.psStd.println("<DIV style='color:white; background: red; font-weight: bold'>" + string + "</DIV>");
        } else {
            logger.privlog(Level.SEVERE, string, null, 5, SqlFile.class);
        }
    }

    private void stdprint(String string, boolean bl) {
        if (this.shared.psStd != null) {
            this.shared.psStd.print(this.htmlMode ? "<P>" + string + "</P>" : string);
        }
        if (bl && this.pwQuery != null) {
            this.pwQuery.print(this.htmlMode ? "<P>" + string + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    private void stdprintln(String string, boolean bl) {
        this.shared.psStd.println(this.htmlMode ? "<P>" + string + "</P>" : string);
        if (bl && this.pwQuery != null) {
            this.pwQuery.println(this.htmlMode ? "<P>" + string + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentSchema() throws BadSpecial, SqlToolError {
        this.requireConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.shared.jdbcConn.createStatement();
            resultSet = statement.executeQuery("VALUES CURRENT_SCHEMA");
            if (!resultSet.next()) {
                throw new BadSpecial(SqltoolRB.no_vendor_schemaspt.getString());
            }
            String string = resultSet.getString(1);
            if (string == null) {
                throw new BadSpecial(SqltoolRB.schemaname_retrieval_fail.getString());
            }
            String string2 = string;
            return string2;
        }
        catch (SQLException sQLException) {
            throw new BadSpecial(SqltoolRB.no_vendor_schemaspt.getString());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    resultSet = null;
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    statement = null;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listTables(char c, String string) throws BadSpecial, SqlToolError {
        this.requireConnection();
        String string2 = null;
        int[] nArray = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = "";
        String string4 = string;
        try {
            Object object;
            DatabaseMetaData databaseMetaData = this.shared.jdbcConn.getMetaData();
            String string5 = databaseMetaData.getDatabaseProductName();
            int n = 0;
            int n2 = 0;
            if (string5.indexOf("HSQL") > -1) {
                try {
                    n = databaseMetaData.getDatabaseMajorVersion();
                    n2 = databaseMetaData.getDatabaseMinorVersion();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    n = 2;
                    n2 = 0;
                }
            }
            stringArray = new String[1];
            switch (c) {
                case '*': {
                    stringArray = null;
                    break;
                }
                case 'S': {
                    if (string5.indexOf("Oracle") > -1) {
                        this.errprintln(SqltoolRB.vendor_oracle_dS.getString());
                        stringArray[0] = "TABLE";
                        string2 = "SYS";
                        stringArray2 = oracleSysSchemas;
                        break;
                    }
                    stringArray[0] = "SYSTEM TABLE";
                    break;
                }
                case 's': {
                    if (string5.indexOf("HSQL") > -1) {
                        if (string4 != null && ((Matcher)(object = dotPattern.matcher(string4))).matches()) {
                            string4 = ((Matcher)object).group(2).length() > 0 ? ((Matcher)object).group(2) : null;
                            string3 = "\nWHERE sequence_schema = '" + (((Matcher)object).group(1).length() > 0 ? ((Matcher)object).group(1) : this.getCurrentSchema()) + "'";
                        }
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT sequence_schema, sequence_name FROM information_schema." + (n2 > 8 || n > 1 ? "sequences" : "system_sequences") + string3);
                        break;
                    }
                    stringArray[0] = "SEQUENCE";
                    break;
                }
                case 'r': {
                    if (string5.indexOf("HSQL") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT authorization_name FROM information_schema." + (n2 > 8 || n > 1 ? "authorizations" : "system_authorizations") + "\nWHERE authorization_type = 'ROLE'\n" + "ORDER BY authorization_name");
                        break;
                    }
                    if (string5.indexOf("Adaptive Server Enterprise") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT name FROM syssrvroles ORDER BY name");
                        break;
                    }
                    if (string5.indexOf("Apache Derby") > -1) {
                        throw new BadSpecial(SqltoolRB.vendor_derby_dr.getString());
                    }
                    throw new BadSpecial(SqltoolRB.vendor_nosup_d.getString("r"));
                }
                case 'u': {
                    if (string5.indexOf("HSQL") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT " + (n2 > 8 || n > 1 ? "user_name" : "user") + ", admin FROM " + "information_schema.system_users\n" + "ORDER BY user_name");
                        break;
                    }
                    if (string5.indexOf("Oracle") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT username, created FROM all_users ORDER BY username");
                        break;
                    }
                    if (string5.indexOf("PostgreSQL") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT usename, usesuper FROM pg_catalog.pg_user ORDER BY usename");
                        break;
                    }
                    if (string5.indexOf("Adaptive Server Enterprise") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT name, accdate, fullname FROM syslogins ORDER BY name");
                        break;
                    }
                    if (string5.indexOf("Apache Derby") > -1) {
                        throw new BadSpecial(SqltoolRB.vendor_derby_du.getString());
                    }
                    throw new BadSpecial(SqltoolRB.vendor_nosup_d.getString("u"));
                }
                case 'a': {
                    if (string5.indexOf("HSQL") > -1 && n2 < 9 && n < 2) {
                        if (string4 != null && ((Matcher)(object = dotPattern.matcher(string4))).matches()) {
                            string4 = ((Matcher)object).group(2).length() > 0 ? ((Matcher)object).group(2) : null;
                            string3 = "\nWHERE alias_schema = '" + (((Matcher)object).group(1).length() > 0 ? ((Matcher)object).group(1) : this.getCurrentSchema()) + "'";
                        }
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT alias_schem, alias FROM information_schema.system_aliases" + string3);
                        break;
                    }
                    stringArray[0] = "ALIAS";
                    break;
                }
                case 't': {
                    this.excludeSysSchemas = string5.indexOf("Oracle") > -1;
                    stringArray[0] = "TABLE";
                    break;
                }
                case 'v': {
                    stringArray[0] = "VIEW";
                    break;
                }
                case 'n': {
                    resultSet = databaseMetaData.getSchemas();
                    if (resultSet == null) {
                        throw new BadSpecial("Failed to get metadata from database");
                    }
                    this.displayResultSet(null, resultSet, listMDSchemaCols, string4);
                    return;
                }
                case 'i': {
                    String string6 = null;
                    if (string4 != null) {
                        Matcher matcher = dotPattern.matcher(string4);
                        if (matcher.matches()) {
                            string6 = matcher.group(2).length() > 0 ? matcher.group(2) : null;
                            string2 = matcher.group(1).length() > 0 ? matcher.group(1) : this.getCurrentSchema();
                        } else {
                            string6 = string4;
                        }
                        string4 = null;
                    }
                    if ((resultSet = databaseMetaData.getIndexInfo(null, string2, string6, false, true)) == null) {
                        throw new BadSpecial("Failed to get metadata from database");
                    }
                    this.displayResultSet(null, resultSet, listMDIndexCols, null);
                    return;
                }
                default: {
                    throw new BadSpecial(SqltoolRB.special_d_unknown.getString(Character.toString(c)) + LS + D_OPTIONS_TEXT);
                }
            }
            if (statement == null) {
                nArray = string5.indexOf("HSQL") > -1 ? listMDTableCols[1] : (string5.indexOf("Oracle") > -1 ? listMDTableCols[2] : listMDTableCols[0]);
                if (string2 == null && string4 != null && ((Matcher)(object = dotPattern.matcher(string4))).matches()) {
                    string4 = ((Matcher)object).group(2).length() > 0 ? ((Matcher)object).group(2) : null;
                    string2 = ((Matcher)object).group(1).length() > 0 ? ((Matcher)object).group(1) : this.getCurrentSchema();
                }
            }
            ResultSet resultSet2 = resultSet = statement == null ? databaseMetaData.getTables(null, string2, null, stringArray) : statement.getResultSet();
            if (resultSet == null) {
                throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString());
            }
            this.displayResultSet(null, resultSet, nArray, string4);
            if (stringArray2 == null) return;
            object = stringArray2;
            int n3 = ((String[])object).length;
            int n4 = 0;
            while (n4 < n3) {
                Object object2 = object[n4];
                resultSet = databaseMetaData.getTables(null, (String)object2, null, stringArray);
                if (resultSet == null) {
                    throw new BadSpecial(SqltoolRB.metadata_fetch_failfor.getString(new String[]{object2}));
                }
                if (resultSet.next()) {
                    this.displayResultSet(null, databaseMetaData.getTables(null, (String)object2, null, stringArray), nArray, string4);
                }
                ++n4;
            }
            return;
        }
        catch (SQLException sQLException) {
            throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString(), sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString(), nullPointerException);
        }
        finally {
            this.excludeSysSchemas = false;
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSQL() throws SQLException, SqlToolError {
        this.requireConnection();
        if (this.buffer == null) {
            throw new RuntimeException("Internal assertion failed.  No buffer in processSQL().");
        }
        if (this.buffer.type != 0) {
            throw new RuntimeException("Internal assertion failed.  Token type " + this.buffer.getTypeString() + " in processSQL().");
        }
        String string = this.lastSqlStatement = this.plMode ? this.dereference(this.buffer.val, true) : this.buffer.val;
        if (!this.permitEmptySqlStatements && this.buffer.val == null || this.buffer.val.trim().length() < 1) {
            throw new SqlToolError(SqltoolRB.sqlstatement_empty.getString());
        }
        Statement statement = null;
        long l = 0L;
        if (this.reportTimes) {
            l = new Date().getTime();
        }
        try {
            AutoCloseable autoCloseable;
            try {
                if (this.doPrepare) {
                    if (this.lastSqlStatement.indexOf(63) < 1) {
                        this.lastSqlStatement = null;
                        throw new SqlToolError(SqltoolRB.prepare_demandqm.getString());
                    }
                    this.doPrepare = false;
                    autoCloseable = this.shared.jdbcConn.prepareStatement(this.lastSqlStatement);
                    statement = autoCloseable;
                    if (this.prepareVar == null) {
                        if (this.binBuffer == null) {
                            this.lastSqlStatement = null;
                            throw new SqlToolError(SqltoolRB.binbuffer_empty.getString());
                        }
                        autoCloseable.setBytes(1, this.binBuffer);
                    } else {
                        String string2 = this.shared.userVars.get(this.prepareVar);
                        if (string2 == null) {
                            this.lastSqlStatement = null;
                            throw new SqlToolError(SqltoolRB.plvar_undefined.getString(this.prepareVar));
                        }
                        this.prepareVar = null;
                        autoCloseable.setString(1, string2);
                    }
                    autoCloseable.executeUpdate();
                } else {
                    statement = this.shared.jdbcConn.createStatement();
                    statement.execute(this.lastSqlStatement);
                }
            }
            finally {
                if (this.reportTimes) {
                    long l2 = new Date().getTime() - l;
                    this.condlPrintln(SqltoolRB.exectime_report.getString((int)l2), false);
                }
            }
            try {
                this.shared.possiblyUncommitteds = !this.shared.jdbcConn.getAutoCommit() && !commitOccursPattern.matcher(this.lastSqlStatement).matches();
            }
            catch (SQLException sQLException) {
                this.lastSqlStatement = null;
                try {
                    this.shared.jdbcConn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.shared.jdbcConn = null;
                this.shared.possiblyUncommitteds = false;
                this.stdprintln(SqltoolRB.disconnect_success.getString());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                return;
            }
            autoCloseable = null;
            try {
                autoCloseable = statement.getResultSet();
                this.displayResultSet(statement, (ResultSet)autoCloseable, null, null);
            }
            finally {
                if (autoCloseable != null) {
                    try {
                        autoCloseable.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        this.lastSqlStatement = null;
    }

    /*
     * WARNING - void declaration
     */
    private void displayResultSet(Statement statement, ResultSet resultSet, int[] nArray, String string) throws SQLException, SqlToolError {
        int n = statement == null ? -1 : statement.getUpdateCount();
        boolean bl = this.silentFetch;
        boolean bl2 = this.fetchBinary;
        Pattern pattern = null;
        this.silentFetch = false;
        this.fetchBinary = false;
        if (string != null) {
            try {
                pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SqlToolError(SqltoolRB.regex_malformat.getString(patternSyntaxException.getMessage()));
            }
        }
        if (this.excludeSysSchemas) {
            this.stdprintln(SqltoolRB.vendor_nosup_sysschemas.getString());
        }
        switch (n) {
            case -1: {
                int n2;
                String[] stringArray;
                int n22;
                boolean bl3;
                int n3;
                if (resultSet == null) {
                    this.stdprintln(SqltoolRB.noresult.getString(), true);
                    break;
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n4 = resultSetMetaData.getColumnCount();
                int n5 = nArray == null ? n4 : nArray.length;
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                String[] stringArray2 = null;
                int[] nArray2 = new int[n5];
                if (!this.htmlMode) {
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = 0;
                    }
                }
                boolean[] blArray = new boolean[n5];
                int[] nArray3 = new int[n5];
                boolean[] blArray2 = new boolean[n5];
                int n6 = -1;
                stringArray2 = new String[n5];
                for (n3 = 1; n3 <= n4; ++n3) {
                    if (nArray != null) {
                        bl3 = true;
                        for (n22 = 0; n22 < nArray.length; ++n22) {
                            if (n3 != nArray[n22]) continue;
                            bl3 = false;
                        }
                        if (bl3) continue;
                    }
                    stringArray2[++n6] = resultSetMetaData.getColumnLabel(n3);
                    nArray3[n6] = resultSetMetaData.getColumnType(n3);
                    blArray[n6] = false;
                    blArray2[n6] = true;
                    switch (nArray3[n6]) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            blArray[n6] = true;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -1: 
                        case 12: 
                        case 2004: 
                        case 2005: {
                            blArray2[n6] = false;
                        }
                    }
                    if (this.htmlMode || stringArray2[n6] == null || stringArray2[n6].length() <= nArray2[n6]) continue;
                    nArray2[n6] = stringArray2[n6].length();
                }
                while (resultSet.next()) {
                    stringArray = new String[n5];
                    n6 = -1;
                    n3 = pattern != null ? 1 : 0;
                    for (n22 = 1; n22 <= n4; ++n22) {
                        int n7;
                        if (nArray != null) {
                            bl3 = true;
                            int[] objectArray = nArray;
                            n2 = objectArray.length;
                            for (n7 = 0; n7 < n2; ++n7) {
                                int n8 = objectArray[n7];
                                if (n22 != n8) continue;
                                bl3 = false;
                            }
                            if (bl3) continue;
                        }
                        if (!SqlFile.canDisplayType(nArray3[++n6])) {
                            bl2 = true;
                        }
                        String string3 = null;
                        boolean bl4 = true;
                        if (!bl2) {
                            switch (nArray3[n6]) {
                                case 91: 
                                case 92: 
                                case 93: 
                                case 94: 
                                case 95: {
                                    void exception;
                                    Timestamp timestamp = resultSet.getTimestamp(n22);
                                    bl4 = resultSet.wasNull();
                                    String string2 = string3 = timestamp == null ? null : timestamp.toString();
                                    if (nArray3[n6] == 93 || nArray3[n6] == 95 || string3 == null) break;
                                    int n72 = string3.lastIndexOf(46);
                                    int i = n72 + 1;
                                    while (exception < string3.length()) {
                                        if (string3.charAt((int)exception) != '0') {
                                            n72 = 0;
                                            break;
                                        }
                                        ++exception;
                                    }
                                    if (n72 <= 1) break;
                                    string3 = string3.substring(0, n72);
                                    break;
                                }
                                default: {
                                    string3 = resultSet.getString(n22);
                                    bl4 = resultSet.wasNull();
                                    if (string3 != null) break;
                                    try {
                                        string3 = this.streamToString(resultSet.getAsciiStream(n22), this.shared.encoding);
                                        bl4 = resultSet.wasNull();
                                        break;
                                    }
                                    catch (Exception iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        if (bl2 || string3 == null && !bl4) {
                            if (this.pwDsv != null) {
                                throw new SqlToolError(SqltoolRB.dsv_bincol.getString());
                            }
                            try {
                                this.binBuffer = SqlFile.streamToBytes(resultSet.getBinaryStream(n22));
                                bl4 = resultSet.wasNull();
                            }
                            catch (IOException i) {
                                throw new SqlToolError("Failed to read value using stream", i);
                            }
                            this.stdprintln(SqltoolRB.binbuf_write.getString(Integer.toString(this.binBuffer.length), stringArray2[n6], SqlFile.sqlTypeToString(nArray3[n6])));
                            return;
                        }
                        if (this.excludeSysSchemas && string3 != null && n22 == 2) {
                            String[] stringArray3 = oracleSysSchemas;
                            n2 = stringArray3.length;
                            for (n7 = 0; n7 < n2; ++n7) {
                                String string4 = stringArray3[n7];
                                if (!string3.equals(string4)) continue;
                                n3 = 1;
                                break;
                            }
                        }
                        this.shared.userVars.put("?", string3 == null ? this.nullRepToken : string3);
                        if (this.fetchingVar != null) {
                            this.shared.userVars.put(this.fetchingVar, this.shared.userVars.get("?"));
                            this.updateUserSettings();
                            this.fetchingVar = null;
                        }
                        if (bl) {
                            return;
                        }
                        if (pattern != null && (string3 == null || pattern.matcher(string3).find())) {
                            n3 = 0;
                        }
                        stringArray[n6] = string3 == null && this.pwDsv == null ? (nArray3[n6] == 12 ? (this.htmlMode ? "<I>null</I>" : this.nullRepToken) : "") : string3;
                        if (this.htmlMode || this.pwDsv != null || stringArray[n6].length() <= nArray2[n6]) continue;
                        nArray2[n6] = stringArray[n6].length();
                    }
                    if (n3 != 0) continue;
                    arrayList.add(stringArray);
                }
                if (this.pwDsv == null) {
                    this.condlPrintln("<TABLE border='1'>", true);
                    if (n5 > 1) {
                        this.condlPrint(SqlFile.htmlRow(0) + LS + PRE_TD, true);
                        for (n22 = 0; n22 < stringArray2.length; ++n22) {
                            this.condlPrint("<TD>" + stringArray2[n22] + "</TD>", true);
                            this.condlPrint((n22 > 0 ? "  " : "") + (n22 < stringArray2.length - 1 || blArray[n22] ? StringUtil.toPaddedString(stringArray2[n22], nArray2[n22], ' ', !blArray[n22]) : stringArray2[n22]), false);
                        }
                        this.condlPrintln(LS + PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                        if (!this.htmlMode) {
                            for (n22 = 0; n22 < stringArray2.length; ++n22) {
                                this.condlPrint((n22 > 0 ? "  " : "") + SqlFile.divider(nArray2[n22]), false);
                            }
                            this.condlPrintln("", false);
                        }
                    }
                    for (n22 = 0; n22 < arrayList.size(); ++n22) {
                        void var27_37;
                        this.condlPrint(SqlFile.htmlRow(n22 % 2 == 0 ? 2 : 1) + LS + PRE_TD, true);
                        stringArray = (String[])arrayList.get(n22);
                        boolean bl4 = false;
                        while (var27_37 < stringArray.length) {
                            this.condlPrint("<TD>" + stringArray[var27_37] + "</TD>", true);
                            this.condlPrint((var27_37 > 0 ? "  " : "") + (var27_37 < stringArray.length - 1 || blArray[var27_37] ? StringUtil.toPaddedString(stringArray[var27_37], nArray2[var27_37], ' ', !blArray[var27_37]) : stringArray[var27_37]), false);
                            ++var27_37;
                        }
                        this.condlPrintln(LS + PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                    }
                    this.condlPrintln("</TABLE>", true);
                    if (this.interactive && arrayList.size() != 1) {
                        this.stdprintln(LS + SqltoolRB.rows_fetched.getString(arrayList.size()), true);
                    }
                    this.condlPrintln("<HR>", true);
                    break;
                }
                if (n5 > 0) {
                    for (n22 = 0; n22 < stringArray2.length; ++n22) {
                        this.dsvSafe(stringArray2[n22]);
                        this.pwDsv.print(stringArray2[n22]);
                        if (n22 >= stringArray2.length - 1) continue;
                        this.pwDsv.print(this.dsvColDelim);
                    }
                    this.pwDsv.print(this.dsvRowDelim);
                }
                for (String[] stringArray4 : arrayList) {
                    for (n2 = 0; n2 < stringArray4.length; ++n2) {
                        this.dsvSafe(stringArray4[n2]);
                        this.pwDsv.print(stringArray4[n2] == null ? (blArray2[n2] ? "" : this.nullRepToken) : stringArray4[n2]);
                        if (n2 >= stringArray4.length - 1) continue;
                        this.pwDsv.print(this.dsvColDelim);
                    }
                    this.pwDsv.print(this.dsvRowDelim);
                }
                this.stdprintln(SqltoolRB.rows_fetched_dsv.getString(arrayList.size()));
                break;
            }
            default: {
                this.shared.userVars.put("?", Integer.toString(n));
                if (this.fetchingVar != null) {
                    this.shared.userVars.put(this.fetchingVar, this.shared.userVars.get("?"));
                    this.updateUserSettings();
                    this.fetchingVar = null;
                }
                if (n == 0 || !this.interactive) break;
                this.stdprintln(n == 1 ? SqltoolRB.row_update_singular.getString() : SqltoolRB.row_update_multiple.getString(n));
            }
        }
    }

    private static String htmlRow(int n) {
        switch (n) {
            case 0: {
                return "    <TR style='font-weight: bold;'>";
            }
            case 1: {
                return "    <TR style='background: #94d6ef; font: normal normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
            case 2: {
                return "    <TR style='background: silver; font: normal normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
        }
        return null;
    }

    private static String divider(int n) {
        return n > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, n);
    }

    private void showHistory() throws BadSpecial {
        if (this.history == null) {
            throw new BadSpecial(SqltoolRB.history_unavailable.getString());
        }
        if (this.history.size() < 1) {
            throw new BadSpecial(SqltoolRB.history_none.getString());
        }
        if (this.shared.psStd == null) {
            return;
        }
        for (int i = 0; i < this.history.size(); ++i) {
            Token token = (Token)this.history.get(i);
            this.shared.psStd.println(DEFAULT_SKIP_PREFIX + (i + this.oldestHist) + " or " + (i - this.history.size()) + ':');
            this.shared.psStd.println(token.reconstitute());
        }
        if (this.buffer != null) {
            this.shared.psStd.println(SqltoolRB.editbuffer_contents.getString(this.buffer.reconstitute()));
        }
        this.shared.psStd.println();
        this.shared.psStd.println(SqltoolRB.buffer_instructions.getString());
    }

    private Token commandFromHistory(int n) throws BadSpecial {
        int n2 = n;
        if (this.history == null) {
            throw new BadSpecial(SqltoolRB.history_unavailable.getString());
        }
        if (n2 == 0) {
            throw new BadSpecial(SqltoolRB.history_number_req.getString());
        }
        if (n2 > 0) {
            if ((n2 -= this.oldestHist) < 0) {
                throw new BadSpecial(SqltoolRB.history_backto.getString(this.oldestHist));
            }
            if (n2 >= this.history.size()) {
                throw new BadSpecial(SqltoolRB.history_upto.getString(this.history.size() + this.oldestHist - 1));
            }
        } else if ((n2 += this.history.size()) < 0) {
            throw new BadSpecial(SqltoolRB.history_back.getString(this.history.size()));
        }
        return (Token)this.history.get(n2);
    }

    private Integer historySearch(String string) throws BadSpecial {
        if (this.history == null) {
            throw new BadSpecial(SqltoolRB.history_unavailable.getString());
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile("(?ims)" + string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new BadSpecial(SqltoolRB.regex_malformat.getString(patternSyntaxException.getMessage()));
        }
        for (int i = this.history.size() - 1; i >= 0; --i) {
            if (!pattern.matcher(((Token)this.history.get((int)i)).val).find()) continue;
            return i + this.oldestHist;
        }
        return null;
    }

    private boolean setBuf(Token token) {
        if (this.buffer != null && this.buffer != null && this.buffer.equals(token)) {
            return false;
        }
        switch (token.type) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new RuntimeException("Internal assertion failed.  Attempted to add command type " + token.getTypeString() + " to buffer");
            }
        }
        this.buffer = new Token(token.type, new String(token.val), token.line);
        return true;
    }

    private boolean historize() {
        if (this.history == null || this.buffer == null) {
            return false;
        }
        if (this.history.size() > 0 && ((Token)this.history.get(this.history.size() - 1)).equals(this.buffer)) {
            return false;
        }
        this.history.add(this.buffer);
        if (this.history.size() <= this.maxHistoryLength) {
            return true;
        }
        this.history.remove(0);
        ++this.oldestHist;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describe(String string, String string2) throws SQLException {
        if (this.shared.jdbcConn == null) {
            throw new RuntimeException("Somehow got to 'describe' even though we have no Conn");
        }
        Pattern pattern = null;
        boolean bl = false;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = new String[]{SqltoolRB.describe_table_name.getString(), SqltoolRB.describe_table_datatype.getString(), SqltoolRB.describe_table_width.getString(), SqltoolRB.describe_table_nonulls.getString()};
        int[] nArray = new int[]{0, 0, 0, 0};
        boolean[] blArray = new boolean[]{false, false, true, false};
        if (string2 != null) {
            try {
                bl = string2.charAt(0) == '/';
                pattern = Pattern.compile(bl ? string2.substring(1) : string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SQLException(SqltoolRB.regex_malformat.getString(patternSyntaxException.getMessage()));
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.htmlMode || stringArray[i].length() <= nArray[i]) continue;
            nArray[i] = stringArray[i].length();
        }
        ResultSet resultSet = null;
        Statement statement = this.shared.jdbcConn.createStatement();
        try {
            int n;
            String[] stringArray2;
            int n2;
            statement.execute("SELECT * FROM " + string + " WHERE 1 = 2");
            resultSet = statement.getResultSet();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray2 = new String[4];
                stringArray2[0] = resultSetMetaData.getColumnName(n2 + 1);
                if (pattern != null && !bl && !pattern.matcher(stringArray2[0]).find()) continue;
                stringArray2[1] = resultSetMetaData.getColumnTypeName(n2 + 1);
                stringArray2[2] = Integer.toString(resultSetMetaData.getColumnDisplaySize(n2 + 1));
                String string3 = resultSetMetaData.isNullable(n2 + 1) == 1 ? (this.htmlMode ? "&nbsp;" : "") : (stringArray2[3] = "*");
                if (pattern != null && bl && !pattern.matcher(stringArray2[0] + ' ' + stringArray2[1] + ' ' + stringArray2[2] + ' ' + stringArray2[3]).find()) continue;
                arrayList.add(stringArray2);
                for (n = 0; n < stringArray2.length; ++n) {
                    if (stringArray2[n].length() <= nArray[n]) continue;
                    nArray[n] = stringArray2[n].length();
                }
            }
            this.condlPrint("<TABLE border='1'>" + LS + SqlFile.htmlRow(0) + LS + PRE_TD, true);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                this.condlPrint("<TD>" + stringArray[n2] + "</TD>", true);
                this.condlPrint((n2 > 0 ? "  " : "") + (n2 < stringArray.length - 1 || blArray[n2] ? StringUtil.toPaddedString(stringArray[n2], nArray[n2], ' ', !blArray[n2]) : stringArray[n2]), false);
            }
            this.condlPrintln(LS + PRE_TR + "</TR>", true);
            this.condlPrintln("", false);
            if (!this.htmlMode) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    this.condlPrint((n2 > 0 ? "  " : "") + SqlFile.divider(nArray[n2]), false);
                }
                this.condlPrintln("", false);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.condlPrint(SqlFile.htmlRow(n2 % 2 == 0 ? 2 : 1) + LS + PRE_TD, true);
                stringArray2 = (String[])arrayList.get(n2);
                for (n = 0; n < stringArray2.length; ++n) {
                    this.condlPrint("<TD>" + stringArray2[n] + "</TD>", true);
                    this.condlPrint((n > 0 ? "  " : "") + (n < stringArray2.length - 1 || blArray[n] ? StringUtil.toPaddedString(stringArray2[n], nArray[n], ' ', !blArray[n]) : stringArray2[n]), false);
                }
                this.condlPrintln(LS + PRE_TR + "</TR>", true);
                this.condlPrintln("", false);
            }
            this.condlPrintln(LS + "</TABLE>" + LS + "<HR>", true);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private boolean eval(String[] stringArray) throws BadSpecial {
        boolean bl = stringArray.length > 0 && stringArray[0].equals("!");
        String[] stringArray2 = new String[bl ? stringArray.length - 1 : stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray[i + (bl ? 1 : 0)];
            stringArray2[i] = string.length() > 1 && string.charAt(0) == '*' ? this.shared.userVars.get(string.substring(1)) : stringArray[i + (bl ? 1 : 0)];
            if (stringArray2[i] != null) continue;
            stringArray2[i] = "";
        }
        if (stringArray2.length == 1) {
            return (stringArray2[0].length() > 0 && !stringArray2[0].equals("0")) ^ bl;
        }
        if (stringArray2.length == 3) {
            if (stringArray2[1].equals("==")) {
                return stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            if (stringArray2[1].equals("!=") || stringArray2[1].equals("<>") || stringArray2[1].equals("><")) {
                return !stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            if (stringArray2[1].equals(">")) {
                return (stringArray2[0].length() > stringArray2[2].length() || stringArray2[0].length() == stringArray2[2].length() && stringArray2[0].compareTo(stringArray2[2]) > 0) ^ bl;
            }
            if (stringArray2[1].equals("<")) {
                return (stringArray2[2].length() > stringArray2[0].length() || stringArray2[2].length() == stringArray2[0].length() && stringArray2[2].compareTo(stringArray2[0]) > 0) ^ bl;
            }
        }
        throw new BadSpecial(SqltoolRB.logical_unrecognized.getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeQueryOutputStream() {
        if (this.pwQuery == null) {
            return;
        }
        try {
            if (this.htmlMode) {
                this.pwQuery.println("</BODY></HTML>");
                this.pwQuery.flush();
            }
        }
        finally {
            try {
                this.pwQuery.close();
            }
            finally {
                this.pwQuery = null;
            }
        }
    }

    private void condlPrintln(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        if (this.shared.psStd != null) {
            this.shared.psStd.println(string);
        }
        if (this.pwQuery != null) {
            this.pwQuery.println(string);
            this.pwQuery.flush();
        }
    }

    private void condlPrint(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        if (this.shared.psStd != null) {
            this.shared.psStd.print(string);
        }
        if (this.pwQuery != null) {
            this.pwQuery.print(string);
            this.pwQuery.flush();
        }
    }

    private String formatNicely(Map<?, ?> map, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            SqlFile.appendLine(stringBuffer, SqltoolRB.pl_list_parens.getString());
        } else {
            SqlFile.appendLine(stringBuffer, SqltoolRB.pl_list_lengths.getString());
        }
        for (Map.Entry<?, ?> entry : new TreeMap(map).entrySet()) {
            String string = (String)entry.getValue();
            SqlFile.appendLine(stringBuffer, PRE_TR + (String)entry.getKey() + ": " + (bl ? "(" + string + ')' : Integer.toString(string.length())));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(String string, File file) throws IOException, BadSpecial {
        String string2 = this.shared.userVars.get(string);
        if (string2 == null) {
            throw new BadSpecial(SqltoolRB.plvar_undefined.getString(string));
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding);
        try {
            char c;
            outputStreamWriter.write(string2);
            if (string2.length() > 0 && (c = string2.charAt(string2.length() - 1)) != '\n' && c != '\r') {
                outputStreamWriter.write(LS);
            }
            outputStreamWriter.flush();
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
            }
            finally {
                outputStreamWriter = null;
            }
        }
        this.stdprintln(SqltoolRB.file_wrotechars.getString(Long.toString(file.length()), file.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(File file) throws IOException, BadSpecial {
        if (this.binBuffer == null) {
            throw new BadSpecial(SqltoolRB.binbuffer_empty.getString());
        }
        int n = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(this.binBuffer);
            n = this.binBuffer.length;
            this.binBuffer = null;
            fileOutputStream.flush();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                fileOutputStream = null;
            }
        }
        this.stdprintln(SqltoolRB.file_wrotechars.getString(n, file.toString()));
    }

    /*
     * Exception decompiling
     */
    public String streamToString(InputStream var1_1, String var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void load(String string, File file, String string2) throws IOException {
        String string3 = this.streamToString(new FileInputStream(file), string2);
        this.shared.userVars.put(string, string3);
        this.updateUserSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] streamToBytes(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[10240];
        byte[] byArray2 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        finally {
            byteArrayOutputStream = null;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBinary(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] byArray = new byte[10240];
        byte[] byArray2 = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = fileInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                fileInputStream = null;
                byteArrayOutputStream = null;
            }
        }
        return byArray2;
    }

    public static boolean canDisplayType(int n) {
        switch (n) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2004: {
                return false;
            }
        }
        return true;
    }

    public static String sqlTypeToString(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case 94: {
                return "SQL_TIME_WITH_TIME_ZONE";
            }
            case 95: {
                return "SQL_TIMESTAMP_WITH_TIME_ZONE";
            }
        }
        return "Unknown type " + n;
    }

    public void dsvSafe(String string) throws SqlToolError {
        if (this.pwDsv == null || this.dsvColDelim == null || this.dsvRowDelim == null || this.nullRepToken == null) {
            throw new RuntimeException("Assertion failed.  \ndsvSafe called when DSV settings are incomplete");
        }
        if (string == null) {
            return;
        }
        if (string.indexOf(this.dsvColDelim) > 0) {
            throw new SqlToolError(SqltoolRB.dsv_coldelim_present.getString(this.dsvColDelim));
        }
        if (string.indexOf(this.dsvRowDelim) > 0) {
            throw new SqlToolError(SqltoolRB.dsv_rowdelim_present.getString(this.dsvRowDelim));
        }
        if (string.trim().equals(this.nullRepToken)) {
            throw new SqlToolError(SqltoolRB.dsv_nullrep_present.getString(this.nullRepToken));
        }
    }

    public static String convertEscapes(String string) {
        if (string == null) {
            return null;
        }
        return SqlFile.convertNumericEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(string, "\\n", "\n"), "\\r", "\r"), "\\t", "\t"), "\\\\", "\\"), "\\f", "\f"));
    }

    private static String convertNumericEscapes(String string) {
        String string2 = string;
        int n = 0;
        for (char c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            while ((n = string2.indexOf("\\" + c, n)) > -1 && n < string2.length() - 1) {
                string2 = SqlFile.convertNumericEscape(string, n);
            }
            while ((n = string2.indexOf("\\x" + c, n)) > -1 && n < string2.length() - 1) {
                string2 = SqlFile.convertNumericEscape(string, n);
            }
            while ((n = string2.indexOf("\\X" + c, n)) > -1 && n < string2.length() - 1) {
                string2 = SqlFile.convertNumericEscape(string, n);
            }
        }
        return string2;
    }

    private static String convertNumericEscape(String string, int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (Character.toUpperCase(string.charAt(n + 1)) == 'X') {
            n3 = n + 2;
            n4 = 16;
            n2 = n3 + 2;
            if (n2 > string.length()) {
                n2 = string.length();
            }
        } else {
            n3 = n + 1;
            n4 = Character.toUpperCase(string.charAt(n3)) == '0' ? 8 : 10;
            for (n2 = n3 + 1; n2 < string.length() && Character.isDigit(string.charAt(n2)); ++n2) {
            }
        }
        return string.substring(0, n) + (char)Integer.parseInt(string.substring(n3, n2), n4) + string.substring(n2);
    }

    private static String convertEscapes(String string, String string2, String string3) {
        String string4 = string;
        int n = 0;
        int n2 = string2.length();
        while ((n = string4.indexOf(string2, n)) > -1 && n < string4.length() - 1) {
            string4 = string4.substring(0, n) + string3 + string4.substring(n + n2);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importDsv(String string, String string2) throws SqlToolError {
        int n;
        int n2;
        String[] stringArray;
        String string3;
        String string4;
        int n3;
        boolean bl;
        String string5;
        int n4;
        String string6;
        Object object;
        String[] stringArray2;
        String string7;
        int n5;
        String[] stringArray3;
        TreeMap<String, String> treeMap;
        File file;
        block169: {
            int n6;
            this.requireConnection();
            byte[] byArray = null;
            file = new File(string);
            treeMap = null;
            if (this.dsvConstCols != null) {
                treeMap = new TreeMap<String, String>();
                for (String string8 : this.dsvConstCols.split(this.dsvColSplitter, -1)) {
                    Matcher matcher = nameValPairPattern.matcher(string8);
                    if (!matcher.matches()) {
                        throw new SqlToolError(SqltoolRB.dsv_constcols_nullcol.getString());
                    }
                    treeMap.put(matcher.group(1).toLowerCase(), matcher.groupCount() < 2 || matcher.group(2) == null ? "" : matcher.group(2));
                }
            }
            stringArray3 = null;
            if (this.dsvSkipCols != null) {
                stringArray3 = new HashSet();
                String[] stringArray4 = this.dsvSkipCols.split(this.dsvColSplitter, -1);
                n5 = stringArray4.length;
                for (int i = 0; i < n5; ++i) {
                    string7 = stringArray4[i];
                    stringArray3.add(string7.trim().toLowerCase());
                }
            }
            if (!file.canRead()) {
                throw new SqlToolError(SqltoolRB.file_readfail.getString(file.toString()));
            }
            try {
                byArray = new byte[(int)file.length()];
            }
            catch (RuntimeException runtimeException) {
                throw new SqlToolError(SqltoolRB.read_toobig.getString(), runtimeException);
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                for (n6 = 0; n6 < byArray.length && (n5 = ((InputStream)fileInputStream).read(byArray, n6, byArray.length - n6)) > 0; n6 += n5) {
                }
            }
            catch (IOException iOException) {
                throw new SqlToolError(iOException);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        try {
                            ((InputStream)fileInputStream).close();
                            fileInputStream = null;
                        }
                        catch (IOException iOException) {
                            this.errprintln(SqltoolRB.inputfile_closefail.getString() + ": " + iOException);
                            fileInputStream = null;
                        }
                    }
                    catch (Throwable throwable) {
                        fileInputStream = null;
                        throw throwable;
                    }
                }
            }
            if (n6 != byArray.length) {
                throw new SqlToolError(SqltoolRB.read_partial.getString(n6, byArray.length));
            }
            stringArray2 = null;
            try {
                object = new String(byArray, this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding);
                stringArray2 = ((String)object).split(this.dsvRowSplitter, -1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SqlToolError(unsupportedEncodingException);
            }
            catch (RuntimeException runtimeException) {
                throw new SqlToolError(SqltoolRB.read_convertfail.getString(), runtimeException);
            }
            object = new ArrayList();
            string6 = this.dsvTargetTable;
            n4 = 0;
            string5 = null;
            bl = false;
            n3 = 0;
            string4 = "dummy";
            while (true) {
                if (n4 >= stringArray2.length) {
                    throw new SqlToolError(SqltoolRB.dsv_header_none.getString());
                }
                if ((string5 = (string4 = stringArray2[n4++]).trim()).length() < 1 || string2 != null && string5.startsWith(string2)) continue;
                if (string5.startsWith("targettable=")) {
                    if (string6 != null) continue;
                    string6 = string5.substring("targettable=".length()).trim();
                    continue;
                }
                if (string5.equals("headerswitch{")) {
                    if (string6 == null) {
                        throw new SqlToolError(SqltoolRB.dsv_header_noswitchtarg.getString(n4));
                    }
                    bl = true;
                    continue;
                }
                if (string5.equals("}")) {
                    throw new SqlToolError(SqltoolRB.dsv_header_noswitchmatch.getString(n4));
                }
                if (!bl) break block169;
                int n7 = string5.indexOf(58);
                if (n7 < 1) throw new SqlToolError(SqltoolRB.dsv_header_nonswitched.getString(n4));
                if (n7 == string5.length() - 1) {
                    throw new SqlToolError(SqltoolRB.dsv_header_nonswitched.getString(n4));
                }
                string3 = string5.substring(0, n7).trim();
                if (string3.equals("*") || string3.equalsIgnoreCase(string6)) break;
            }
            n3 = 1 + string4.indexOf(58);
        }
        String string9 = string4.substring(n3);
        for (String string10 : stringArray = string9.split(this.dsvColSplitter, -1)) {
            if (string10.length() < 1) {
                throw new SqlToolError(SqltoolRB.dsv_nocolheader.getString(object.size() + 1, n4));
            }
            string3 = string10.trim().toLowerCase();
            object.add(string3.equals("-") || stringArray3 != null && stringArray3.remove(string3) || treeMap != null && treeMap.containsKey(string3) ? (String)null : string3);
        }
        if (stringArray3 != null && stringArray3.size() > 0) {
            throw new SqlToolError(SqltoolRB.dsv_skipcols_missing.getString(stringArray3.toString()));
        }
        boolean bl2 = false;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string11 = (String)iterator.next();
            if (string11 == null) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new SqlToolError(SqltoolRB.dsv_nocolsleft.getString(this.dsvSkipCols));
        }
        int n8 = object.size();
        if (treeMap != null) {
            object.addAll(treeMap.keySet());
        }
        String[] stringArray5 = object.toArray(new String[0]);
        if (string6 == null && (n2 = (string6 = file.getName()).lastIndexOf(46)) > 0) {
            string6 = string6.substring(0, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n9 = 0;
        for (String string12 : stringArray5) {
            if (string12 == null) {
                ++n9;
                continue;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string12);
            arrayList.add(string12);
        }
        boolean[] blArray = new boolean[stringArray5.length - n9];
        boolean[] blArray2 = new boolean[blArray.length];
        boolean[] blArray3 = new boolean[blArray.length];
        char[] cArray = new char[blArray.length];
        String[] stringArray6 = arrayList.toArray(new String[0]);
        StringBuffer stringBuffer2 = new StringBuffer("INSERT INTO " + string6 + " (" + stringBuffer + ") VALUES (");
        StringBuffer stringBuffer3 = new StringBuffer("SELECT " + stringBuffer + " FROM " + string6 + " WHERE 1 = 2");
        try {
            ResultSetMetaData resultSetMetaData = this.shared.jdbcConn.createStatement().executeQuery(stringBuffer3.toString()).getMetaData();
            if (resultSetMetaData.getColumnCount() != blArray.length) {
                throw new SqlToolError(SqltoolRB.dsv_metadata_mismatch.getString());
            }
            block93: for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = true;
                blArray2[i] = false;
                blArray3[i] = false;
                cArray[i] = 115;
                switch (resultSetMetaData.getColumnType(i + 1)) {
                    case -7: {
                        blArray[i] = true;
                        cArray[i] = 98;
                        continue block93;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        blArray[i] = true;
                        cArray[i] = 120;
                        continue block93;
                    }
                    case 16: {
                        blArray3[i] = true;
                        continue block93;
                    }
                    case 2003: {
                        blArray[i] = true;
                        cArray[i] = 97;
                        continue block93;
                    }
                    case -1: 
                    case 12: 
                    case 2004: 
                    case 2005: {
                        blArray[i] = false;
                        continue block93;
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        blArray2[i] = true;
                        continue block93;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SqlToolError(SqltoolRB.query_metadatafail.getString(stringBuffer3.toString()), sQLException);
        }
        for (n = 0; n < blArray.length; ++n) {
            if (n > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append('?');
        }
        n = 0;
        File file2 = null;
        File file3 = null;
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        try {
            Object object2;
            boolean bl3;
            boolean bl4;
            int n10;
            int n11;
            block171: {
                if (this.dsvRejectFile != null) {
                    try {
                        file2 = new File(this.dereferenceAt(this.dsvRejectFile));
                        printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding));
                        printWriter.print(string9 + this.dsvRowDelim);
                    }
                    catch (BadSpecial badSpecial) {
                        throw new SqlToolError(SqltoolRB.dsv_rejectfile_setupfail.getString(this.dsvRejectFile), badSpecial);
                    }
                    catch (IOException iOException) {
                        throw new SqlToolError(SqltoolRB.dsv_rejectfile_setupfail.getString(this.dsvRejectFile), iOException);
                    }
                }
                if (this.dsvRejectReport != null) {
                    try {
                        file3 = new File(this.dereferenceAt(this.dsvRejectReport));
                        printWriter2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file3), this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding));
                        printWriter2.println(SqltoolRB.rejectreport_top.getString(new Date().toString(), file.getPath(), file2 == null ? SqltoolRB.none.getString() : file2.getPath(), file2 == null ? null : file2.getPath()));
                    }
                    catch (BadSpecial badSpecial) {
                        throw new SqlToolError(SqltoolRB.dsv_rejectreport_setupfail.getString(this.dsvRejectReport), badSpecial);
                    }
                    catch (IOException iOException) {
                        throw new SqlToolError(SqltoolRB.dsv_rejectreport_setupfail.getString(this.dsvRejectReport), iOException);
                    }
                }
                n11 = 0;
                n10 = 0;
                Statement statement = null;
                bl4 = false;
                bl3 = false;
                try {
                    boolean bl5 = bl3 = this.dsvRecordsPerCommit > 0 && this.shared.jdbcConn.getAutoCommit();
                    if (bl3) {
                        this.shared.jdbcConn.setAutoCommit(false);
                    }
                }
                catch (SQLException sQLException) {
                    throw new SqlToolError(SqltoolRB.rpc_autocommit_failure.getString(), sQLException);
                }
                try {
                    try {
                        statement = this.shared.jdbcConn.prepareStatement(stringBuffer2.toString() + ')');
                    }
                    catch (SQLException sQLException) {
                        throw new SqlToolError(SqltoolRB.insertion_preparefail.getString(stringBuffer2.toString()), sQLException);
                    }
                    object2 = new String[blArray.length];
                    String string13 = null;
                    while (n4 < stringArray2.length) {
                        try {
                            try {
                                if ((string5 = (string4 = stringArray2[n4++]).trim()).length() < 1) continue;
                                if (string2 != null && string5.startsWith(string2)) {
                                    ++n10;
                                    continue;
                                }
                                if (bl) {
                                    if (string5.equals("}")) {
                                        bl = false;
                                        continue;
                                    }
                                    int n12 = string5.indexOf(58);
                                    if (n12 < 1) throw new SqlToolError(SqltoolRB.dsv_header_matchernonhead.getString(n4));
                                    if (n12 != string5.length() - 1) continue;
                                    throw new SqlToolError(SqltoolRB.dsv_header_matchernonhead.getString(n4));
                                }
                                ++n11;
                                int n13 = 0;
                                int n14 = 0;
                                stringArray = string4.split(this.dsvColSplitter, -1);
                                for (String string14 : stringArray) {
                                    if (n13 == n8) {
                                        throw new RowError(SqltoolRB.dsv_colcount_mismatch.getString(n8, 1 + n13));
                                    }
                                    if (stringArray5[n13++] == null) continue;
                                    object2[n14++] = this.dsvTrimAll ? string14.trim() : string14;
                                }
                                if (n13 < n8) {
                                    throw new RowError(SqltoolRB.dsv_colcount_mismatch.getString(n8, n13));
                                }
                                if (treeMap != null) {
                                    for (String string15 : treeMap.values()) {
                                        object2[n14++] = string15;
                                    }
                                }
                                if (n14 != ((String[])object2).length) {
                                    throw new RowError(SqltoolRB.dsv_insertcol_mismatch.getString(((String[])object2).length, n14));
                                }
                                for (int i = 0; i < ((String[])object2).length; ++i) {
                                    string13 = stringArray6[i];
                                    if (blArray[i]) {
                                        object2[i] = object2[i].trim();
                                    }
                                    if (blArray2[i]) {
                                        if (object2[i].length() < 1 && blArray[i] || object2[i].equals(this.nullRepToken)) {
                                            statement.setTimestamp(i + 1, null);
                                        } else {
                                            if (object2[i].indexOf(58) > 0 && object2[i].indexOf(45) > 0) {
                                                string7 = object2[i];
                                            } else if (object2[i].indexOf(58) < 1) {
                                                string7 = object2[i] + " 0:00:00";
                                            } else {
                                                if (object2[i].indexOf(45) >= 1) throw new RuntimeException("Unexpected date/time val: " + object2[i]);
                                                string7 = "0000-00-00 " + object2[i];
                                            }
                                            try {
                                                statement.setTimestamp(i + 1, Timestamp.valueOf(string7));
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw new RowError(SqltoolRB.time_bad.getString(string7), illegalArgumentException);
                                            }
                                        }
                                    } else if (blArray3[i]) {
                                        if (object2[i].length() < 1 && blArray[i] || object2[i].equals(this.nullRepToken)) {
                                            statement.setNull(i + 1, 16);
                                        } else {
                                            try {
                                                statement.setBoolean(i + 1, Boolean.parseBoolean(object2[i]));
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw new RowError(SqltoolRB.boolean_bad.getString(object2[i]), illegalArgumentException);
                                            }
                                        }
                                    } else {
                                        switch (cArray[i]) {
                                            case 'b': {
                                                statement.setBytes(i + 1, object2[i].length() < 1 ? null : SqlFile.bitCharsToBytes(object2[i]));
                                                break;
                                            }
                                            case 'x': {
                                                statement.setBytes(i + 1, object2[i].length() < 1 ? null : SqlFile.hexCharOctetsToBytes(object2[i]));
                                                break;
                                            }
                                            case 'a': {
                                                if (createArrayOfMethod == null) {
                                                    throw new SqlToolError("SqlTool requires += Java 1.6 at runtime in order to import Array values");
                                                }
                                                if (object2[i].length() < 1) {
                                                    statement.setArray(i + 1, null);
                                                    break;
                                                }
                                                Matcher matcher = arrayPattern.matcher(object2[i]);
                                                if (!matcher.matches()) {
                                                    throw new RowError("Malformatted ARRAY value: (" + object2[i] + ')');
                                                }
                                                String[] stringArray7 = matcher.group(1) == null ? new String[]{} : matcher.group(1).split("\\s*,\\s*");
                                                try {
                                                    statement.setArray(i + 1, (Array)createArrayOfMethod.invoke((Object)this.shared.jdbcConn, "VARCHAR", stringArray7));
                                                    break;
                                                }
                                                catch (IllegalAccessException illegalAccessException) {
                                                    throw new RuntimeException(illegalAccessException);
                                                }
                                                catch (InvocationTargetException invocationTargetException) {
                                                    if (invocationTargetException.getCause() == null) throw new RuntimeException(invocationTargetException);
                                                    if (!(invocationTargetException.getCause() instanceof AbstractMethodError)) throw new RuntimeException(invocationTargetException);
                                                    throw new SqlToolError("SqlTool binary is not Array-compatible with your runtime JRE.  Array imports not possible.");
                                                }
                                            }
                                            default: {
                                                statement.setString(i + 1, object2[i].length() < 1 && blArray[i] || object2[i].equals(this.nullRepToken) ? null : object2[i]);
                                            }
                                        }
                                    }
                                    string13 = null;
                                }
                                n5 = statement.executeUpdate();
                                if (n5 != 1) {
                                    throw new RowError(SqltoolRB.inputrec_modified.getString(n5));
                                }
                                if (this.dsvRecordsPerCommit > 0 && (n11 - n) % this.dsvRecordsPerCommit == 0) {
                                    this.shared.jdbcConn.commit();
                                    this.shared.possiblyUncommitteds = false;
                                    continue;
                                }
                                this.shared.possiblyUncommitteds = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new RowError(null, numberFormatException);
                            }
                            catch (SQLException sQLException) {
                                throw new RowError(null, sQLException);
                            }
                        }
                        catch (RowError rowError) {
                            String string16;
                            ++n;
                            if (printWriter != null || printWriter2 != null) {
                                if (printWriter != null) {
                                    printWriter.print(string4 + this.dsvRowDelim);
                                }
                                if (printWriter2 == null) continue;
                                this.genRejectReportRecord(printWriter2, n, n4, string13, rowError.getMessage(), rowError.getCause());
                                continue;
                            }
                            bl4 = true;
                            StringBuilder stringBuilder = new StringBuilder().append(SqltoolRB.dsv_recin_fail.getString(n4, string13));
                            if (rowError.getMessage() == null) {
                                string16 = "";
                                throw new SqlToolError(stringBuilder.append(string16).toString(), rowError.getCause());
                            }
                            string16 = "  " + rowError.getMessage();
                            throw new SqlToolError(stringBuilder.append(string16).toString(), rowError.getCause());
                        }
                    }
                    if (statement == null) break block171;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            try {
                                statement.close();
                                statement = null;
                            }
                            catch (SQLException sQLException) {
                                statement = null;
                            }
                        }
                        catch (Throwable throwable2) {
                            statement = null;
                            throw throwable2;
                        }
                    }
                    try {
                        if (this.dsvRecordsPerCommit > 0 && (n11 - n) % this.dsvRecordsPerCommit != 0) {
                            this.shared.jdbcConn.commit();
                            this.shared.possiblyUncommitteds = false;
                        }
                        if (bl3) {
                            this.shared.jdbcConn.setAutoCommit(true);
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new SqlToolError(SqltoolRB.rpc_commit_failure.getString(), sQLException);
                    }
                    String string17 = null;
                    if (n11 > 0) {
                        string17 = SqltoolRB.dsv_import_summary.getString(string2 == null ? "" : "'" + string2 + "'-", Integer.toString(n10), Integer.toString(n), Integer.toString(n11 - n), bl4 ? "importAborted" : null);
                        this.stdprintln(string17);
                    }
                    try {
                        if (n11 > n && this.dsvRecordsPerCommit < 1 && !this.shared.jdbcConn.getAutoCommit()) {
                            this.stdprintln(SqltoolRB.insertions_notcommitted.getString());
                        }
                    }
                    catch (SQLException sQLException) {
                        this.stdprintln(SqltoolRB.autocommit_fetchfail.getString());
                        this.stdprintln(SqltoolRB.insertions_notcommitted.getString());
                    }
                    if (printWriter != null) {
                        printWriter.flush();
                    }
                    if (printWriter2 != null && n > 0) {
                        printWriter2.println(SqltoolRB.rejectreport_bottom.getString(string17, revnum));
                        printWriter2.flush();
                    }
                    if (n != 0) throw throwable;
                    if (file2 != null && file2.exists() && !file2.delete()) {
                        this.errprintln(SqltoolRB.dsv_rejectfile_purgefail.getString(file2.toString()));
                    }
                    if (file3 == null) throw throwable;
                    if (file3.delete()) throw throwable;
                    this.errprintln(SqltoolRB.dsv_rejectreport_purgefail.getString(file2 == null ? null : file2.toString()));
                    throw throwable;
                }
                try {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException sQLException) {
                        statement = null;
                    }
                }
                catch (Throwable throwable) {
                    statement = null;
                    throw throwable;
                }
            }
            try {
                if (this.dsvRecordsPerCommit > 0 && (n11 - n) % this.dsvRecordsPerCommit != 0) {
                    this.shared.jdbcConn.commit();
                    this.shared.possiblyUncommitteds = false;
                }
                if (bl3) {
                    this.shared.jdbcConn.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {
                throw new SqlToolError(SqltoolRB.rpc_commit_failure.getString(), sQLException);
            }
            object2 = null;
            if (n11 > 0) {
                object2 = SqltoolRB.dsv_import_summary.getString(string2 == null ? "" : "'" + string2 + "'-", Integer.toString(n10), Integer.toString(n), Integer.toString(n11 - n), bl4 ? "importAborted" : null);
                this.stdprintln((String)object2);
            }
            try {
                if (n11 > n && this.dsvRecordsPerCommit < 1 && !this.shared.jdbcConn.getAutoCommit()) {
                    this.stdprintln(SqltoolRB.insertions_notcommitted.getString());
                }
            }
            catch (SQLException sQLException) {
                this.stdprintln(SqltoolRB.autocommit_fetchfail.getString());
                this.stdprintln(SqltoolRB.insertions_notcommitted.getString());
            }
            if (printWriter != null) {
                printWriter.flush();
            }
            if (printWriter2 != null && n > 0) {
                printWriter2.println(SqltoolRB.rejectreport_bottom.getString(new String[]{object2, revnum}));
                printWriter2.flush();
            }
            if (n != 0) return;
            if (file2 != null && file2.exists() && !file2.delete()) {
                this.errprintln(SqltoolRB.dsv_rejectfile_purgefail.getString(file2.toString()));
            }
            if (file3 == null) return;
            if (file3.delete()) return;
            this.errprintln(SqltoolRB.dsv_rejectreport_purgefail.getString(file2 == null ? null : file2.toString()));
            return;
        }
        finally {
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                finally {
                    printWriter = null;
                }
            }
            if (printWriter2 != null) {
                try {
                    printWriter2.close();
                }
                finally {
                    printWriter2 = null;
                }
            }
        }
    }

    protected static void appendLine(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + LS);
    }

    private static String[] genWinArgs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cmd.exe");
        arrayList.add("/y");
        arrayList.add("/c");
        Matcher matcher = wincmdPattern.matcher(string);
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (matcher.group(i) == null) continue;
                if (matcher.group(i).length() > 1 && matcher.group(i).charAt(0) == '\"') {
                    arrayList.add(matcher.group(i).substring(1, matcher.group(i).length() - 1));
                    continue;
                }
                arrayList.addAll(Arrays.asList(matcher.group(i).split("\\s+", -1)));
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private void genRejectReportRecord(PrintWriter printWriter, int n, int n2, String string, String string2, Throwable throwable) {
        printWriter.println(SqltoolRB.rejectreport_row.getString((n % 2 == 0 ? "even" : "odd") + "row", Integer.toString(n), Integer.toString(n2), string == null ? "&nbsp;" : string, (string2 == null ? "" : string2) + (string2 == null || throwable == null ? "" : "<HR/>") + (throwable == null ? "" : (throwable instanceof SQLException && throwable.getMessage() != null ? throwable.getMessage() : throwable.toString()))));
    }

    private TokenList seekTokenSource(String string) throws BadSpecial, IOException {
        Token token;
        TokenList tokenList = new TokenList();
        Pattern pattern = Pattern.compile("end\\s+" + string);
        while ((token = this.scanner.yylex()) != null) {
            if (token.type == 2 && pattern.matcher(token.val).matches()) {
                return tokenList;
            }
            String string2 = this.nestingCommand(token);
            if (string2 != null) {
                token.nestedBlock = this.seekTokenSource(string2);
            }
            tokenList.add(token);
        }
        throw new BadSpecial(SqltoolRB.pl_block_unterminated.getString(string));
    }

    private void processMacro(Token token) throws BadSpecial {
        if (token.val.length() < 1) {
            throw new BadSpecial(SqltoolRB.macro_tip.getString());
        }
        switch (token.val.charAt(0)) {
            case '?': {
                this.stdprintln(SqltoolRB.macro_help.getString());
                break;
            }
            case '=': {
                String string = token.val;
                string = string.substring(1).trim();
                if (string.length() < 1) {
                    for (Map.Entry<String, Token> entry : this.shared.macros.entrySet()) {
                        this.stdprintln(entry.getKey() + " = " + entry.getValue().reconstitute());
                    }
                    break;
                }
                int n = -1;
                StringBuffer stringBuffer = new StringBuffer();
                Matcher matcher = editMacroPattern.matcher(string);
                if (matcher.matches()) {
                    if (this.buffer == null) {
                        this.stdprintln(nobufferYetString);
                        return;
                    }
                    stringBuffer.append(this.buffer.val);
                    if (matcher.groupCount() > 1 && matcher.group(2) != null && matcher.group(2).length() > 0) {
                        stringBuffer.append(matcher.group(2));
                    }
                    n = this.buffer.type;
                } else {
                    matcher = spMacroPattern.matcher(string);
                    if (matcher.matches()) {
                        stringBuffer.append(matcher.group(3));
                        n = matcher.group(2).equals("*") ? 2 : 1;
                    } else {
                        matcher = sqlMacroPattern.matcher(string);
                        if (!matcher.matches()) {
                            throw new BadSpecial(SqltoolRB.macro_malformat.getString());
                        }
                        stringBuffer.append(matcher.group(2));
                        n = 0;
                    }
                }
                if (stringBuffer.length() < 1) {
                    throw new BadSpecial(SqltoolRB.macrodef_empty.getString());
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == ';') {
                    throw new BadSpecial(SqltoolRB.macrodef_semi.getString());
                }
                this.shared.macros.put(matcher.group(1), new Token(n, stringBuffer, token.line));
                break;
            }
            default: {
                Matcher matcher = useMacroPattern.matcher(token.val);
                if (!matcher.matches()) {
                    throw new BadSpecial(SqltoolRB.macro_malformat.getString());
                }
                Token token2 = this.shared.macros.get(matcher.group(1));
                if (token2 == null) {
                    throw new BadSpecial(SqltoolRB.macro_undefined.getString(matcher.group(1)));
                }
                this.setBuf(token2);
                this.buffer.line = token.line;
                if (matcher.groupCount() > 1 && matcher.group(2) != null && matcher.group(2).length() > 0) {
                    this.buffer.val = this.buffer.val + matcher.group(2);
                }
                this.preempt = matcher.group(matcher.groupCount()).equals(";");
            }
        }
    }

    public static byte[] hexCharOctetsToBytes(String string) {
        int n = string.length();
        if (n != n / 2 * 2) {
            throw new NumberFormatException("Hex character lists contains an odd number of characters: " + n);
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'f') {
                n3 += 10 + c - 97;
            } else if (c >= 'A' && c <= 'F') {
                n3 += 10 + c - 65;
            } else if (c >= '0' && c <= '9') {
                n3 += c - 48;
            } else {
                throw new NumberFormatException("Non-hex character in input at offset " + i + ": " + c);
            }
            n3 <<= 4;
            c = string.charAt(++i);
            if (c >= 'a' && c <= 'f') {
                n3 += 10 + c - 97;
            } else if (c >= 'A' && c <= 'F') {
                n3 += 10 + c - 65;
            } else if (c >= '0' && c <= '9') {
                n3 += c - 48;
            } else {
                throw new NumberFormatException("Non-hex character in input at offset " + i + ": " + c);
            }
            byArray[n2++] = (byte)n3;
        }
        if (byArray.length != n2) {
            throw new RuntimeException("Internal accounting problem.  Expected to fill buffer of size " + byArray.length + ", but wrote only " + n2 + " bytes");
        }
        return byArray;
    }

    public static byte[] bitCharsToBytes(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        throw new NumberFormatException("Sorry.  Bit exporting not supported yet");
    }

    private void requireConnection() throws SqlToolError {
        if (this.shared.jdbcConn == null) {
            throw new SqlToolError(SqltoolRB.no_required_conn.getString());
        }
    }

    public static String getBanner(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData == null ? null : SqltoolRB.jdbc_established.getString(databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getUserName(), (connection.isReadOnly() ? "R/O " : "R/W ") + RCData.tiToString(connection.getTransactionIsolation()));
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private void displayConnBanner() {
        String string = this.shared.jdbcConn == null ? SqltoolRB.disconnected_msg.getString() : SqlFile.getBanner(this.shared.jdbcConn);
        this.stdprintln(string == null ? SqltoolRB.connected_fallbackmsg.getString() : string);
    }

    private String dereferenceAt(String string) throws BadSpecial {
        if (string.indexOf(64) != 0) {
            return string;
        }
        if (this.baseDir == null) {
            throw new BadSpecial("Leading @ in file paths has special meaning, and may  only be used if input is a file.");
        }
        return this.baseDir.getPath() + string.substring(1);
    }

    static {
        LS = System.getProperty("line.separator");
        DEFAULT_FILE_ENCODING = System.getProperty("file.encoding");
        specialPattern = Pattern.compile("(\\S+)(?:\\s+(.*\\S))?\\s*");
        plPattern = Pattern.compile("(.*\\S)?\\s*");
        foreachPattern = Pattern.compile("foreach\\s+(\\S+)\\s*\\(([^)]+)\\)\\s*");
        ifwhilePattern = Pattern.compile("\\S+\\s*\\(([^)]*)\\)\\s*");
        varsetPattern = Pattern.compile("(\\S+)\\s*([=_~])\\s*(?:(.*\\S)\\s*)?");
        substitutionPattern = Pattern.compile("(\\S)(.+?)\\1(.*?)\\1(.+)?\\s*");
        slashHistoryPattern = Pattern.compile("\\s*/([^/]+)/\\s*(\\S.*)?");
        historyPattern = Pattern.compile("\\s*(-?\\d+)?\\s*(\\S.*)?");
        useMacroPattern = Pattern.compile("(\\w+)(\\s.*[^;])?(;?)");
        editMacroPattern = Pattern.compile("(\\w+)\\s*:(.*)");
        spMacroPattern = Pattern.compile("(\\w+)\\s+([*\\\\])(.*\\S)");
        sqlMacroPattern = Pattern.compile("(\\w+)\\s+(.*\\S)");
        integerPattern = Pattern.compile("\\d+");
        nameValPairPattern = Pattern.compile("\\s*(\\w+)\\s*=(.*)");
        dotPattern = Pattern.compile("(\\w*)\\.(\\w*)");
        commitOccursPattern = Pattern.compile("(?is)(?:set\\s+autocommit.*)|(commit\\s*)");
        logPattern = Pattern.compile("(?i)(FINER|WARNING|SEVERE|INFO|FINEST)\\s+(.*\\S)");
        arrayPattern = Pattern.compile("ARRAY\\s*\\[\\s*(.*\\S)?\\s*\\]");
        nestingPLCommands = new HashMap<String, Pattern>();
        nestingPLCommands.put("if", ifwhilePattern);
        nestingPLCommands.put("while", ifwhilePattern);
        nestingPLCommands.put("foreach", foreachPattern);
        if (System.getProperty("os.name").startsWith("Windows")) {
            wincmdPattern = Pattern.compile("([^\"]+)?(\"[^\"]*\")?");
        }
        rawPrompt = SqltoolRB.rawmode_prompt.getString() + "> ";
        DSV_OPTIONS_TEXT = SqltoolRB.dsv_options.getString();
        D_OPTIONS_TEXT = SqltoolRB.d_options.getString();
        DSV_X_SYNTAX_MSG = SqltoolRB.dsv_x_syntax.getString();
        DSV_M_SYNTAX_MSG = SqltoolRB.dsv_m_syntax.getString();
        nobufferYetString = SqltoolRB.nobuffer_yet.getString();
        try {
            createArrayOfMethod = Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        revnum = "$Revision: 4351 $".substring("$Revision: ".length(), "$Revision: 4351 $".length() - 2);
        nonVarChars = new char[]{' ', '\t', '=', '}', '\n', '\r', '\f'};
        DEFAULT_ROW_DELIM = LS;
        listMDSchemaCols = new int[]{1};
        listMDIndexCols = new int[]{2, 6, 3, 9, 4, 10, 11};
        listMDTableCols = new int[][]{{2, 3}, {2, 3}, {2, 3}};
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
    }

    private class RowError
    extends AppendableException {
        static final long serialVersionUID = 754346434606022750L;

        RowError(String string) {
            super(string);
        }

        RowError(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private class BadSubst
    extends Exception {
        static final long serialVersionUID = 7325933736897253269L;

        BadSubst(String string) {
            super(string);
        }
    }

    private class ContinueException
    extends SqlToolError {
        static final long serialVersionUID = 5064604160827106014L;

        public ContinueException() {
        }

        public ContinueException(String string) {
            super(string);
        }
    }

    private class BreakException
    extends SqlToolError {
        static final long serialVersionUID = 351150072817675994L;

        public BreakException() {
        }

        public BreakException(String string) {
            super(string);
        }
    }

    private class QuitNow
    extends SqlToolError {
        static final long serialVersionUID = 1811094258670900488L;

        public QuitNow(String string) {
            super(string);
        }

        public QuitNow() {
        }
    }

    private static class BadSpecial
    extends AppendableException {
        static final long serialVersionUID = 7162440064026570590L;

        BadSpecial(String string) {
            super(string);
            if (string == null) {
                throw new RuntimeException("Must construct BadSpecials with non-null message");
            }
        }

        BadSpecial(String string, Throwable throwable) {
            super(string, throwable);
            if (string == null) {
                throw new RuntimeException("Must construct BadSpecials with non-null message");
            }
        }
    }

    private static class SharedFields {
        boolean possiblyUncommitteds;
        Connection jdbcConn;
        Map<String, String> userVars = new HashMap<String, String>();
        Map<String, Token> macros = new HashMap<String, Token>();
        PrintStream psStd;
        String encoding;

        SharedFields(PrintStream printStream) {
            this.psStd = printStream;
        }
    }
}

