
package jp.gr.java_conf.u6k.state_engine;

import java.util.ArrayList;
import java.util.List;

public abstract class StateObject {

    private List<State> stateList = new ArrayList<State>();

    private long        time;

    protected List<State> getStateList() {
        return this.stateList;
    }

    final void execute(StateContext ctx) {
        for (State s : this.stateList.toArray(new State[0])) {
            s.execute(ctx);
        }
    }

    final void receiveMessage(StateContext ctx, Message msg) {
        for (State s : this.stateList.toArray(new State[0])) {
            s.receiveMessage(ctx, msg);
        }
    }

    final void stateTransition(StateContext ctx) {
        for (State s : this.stateList.toArray(new State[0])) {
            for (Transition t : s.getDestinationTransitionList()) {
                if (t.condition(this, ctx)) {
                    s.dispose(ctx);
                    this.stateList.remove(s);

                    State nextState = t.getDestinationState();
                    if (nextState != null) {
                        nextState.initialize(ctx);
                        this.stateList.add(nextState);
                    }
                }
            }
        }
    }

    final boolean isDisposed() {
        return this.stateList.size() == 0;
    }

    public long getTime() {
        return this.time;
    }

    final void incrementTime() {
        this.time++;
    }

}
