
package jp.gr.java_conf.u6k.state_engine;

import java.util.ArrayList;
import java.util.List;

import jp.gr.java_conf.u6k.animation.AnimationWindow;

public class StateEngine {

    private List<StateObject> stateObjectList = new ArrayList<StateObject>();

    private StateContext      ctx             = new StateContext();

    public StateEngine(StateObject startupObject) {
        if (startupObject == null) {
            throw new NullPointerException("startupObject == null");
        }
        this.stateObjectList.add(startupObject);
    }

    public void execute(AnimationWindow window) {
        StateObject obj;
        Message msg;

        // コンテキストを初期化
        this.ctx.getValueMap().clear();
        this.ctx.getValueMap().put("window", window);

        // 元から存在するオブジェクトを処理
        for (int i = 0; i < this.stateObjectList.size(); i++) {
            obj = this.stateObjectList.get(i);

            this.ctx.setTarget(obj);
            obj.execute(this.ctx);
            obj.incrementTime();
        }

        while (!this.ctx.getAddedStateObjectQueue().isEmpty() || !this.ctx.getSendedMessageQueue().isEmpty()) {
            // 追加されたオブジェクトを処理&追加
            while ((obj = this.ctx.getAddedStateObjectQueue().poll()) != null) {
                this.stateObjectList.add(obj);

                this.ctx.setTarget(obj);
                obj.execute(this.ctx);
                obj.incrementTime();
            }

            // メッセージを処理
            while ((msg = this.ctx.getSendedMessageQueue().poll()) != null) {
                for (int i = 0; i < this.stateObjectList.size(); i++) {
                    obj = this.stateObjectList.get(i);

                    this.ctx.setTarget(obj);
                    obj.receiveMessage(ctx, msg);
                }
            }
        }

        // 状態遷移
        for (int i = 0; i < this.stateObjectList.size(); i++) {
            obj = this.stateObjectList.get(i);

            ctx.setTarget(obj);
            obj.stateTransition(ctx);
            if (obj.isDisposed()) {
                this.stateObjectList.remove(obj);
            }
        }
    }
}
