
package jp.gr.java_conf.u6k.state_engine;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class StateContext {

    private Queue<StateObject>  addedStateObjectQueue = new LinkedList<StateObject>();

    private Queue<Message>      sendedMessageQueue    = new LinkedList<Message>();

    private StateObject         target;

    private Map<String, Object> valueMap              = new HashMap<String, Object>();

    public StateObject getTarget() {
        return this.target;
    }

    final void setTarget(StateObject target) {
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        this.target = target;
    }

    public void addStateObject(StateObject obj) {
        if (obj == null) {
            throw new NullPointerException("obj == null");
        }
        this.addedStateObjectQueue.offer(obj);
    }

    final Queue<StateObject> getAddedStateObjectQueue() {
        return this.addedStateObjectQueue;
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }

    public void sendMessage(Message msg) {
        if (msg == null) {
            throw new NullPointerException("msg == null");
        }
        this.sendedMessageQueue.offer(msg);
    }

    final Queue<Message> getSendedMessageQueue() {
        return this.sendedMessageQueue;
    }

}
