
package jp.gr.java_conf.u6k.sample.stg1;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.state_engine.StateContext;
import jp.gr.java_conf.u6k.state_engine.StateObject;
import jp.gr.java_conf.u6k.state_engine.Transition;

public class EnemyDisposeTransition extends Transition {

    @Override
    public boolean condition(StateObject obj, StateContext ctx) {
        // 取得
        EnemyObject o = (EnemyObject) obj;
        double x = o.getX();
        double y = o.getY();
        int hp = o.getHitPoint();

        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        int w = window.getWidth();
        int h = window.getHeight();

        // 判断
        return (x < 0) || (y < 0) || (x > w) || (y > h) || (hp == 0);
    }

}
