
package jp.gr.java_conf.u6k.sample.moveChar1;

import java.awt.event.KeyEvent;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.animation.KeyInfo;
import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class PlayerMoveState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        PlayerObject obj = (PlayerObject) ctx.getTarget();
        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        KeyInfo keyInfo = window.getKeyInfo();

        double x = obj.getX();
        double y = obj.getY();

        // 計算
        if (keyInfo.isKey(KeyEvent.VK_UP)) {
            y -= 1;
        }
        if (keyInfo.isKey(KeyEvent.VK_DOWN)) {
            y += 1;
        }
        if (keyInfo.isKey(KeyEvent.VK_LEFT)) {
            x -= 1;
        }
        if (keyInfo.isKey(KeyEvent.VK_RIGHT)) {
            x += 1;
        }

        // 設定
        obj.setX(x);
        obj.setY(y);
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

    @Override
    public void initialize(StateContext ctx) {
    }

}
