
package jp.gr.java_conf.u6k.sample.stg1;

import java.awt.event.KeyEvent;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.animation.KeyInfo;
import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class PlayerShotState extends State {

    private int interval = 0;

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        PlayerObject o = (PlayerObject) ctx.getTarget();
        double x = o.getX();
        double y = o.getY();
        long time = o.getTime();

        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        KeyInfo keyInfo = window.getKeyInfo();

        // 自弾生成
        if (keyInfo.isKey(KeyEvent.VK_Z) && this.interval == 0) {
            for (int i = 0; i < 2; i++) {
                double angle = 2 * Math.PI / 60 * (time % 60) + 2 * Math.PI / 2 * i;

                PlayerBulletObject bullet = new PlayerBulletObject(10 * Math.sin(angle) + x, y, 0, -10);
                ctx.addStateObject(bullet);
            }

            this.interval = 1;
        } else {
            if (this.interval > 0) {
                this.interval--;
            }
        }
    }

    @Override
    public void initialize(StateContext ctx) {
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

}
