
package jp.gr.java_conf.u6k.sample.stg1;

import java.awt.Rectangle;

import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class PlayerBulletMoveState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        PlayerBulletObject o = (PlayerBulletObject) ctx.getTarget();

        // 設定
        o.setX(o.getX() + o.getXSpeed());
        o.setY(o.getY() + o.getYSpeed());

        // 攻撃
        Rectangle hitRect = new Rectangle((int) o.getX() - 1, (int) o.getY() - 1, 3, 10);
        PlayerBulletAttackMessage msg = new PlayerBulletAttackMessage(hitRect);
        ctx.sendMessage(msg);
    }

    @Override
    public void initialize(StateContext ctx) {
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

}
