
package jp.gr.java_conf.u6k.sample.stg1;

import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class EnemyShotState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        EnemyObject o = (EnemyObject) ctx.getTarget();
        double x = o.getX();
        double y = o.getY();

        // 敵弾生成
        if (o.getTime() % 60 == 0) {
            EnemyBulletObject bullet = new EnemyBulletObject(x, y, 0, 2);
            ctx.addStateObject(bullet);
        }
    }

    @Override
    public void initialize(StateContext ctx) {
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

}
