
package jp.gr.java_conf.u6k.sample.stg1;

import jp.gr.java_conf.u6k.state_engine.StateObject;

public class EnemyObject extends StateObject {

    private double x;

    private double y;

    private double xSpeed;

    private int    hitPoint = 3;

    public EnemyObject() {
        // 属性
        this.xSpeed = (Math.random() - 0.5) * 5;

        if (this.xSpeed > 0) {
            this.x = 0;
        } else {
            this.x = 640;
        }

        this.y = Math.random() * 90 + 10;

        // 状態
        EnemyDrawState drawState = new EnemyDrawState();
        drawState.getDestinationTransitionList().add(new EnemyDisposeTransition());
        this.getStateList().add(drawState);

        EnemyMoveState moveState = new EnemyMoveState();
        moveState.getDestinationTransitionList().add(new EnemyDisposeTransition());
        this.getStateList().add(moveState);

        EnemyShotState shotState = new EnemyShotState();
        shotState.getDestinationTransitionList().add(new EnemyDisposeTransition());
        this.getStateList().add(shotState);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getXSpeed() {
        return this.xSpeed;
    }

    public void setXSpeed(double speed) {
        xSpeed = speed;
    }

    public int getHitPoint() {
        return this.hitPoint;
    }

    public void setHitPoint(int hitPoint) {
        this.hitPoint = hitPoint;
    }

}
