
package jp.gr.java_conf.u6k.sample.stg1;

import java.awt.Rectangle;

import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class EnemyMoveState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        EnemyObject o = (EnemyObject) ctx.getTarget();

        // 計算、設定
        o.setX(o.getX() + o.getXSpeed());
    }

    @Override
    public void initialize(StateContext ctx) {
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
        if (msg instanceof PlayerBulletAttackMessage) {
            PlayerBulletAttackMessage m = (PlayerBulletAttackMessage) msg;
            EnemyObject o = (EnemyObject) ctx.getTarget();
            if (o.getHitPoint() > 0) {
                Rectangle enemyHitRect = new Rectangle((int) o.getX() - 15, (int) o.getY() - 15, 30, 30);
                if (m.getHitRect().contains(enemyHitRect)) {
                    o.setHitPoint(o.getHitPoint() - 1);
                }
            }
        }
    }

}
