
package jp.gr.java_conf.u6k.sample.stg1;

import java.awt.Graphics2D;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class EnemyDrawState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        EnemyObject o = (EnemyObject) ctx.getTarget();
        double x = o.getX();
        double y = o.getY();
        long time = o.getTime();

        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        Graphics2D g = window.getCanvas();

        // 本体描画
        g.drawRect((int) x - 15, (int) y - 15, 30, 30);

        // オプション描画
        for (int i = 0; i < 3; i++) {
            double angle = 2 * Math.PI / 60 * (time % 60) + 2 * Math.PI / 3 * i;
            int optX = (int) (15 * Math.cos(angle) + x);
            int optY = (int) (15 * Math.sin(angle) + y);

            g.drawRect(optX - 3, optY - 3, 6, 6);
        }
    }

    @Override
    public void initialize(StateContext ctx) {
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

}
