
package jp.gr.java_conf.u6k.sample.bar;

import java.awt.Color;
import java.awt.Graphics2D;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class BarFadeoutDrawState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        BarFadeoutObject obj = (BarFadeoutObject) ctx.getTarget();
        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        Graphics2D g = window.getCanvas();

        double x = obj.getX();
        double y = obj.getY();

        // 計算、描画
        int c = 255 - (int) (255d / 60 * obj.getTime());
        Color color = new Color(c, c, c);

        g.setColor(color);
        g.fillOval((int) x, (int) y, 20, 20);
        g.setColor(Color.BLACK);
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

    @Override
    public void initialize(StateContext ctx) {
    }

}
