package com.td.utility;

public class Delay {
	public static final String DELM = "\t";
	private static final int N = 5;
	
	private long id;
	private int ymd;
	private int hm;
	private int cntpmi; // gp
	private boolean status;
	
	public static Delay[] getInstances(String data){
		if (data == null || data.length() == 0){
			return new Delay[0];
		}
		String[] flds = data.split(DELM);
		if ((flds.length % N) != 0){
			return new Delay[0];			
		}

		long id = -1;
		int ymd = -1;
		int hm = -1;
		int cntpmi = -1;
		boolean status = false;

		Delay[] delays = new Delay[flds.length / N];
		for (int i = 0; i < flds.length / N; i++){
			for (int j = 0; j < N; j++){
				String val = flds[i * N + j];
				switch (j){
				case 0:
					id = Long.valueOf(val);
					break;
				case 1:
					ymd = Integer.valueOf(val);
					break;
				case 2:
					hm = Integer.valueOf(val);
					break;
				case 3:
					cntpmi = Integer.valueOf(val);
					break;
				case 4:
					status = Util.toBoolean(Integer.valueOf(val));
					break;
				}
			}
			Delay delay = new Delay(id, ymd, hm, cntpmi, status);
			delays[i] = delay;
		}
		return delays;
	}
	
	public static StringBuffer getData(Delay[] delays){
		StringBuffer sb = new StringBuffer();
		for (Delay delay : delays){
			setData(sb, delay);
		}
		return sb;
	}
	
	public static void setData(StringBuffer sb, Delay delay){
		sb.append(delay.getId());
		sb.append(DELM);
		sb.append(delay.getYmd());
		sb.append(DELM);
		sb.append(delay.getHm());
		sb.append(DELM);
		sb.append(delay.getCntpmi());
		sb.append(DELM);
		sb.append(Util.toInt(delay.isStatus()));
		sb.append(DELM);
	}
	
	public static Delay search(Delay[] delays, long id){
		for (Delay delay : delays){
			if (delay.getId() == id){
				return delay;
			}
		}
		return null;
	}

	public Delay(long id, int ymd, int hm, int cntpmi, boolean status){
		this.id = id;
		this.ymd = ymd;
		this.hm = hm;
		this.cntpmi = cntpmi;
		this.status = status;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public int getYmd() {
		return ymd;
	}

	public void setYmd(int ymd) {
		this.ymd = ymd;
	}

	public int getHm() {
		return hm;
	}

	public void setHm(int hm) {
		this.hm = hm;
	}

	public int getCntpmi() {
		return cntpmi;
	}

	public void setCntpmi(int cntpmi) {
		this.cntpmi = cntpmi;
	}

	public boolean isStatus() {
		return status;
	}

	public void setStatus(boolean status) {
		this.status = status;
	}

}
