package com.td.db;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.td.utility.DBCacheInterface;
import com.td.utility.Util;

public class TrainDao implements DBCacheInterface<Train, Long>{
	private static TrainDao instance = null;
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement updateStmt = null;
	private SQLiteStatement updateStmt2 = null;
	private SQLiteStatement updateStmt3 = null;
	private SQLiteStatement deleteStmt = null;

	public static TrainDao getInstance() {
		if (instance == null) {
			instance = new TrainDao();
		}
		return instance;
	}

	private TrainDao() {

	}

	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE TRAIN (" + android.provider.BaseColumns._ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT," + "NAME TEXT,"
				+ "SEARCH_TEXT TEXT," + "SELECTED INTEGER" + ");");
	}

	public void init(SQLiteDatabase db) {

	}

	public void start(SQLiteDatabase db) {
		insertStmt = db.compileStatement("INSERT INTO TRAIN ("
				+ "NAME, SEARCH_TEXT, SELECTED" + ") VALUES (" + "?, ?, ?"
				+ ");");
		updateStmt = db.compileStatement("UPDATE TRAIN SET " + "SELECTED = ? "
				+ "WHERE " + android.provider.BaseColumns._ID + " = ?;");
		updateStmt2 = db.compileStatement("UPDATE TRAIN SET "
				+ "SEARCH_TEXT = ? " + "WHERE "
				+ android.provider.BaseColumns._ID + " = ?;");
		updateStmt3 = db.compileStatement("UPDATE TRAIN SET "
				+ "SEARCH_TEXT = ? ," + "SELECTED = ? " + "WHERE "
				+ android.provider.BaseColumns._ID + " = ?;");
		deleteStmt = db.compileStatement("DELETE FROM TRAIN");
	}

	public List<Train> search() {
		return search(null, null, android.provider.BaseColumns._ID);
	}

	public List<Train> search(boolean selected) {
		String selection = "SELECTED = ?";
		String[] selectionArgs = new String[1];

		selectionArgs[0] = String.valueOf(Util.toInt(selected));

		return search(selection, selectionArgs,
				android.provider.BaseColumns._ID);
	}

	public List<Train> search(String name) {
		String selection = "NAME = ?";
		String[] selectionArgs = new String[1];

		selectionArgs[0] = name;

		return search(selection, selectionArgs,
				android.provider.BaseColumns._ID);
	}

	public Train searchById(long id) {
		String selection = android.provider.BaseColumns._ID + " = ?";
		String[] selectionArgs = new String[1];

		selectionArgs[0] = String.valueOf(id);

		List<Train> list = search(selection, selectionArgs, null);
		return (list.size() > 0) ? list.get(0) : null;
	}

	private List<Train> search(String selection, String[] selectionArgs,
			String orderBy) {
		List<Train> list = new ArrayList<Train>();
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getReadableDatabase();

		Cursor cursor = db.query("TRAIN", new String[] {
				android.provider.BaseColumns._ID, "NAME", "SEARCH_TEXT",
				"SELECTED" }, selection, selectionArgs, null, null, orderBy);
		try {
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				Train train = new Train(cursor.getInt(0), cursor.getString(1),
						cursor.getString(2), cursor.getInt(3));
				list.add(train);
				cursor.moveToNext();
			}
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return list;
	}

	public List<Train> search(long pid) {
		String sql = "select train._id, train.name, train.search_text, train.selected "
				+ "from train "
				+ "inner join relation on relation.pid = ? and relation.tid = train._id";
		String[] selectionArgs = new String[1];
		selectionArgs[0] = String.valueOf(pid);

		List<Train> list = new ArrayList<Train>();

		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getReadableDatabase();
		Cursor cursor = db.rawQuery(sql, selectionArgs);
		try {
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				Train train = new Train(cursor.getInt(0), cursor.getString(1),
						cursor.getString(2), cursor.getInt(3));
				list.add(train);
				cursor.moveToNext();
			}
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return list;
	}

	public int count() {
		String sql = "select count(*) " + "from train ";
		String[] selectionArgs = null;

		int count = -1;

			DatabaseHelper helper = DatabaseHelper.getInstance();
			SQLiteDatabase db = helper.getReadableDatabase();
			Cursor cursor = db.rawQuery(sql, selectionArgs);
		try {
			cursor.moveToFirst();
			int size = cursor.getCount();
			if (size > 0) {
				count = cursor.getInt(0);
			}
		}
		finally {
			if (cursor != null){
				cursor.close();
			}
		}
		return count;
	}

	public void add(Train train) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		add(db, train);
	}

	private long add(SQLiteDatabase db, Train train) {
		long id = -1;
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = insertStmt;
			stmt.bindString(i++, train.getName());
			stmt.bindString(i++, train.getSearchText());
			stmt.bindLong(i++, Util.toInt(train.isSelected()));
			id = stmt.executeInsert();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long addNT(Train train) {
		int i = 1;
		SQLiteStatement stmt = insertStmt;
		stmt.bindString(i++, train.getName());
		stmt.bindString(i++, train.getSearchText());
		stmt.bindLong(i++, Util.toInt(train.isSelected()));
		long id = stmt.executeInsert();
		return id;
	}

	public void set(long id, boolean selected) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = updateStmt;
			stmt.bindLong(i++, Util.toInt(selected));
			stmt.bindLong(i++, id);
			stmt.execute();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
	}

	public void set(long id, String searchText) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = updateStmt2;
			stmt.bindString(i++, searchText);
			stmt.bindLong(i++, id);
			stmt.execute();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
	}

	public void set(long id, String searchText, boolean selected) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = updateStmt3;
			stmt.bindString(i++, searchText);
			stmt.bindLong(i++, Util.toInt(selected));
			stmt.bindLong(i++, id);
			stmt.execute();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
	}

	public void deleteNT() {
		SQLiteStatement stmt = deleteStmt;
		stmt.execute();
	}

	public Train get(Long key) {
		return searchById(key.longValue());
	}
}
