package com.td.db;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.td.utility.Debug;

public class PrefectureDao {
	private static PrefectureDao instance = null;
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement deleteStmt = null;

	public static PrefectureDao getInstance() {
		if (instance == null) {
			instance = new PrefectureDao();
		}
		return instance;
	}

	private PrefectureDao() {

	}

	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE PREFECTURE ("
				+ android.provider.BaseColumns._ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT," + "NAME TEXT" + ");");
	}

	public void init(SQLiteDatabase db) {

	}

	public void start(SQLiteDatabase db) {
		insertStmt = db.compileStatement("INSERT INTO PREFECTURE (" + "NAME"
				+ ") VALUES (" + "?" + ");");
		deleteStmt = db.compileStatement("DELETE FROM PREFECTURE");
	}

	public List<Prefecture> search() {
		return search(null, null, android.provider.BaseColumns._ID);
	}

	private List<Prefecture> search(String selection, String[] selectionArgs,
			String orderBy) {
		List<Prefecture> list = new ArrayList<Prefecture>();
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getReadableDatabase();

		Cursor cursor = db.query("PREFECTURE", new String[] {
				android.provider.BaseColumns._ID, "NAME", }, selection,
				selectionArgs, null, null, orderBy);
		try {
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				Prefecture prefecture = new Prefecture(cursor.getInt(0),
						cursor.getString(1));
				list.add(prefecture);
				cursor.moveToNext();
			}
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return list;
	}

	public void delete() {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			SQLiteStatement stmt = deleteStmt;
			stmt.execute();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
	}

	public long addNT(Prefecture prefecture) {
		int i = 1;
		SQLiteStatement stmt = insertStmt;
		stmt.bindString(i++, prefecture.getName());
		long id = stmt.executeInsert();
		return id;
	}

	public void deleteNT() {
		SQLiteStatement stmt = deleteStmt;
		stmt.execute();
	}
}
