package com.td;

import java.util.List;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.TextView;

import com.td.db.Train;

public class TrainListViewArrayAdapter extends ArrayAdapter<Train> {
    private LayoutInflater inflater;

    public TrainListViewArrayAdapter(Context context, int resourceId, List<Train> items) {
        super(context, resourceId, items);
        this.inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent){
        View view = convertView;  
        if(view == null){  
            view = inflater.inflate(R.layout.check_list_item_1, null);  
        }      

        Train item = getItem(position);
        
        boolean selected = item.isSelected();
        CheckBox checkbox = (CheckBox)view.findViewById(R.id.checkBox);
        checkbox.setEnabled(false);
        checkbox.setChecked(selected);

        TextView text = (TextView)view.findViewById(R.id.text2);  
        text.setText(item.getName());  
        
        return view;
    }
    
}
