package com.td;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;

import com.td.db.Train;
import com.td.db.TrainDao;
import com.td.service.TrainDelayedServiceImpl;
import com.td.utility.BaseActivity;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;
import com.td.utility.Util;
import com.td.webapi.RouteUpdater;

public class TrainEditActivity extends BaseActivity {
	public static final String PREF_TRE_ID = "TRE_ID";
	public static final String PREF_TRE_NAME = "TRE_NAME";
	public static final String PREF_TRE_SNAME = "TRE_SNAME";

	public static final String JR = "JR";
	public static final String LINE = "";
	private EditText editText1;
	private EditText editText2;
	private CheckBox checkBox1;
	private CheckBox checkBox2;
	private Button button1;
	private Button button2;
	private Button button3;

	private EditPrefUtil pref = new EditPrefUtil(this);
	private Train train = null;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		getWindow().setSoftInputMode(
				LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
		setContentView(R.layout.train_edit);

		try {
			editText1 = (EditText) findViewById(R.id.editText31);
			editText2 = (EditText) findViewById(R.id.editText32);
			checkBox1 = (CheckBox) findViewById(R.id.checkBox31);
			checkBox2 = (CheckBox) findViewById(R.id.checkBox32);
			button1 = (Button) findViewById(R.id.button31);
			button2 = (Button) findViewById(R.id.button32);
			button3 = (Button) findViewById(R.id.button33);

			editText1.setEnabled(false);

			editText2.addTextChangedListener(new TextWatcher() {
				public void afterTextChanged(Editable editable) {
					editText();
					setStatus();
				}

				public void beforeTextChanged(CharSequence s, int start,
						int count, int after) {
					;
				}

				public void onTextChanged(CharSequence s, int start,
						int before, int count) {
					;
				}
			});

			checkBox1.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					editLine();
					setStatus();
				}
			});
			checkBox2.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					editJR();
					setStatus();
				}
			});
			button1.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					long id = train.getId();
					String sname = train.getSearchText();
					TrainDao.getInstance().set(id, sname, true);

					TrainDelayedServiceImpl.clearSchedule(
							TrainEditActivity.this, pref);

					setResult(RESULT_OK);
					finish();
				}
			});
			button2.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					setResult(RESULT_CANCELED);
					finish();
				}
			});
			button3.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					String name = train.getName();
					String sname = RouteUpdater.filter(name);
					editText2.setText(sname);
					train.setSearchText(sname);

					initStatus();
				}
			});
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	@Override
	protected void onResume() {
		super.onResume();

		try {
			String name = "";
			String sname = "";

			String idStr = pref.get(PREF_TRE_ID);
			if (idStr == null) {
				Bundle extras = getIntent().getExtras();
				long id = extras.getLong("ID");
				train = TrainDao.getInstance().searchById(id);
				if (train != null) {
					name = train.getName();
					sname = train.getSearchText();
				}
			} else {
				long id = Long.valueOf(idStr);
				name = pref.get(PREF_TRE_NAME);
				sname = pref.get(PREF_TRE_SNAME);
				train = new Train(id, name, sname, Util.toInt(false));
			}
			editText1.setText(name);
			editText2.setText(sname);
			initStatus();
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	@Override
	protected void onPause() {
		super.onPause();

		try {
			if (train != null) {
				pref.put(PREF_TRE_ID, String.valueOf(train.getId()));
				pref.put(PREF_TRE_NAME, train.getName());
				pref.put(PREF_TRE_SNAME, train.getSearchText());
				pref.update();
			}
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	private void editText() {
		if (train == null) {
			return;
		}
		String sname = editText2.getText().toString();
		train.setSearchText(sname);
	}

	private void editLine() {
		try {
			if (train == null) {
				return;
			}
			String sname = train.getSearchText();
			if (checkBox1.isChecked()) {
				int len = sname.length();
				int slen = LINE.length();
				if (len >= slen
						&& sname.substring(len - slen, len).equals(LINE)) {
					sname = sname.substring(0, len - slen);
				}
			} else {
				sname += LINE;
			}
			editText2.setText(sname);
			train.setSearchText(sname);
		} catch (Exception e) {
			Debug.d(this, null, e);
		}
	}

	private void editJR() {
		if (train == null) {
			return;
		}
		String sname = train.getSearchText();
		if (checkBox2.isChecked()) {
			int len = sname.length();
			int slen = JR.length();
			if (len >= slen && sname.substring(0, slen).equals(JR)) {
				sname = sname.substring(slen, len);
			}
		} else {
			sname = JR + sname;
		}
		editText2.setText(sname);
		train.setSearchText(sname);
	}

	private void initStatus() {
		String name = train.getName();
		String sname = train.getSearchText();

		int len = name.length();
		String ch = name.substring(len - 1, len);
		if (!ch.equals(LINE)) {
			checkBox1.setEnabled(false);
		} else {
			len = sname.length();
			String ch2 = "";
			if (sname.length() > 1) {
				ch2 = sname.substring(len - 1, len);
			}
			checkBox1.setChecked(!ch2.equals(LINE));
		}

		ch = name.substring(0, 2);
		if (!ch.equals(JR)) {
			checkBox2.setEnabled(false);
		} else {
			String ch2 = "";
			if (sname.length() > 2) {
				ch2 = sname.substring(0, 2);
			}
			checkBox2.setChecked(!ch2.equals(JR));
		}
	}

	private void setStatus() {
		if (button1 == null) {
			return;
		}
		if (train != null && train.getSearchText().length() > 0) {
			button1.setEnabled(true);
		} else {
			button1.setEnabled(false);
		}
	}

	public static void init(Context context) {
		EditPrefUtil pref = new EditPrefUtil(context);
		pref.remove(PREF_TRE_ID);
		pref.update();
	}
}
