package com.td;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.td.broadcast.DelayReceiver;
import com.td.db.Keyword;
import com.td.db.Monitor;
import com.td.db.MonitorDao;
import com.td.db.PrefectureDao;
import com.td.db.Train;
import com.td.db.TrainDao;
import com.td.service.SchedulerTest;
import com.td.service.TrainDelayedService;
import com.td.service.TrainDelayedServiceImpl;
import com.td.service.TrainTwitterAdapterTest;
import com.td.utility.BaseActivity;
import com.td.utility.ConfUtil;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;
import com.td.utility.StatusFlag;
import com.td.utility.StatusFlagFactory;
import com.td.utility.StatusFlagTest;
import com.td.utility.StringMap;
import com.td.wait.TrainServiceWaiting;

public class TrainDelayedActivity extends BaseActivity implements
		TrainDelayedService {
	public static final String PREF_TRD_DELAY = "TRD_DELAY";
	public static final String PREF_TRD_DELAY_MSG = "TRD_DELAY_MSG";

	private TextView textView0;
	private TextView textView1;
	private Button button1;
	private Button button2;
	private Button button3;
	private Button button4;
	private Button button5;
	private Button button6;
	private Button button7;
	private Button button9;
	private Button buttonz;
	private LinearLayout linearLayout0;
	private LinearLayout linearLayout01;
	private LinearLayout linearLayout1;
	private LinearLayout linearLayout2;
	private LinearLayout linearLayout3;
	private LinearLayout linearLayout4;
	private LinearLayout linearLayout5;
	private LinearLayout linearLayout6;
	private LinearLayout linearLayout7;
	private LinearLayout linearLayout9;

	private EditPrefUtil pref = new EditPrefUtil(this);
	private boolean isClick = false;

	private StatusFlag tsSf = StatusFlagFactory.getInstance().getStatusFlag(
			this, StatusFlagFactory.Type.TRAIN_SERVICE);
	private StatusFlag tdSf = StatusFlagFactory.getInstance().getStatusFlag(
			this, StatusFlagFactory.Type.TRAIN_DELAY_SERVICE);

	private BroadcastReceiver receiver = new BroadcastReceiver() {
		@Override
		public void onReceive(Context context, Intent intent) {
			String action = intent.getAction();

			if (action.compareTo(DelayReceiver.START_SERVICE) == 0) {
				setStatus();
			} else if (action.compareTo(DelayReceiver.STOP_SERVICE) == 0) {
				// gp
			} else if (action.compareTo(DelayReceiver.UPDATE) == 0) {
				setStatus();
			} else if (action.compareTo(DelayReceiver.DELAY) == 0) {
				;
			}
		}
	};

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		try {
			IntentFilter intentFilter = new IntentFilter();
			intentFilter.addAction(DelayReceiver.START_SERVICE);
			intentFilter.addAction(DelayReceiver.STOP_SERVICE);
			intentFilter.addAction(DelayReceiver.UPDATE);
			intentFilter.addAction(DelayReceiver.DELAY);
			registerReceiver(receiver, intentFilter);

			button1 = (Button) this.findViewById(R.id.button01);
			button1.setOnClickListener(new OnClickListener() {
				public void onClick(View v) {
					if (isClick) {
						return;
					}
					isClick = true;

					new AlertDialog.Builder(TrainDelayedActivity.this)
							.setTitle(getString(R.string.warn_dialog_title))
							.setMessage(getString(R.string.update_route_qmsg))
							.setPositiveButton(getString(R.string.yes_button),
									new DialogInterface.OnClickListener() {
										public void onClick(
												DialogInterface dialog,
												int whichButton) {
											doExecuteTrainDelayedActivity();

											isClick = false;
										}
									})
							.setNegativeButton(
									getString(R.string.cancel_button),
									new DialogInterface.OnClickListener() {
										public void onClick(
												DialogInterface dialog,
												int whichButton) {
											isClick = false;
										}
									}).create().show();
				}
			});

			button2 = (Button) this.findViewById(R.id.button02);
			button2.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					Intent intent = new Intent(TrainDelayedActivity.this,
							(Class<?>) PrefectureListActivity.class);
					startActivityForResult(intent, -1);
				}
			});

			button3 = (Button) this.findViewById(R.id.button03);
			button3.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					Intent intent = new Intent(TrainDelayedActivity.this,
							(Class<?>) MonitorTimeActivity.class);
					startActivityForResult(intent, -1);
				}
			});

			button4 = (Button) this.findViewById(R.id.button04);
			button4.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					if (isClick) {
						return;
					}
					isClick = true;

					new AlertDialog.Builder(TrainDelayedActivity.this)
							.setTitle(getString(R.string.warn_dialog_title))
							.setMessage(getString(R.string.start_service_qmsg))
							.setPositiveButton(getString(R.string.yes_button),
									new DialogInterface.OnClickListener() {
										public void onClick(
												DialogInterface dialog,
												int whichButton) {
											// T[rXJn
											startService();

											isClick = false;
										}
									})
							.setNegativeButton(
									getString(R.string.cancel_button),
									new DialogInterface.OnClickListener() {
										public void onClick(
												DialogInterface dialog,
												int whichButton) {
											isClick = false;
										}
									}).create().show();
				}
			});

			button5 = (Button) this.findViewById(R.id.button05);
			button5.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					if (isClick) {
						return;
					}
					isClick = true;

					new AlertDialog.Builder(TrainDelayedActivity.this)
							.setTitle(getString(R.string.warn_dialog_title))
							.setMessage(getString(R.string.end_service_qmsg))
							.setPositiveButton(getString(R.string.yes_button),
									new DialogInterface.OnClickListener() {
										public void onClick(
												DialogInterface dialog,
												int whichButton) {
											stopService();

											isClick = false;
										}
									})
							.setNegativeButton(
									getString(R.string.cancel_button),
									new DialogInterface.OnClickListener() {
										public void onClick(
												DialogInterface dialog,
												int whichButton) {
											isClick = false;
										}
									}).create().show();
				}
			});

			button6 = (Button) this.findViewById(R.id.button06);
			button6.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					HistoryActivity.init(TrainDelayedActivity.this);
					Intent intent = new Intent(TrainDelayedActivity.this,
							(Class<?>) HistoryActivity.class);
					startActivityForResult(intent, -1);
				}
			});

			button7 = (Button) this.findViewById(R.id.button07);
			button7.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					Intent intent = new Intent(TrainDelayedActivity.this,
							(Class<?>) ConfActivity.class);
					startActivityForResult(intent, -1);
				}
			});

			button9 = (Button) this.findViewById(R.id.button09);
			button9.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					TrainDelayedActivity.this.finish();
				}
			});

			buttonz = (Button) this.findViewById(R.id.button0z);
			buttonz.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					debug();
				}
			});
			if (!Debug.isDebug()) {
				buttonz.setVisibility(View.GONE);
			}

			linearLayout0 = (LinearLayout) this
					.findViewById(R.id.linearLayout00);
			linearLayout01 = (LinearLayout) this
					.findViewById(R.id.linearLayout001);
			linearLayout1 = (LinearLayout) this
					.findViewById(R.id.linearLayout01);
			linearLayout2 = (LinearLayout) this
					.findViewById(R.id.linearLayout02);
			linearLayout3 = (LinearLayout) this
					.findViewById(R.id.linearLayout03);
			linearLayout4 = (LinearLayout) this
					.findViewById(R.id.linearLayout04);
			linearLayout5 = (LinearLayout) this
					.findViewById(R.id.linearLayout05);
			linearLayout6 = (LinearLayout) this
					.findViewById(R.id.linearLayout06);
			linearLayout7 = (LinearLayout) this
					.findViewById(R.id.linearLayout07);
			linearLayout9 = (LinearLayout) this
					.findViewById(R.id.linearLayout09);

			textView0 = (TextView) this.findViewById(R.id.textView00);
			textView1 = (TextView) this.findViewById(R.id.textView01);
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	@Override
	protected void onStart() {
		super.onStart();

		try {
			setStatus();
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	@Override
	protected void onDestroy() {
		if (receiver != null) {
			unregisterReceiver(receiver);
		}

		super.onDestroy();
	}

	private void doExecuteTrainDelayedActivity() {
		tsSf.setOn();

		stopService();

		Intent intent = new Intent(TrainDelayedActivity.this,
				(Class<?>) WaitActivity.class);
		intent.putExtra(WaitActivity.CLASS, TrainServiceWaiting.class.getName());
		intent.putExtra(WaitActivity.MESSAGE0, getString(R.string.waiting_msg));
		intent.putExtra(WaitActivity.MESSAGE1,
				getString(R.string.start_rouote_msg));
		intent.putExtra(WaitActivity.MESSAGE2,
				getString(R.string.end_rouote_msg));
		intent.putExtra(WaitActivity.MESSAGE3,
				getString(R.string.end_rouote_emsg));

		WaitActivity.init(TrainDelayedActivity.this);
		startActivityForResult(intent, -1);
	}

	private void startService() {
		Intent intent = new Intent(TrainDelayedActivity.this,
				TrainDelayedServiceImpl.class);
		intent.setAction(TrainDelayedServiceImpl.START_ACTION);
		startService(intent);

		tdSf.setRdy();

		setStatus();
	}

	private void stopService() {
		Intent intent = new Intent(TrainDelayedActivity.this,
				TrainDelayedServiceImpl.class);
		PendingIntent alarmSender = PendingIntent.getService(
				TrainDelayedActivity.this, 0, intent, 0);
		AlarmManager alerm = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
		alerm.cancel(alarmSender);

		tdSf.setOff();
		setStatus();
	}

	public String updateDelayMsg() {
		Calendar cal = Calendar.getInstance();
		long t = cal.getTimeInMillis();

		return updateDelayMsg(t);
	}

	public String updateDelayMsg(long t) {
		StringMap map = new StringMap();
		String data = pref.get(PREF_TRD_DELAY);
		if (data != null) {
			map.setData(data);
		}

		Set<String> ks = map.keySet();
		for (Iterator<String> it = ks.iterator(); it.hasNext();) {
			String key = it.next();
			String value = map.get(key);
			long dt = Long.valueOf(value);

			long mi = ConfUtil.getWidth(pref);
			if (t - dt > mi * 60 * 1000) {
				it.remove();
			}
		}
		data = map.getData();
		pref.put(PREF_TRD_DELAY, data);

		StringBuffer sb = new StringBuffer();
		TrainDao dao = TrainDao.getInstance();
		for (Iterator<String> it = ks.iterator(); it.hasNext();) {
			String key = it.next();

			long id = Long.valueOf(key);
			Train train = dao.searchById(id);
			if (train != null) {
				if (sb.length() > 0) {
					sb.append("A");
				}
				sb.append(train.getName());
			}
		}
		if (sb.length() > 0) {
			sb.append(getString(R.string.is_delay_msg));

			String text = sb.toString();
			pref.put(PREF_TRD_DELAY_MSG, text);
			pref.update();

			return sb.toString();
		} else {
			pref.remove(PREF_TRD_DELAY_MSG);
			pref.update();

			return null;
		}
	}

	private void setStatus() {
		try {
			String text = "";

			boolean enabled1 = true;
			boolean enabled2 = true;
			boolean enabled3 = true;
			boolean enabled4 = true;
			boolean enabled5 = true;
			boolean enabled6 = true;
			boolean enabled7 = true;
			boolean enabled9 = true;

			int c0 = Color.rgb(0xff, 0xff, 0xff);
			int c1 = Color.rgb(0xcc, 0x33, 0x33);
			int color1 = c0;
			int color2 = c0;
			int color3 = c0;
			int color4 = c0;
			int color5 = c0;
			int color6 = c0;
			int color7 = c0;
			int color9 = c0;

			int msgNo = -1;

			if (tsSf.isOn()) {
				enabled1 = false;
				enabled2 = false;
				enabled3 = false;
				enabled4 = false;
				enabled5 = false;
				enabled6 = false;
				enabled7 = false;
				msgNo = 0;
			}

			int count = TrainDao.getInstance().count();
			if (count <= 0) {
				enabled2 = false;
				enabled3 = false;
				enabled4 = false;
				enabled5 = false;
				enabled6 = false;
				enabled7 = false;
				msgNo = 1;
			}

			List<Train> trainList = TrainDao.getInstance().search(true);
			int trainCount = trainList.size();
			if (trainCount == 0) {
				enabled4 = false;
				msgNo = (msgNo < 0) ? 2 : msgNo;
			}

			List<Monitor> listMonitor = MonitorDao.getInstance().search();
			int monitorCount = listMonitor.size();
			if (monitorCount == 0) {
				enabled4 = false;
				msgNo = (msgNo < 0) ? 3 : msgNo;
			}

			Debug.l("TrainDelayedActivity.setStatus() tdSf.get() "
					+ tdSf.toString());

			switch (tdSf.get()) {
			case StatusFlag.OFF:
				msgNo = (msgNo < 0) ? 4 : msgNo;
				enabled5 = false;
				break;
			case StatusFlag.RDY:
				msgNo = (msgNo < 0) ? 5 : msgNo;
				enabled1 = false;
				enabled2 = false;
				enabled3 = false;
				enabled4 = false;
				enabled5 = false;
				enabled6 = false;
				enabled7 = false;
				break;
			case StatusFlag.ON:
				enabled4 = false;
				break;
			case StatusFlag.ERR:
				enabled2 = false;
				enabled3 = false;
				enabled4 = false;
				enabled5 = false;
				enabled6 = false;
				enabled7 = false;
				break;
			default:
				break;
			}

			button1.setEnabled(enabled1);
			button2.setEnabled(enabled2);
			button3.setEnabled(enabled3);
			button4.setEnabled(enabled4);
			button5.setEnabled(enabled5);
			button6.setEnabled(enabled6);
			button7.setEnabled(enabled7);
			button9.setEnabled(enabled9);

			switch (msgNo) {
			case 0:
				text = getString(R.string.start_rouote_msg);
				break;
			case 1:
				text = getString(R.string.update_route_msg);
				color1 = c1;
				break;
			case 2:
				text = getString(R.string.conf_route_msg);
				color2 = c1;
				break;
			case 3:
				text = getString(R.string.conf_time_msg);
				color3 = c1;
				break;
			case 4:
				text = getString(R.string.start_service_msg);
				color4 = c1;
				break;
			case 5:
				text = getString(R.string.starting_service_msg);
				break;
			default:
				if (trainCount > 0) {
					StringBuffer sb = new StringBuffer();
					for (Train train : trainList) {
						if (sb.length() > 0) {
							sb.append(getString(R.string.comma_msg));
						}
						sb.append(train.getName());
					}
					sb.append(getString(R.string.do_service_msg));
					text = sb.toString();
				}
				break;
			}

			String updateMsg = updateDelayMsg();
			if (updateMsg != null) {
				linearLayout01.setVisibility(View.GONE);
				linearLayout0.setVisibility(View.VISIBLE);
				textView0.setText(updateMsg);

				color6 = c1;
			} else {
				linearLayout01.setVisibility(View.VISIBLE);
				linearLayout0.setVisibility(View.GONE);
			}

			textView1.setText(text);
			linearLayout1.setBackgroundColor(color1);
			linearLayout2.setBackgroundColor(color2);
			linearLayout3.setBackgroundColor(color3);
			linearLayout4.setBackgroundColor(color4);
			linearLayout5.setBackgroundColor(color5);
			linearLayout6.setBackgroundColor(color6);
			linearLayout7.setBackgroundColor(color7);
			linearLayout9.setBackgroundColor(color9);
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	private static boolean debugUpdateMsg = true;

	private void debug() {
		Intent intent;

		int n = 5;

		switch (n) {
		case 1:
			// xʒm
			List<Train> trainList = TrainDao.getInstance().search(true);
			for (Train train : trainList) {
				long id = train.getId();
				intent = new Intent(DelayReceiver.DELAY);
				intent.putExtra("ID", id);
				sendBroadcast(intent);
			}
			setStatus();
			break;
		case 2:
			// XPW[̃eXg
			SchedulerTest.repeat(TrainDelayedActivity.this);
			SchedulerTest.main();
			break;
		case 3:
			// u[hLXg
			intent = new Intent("com.td.broadcast.DelayReceiver");
			intent.putExtra("TEXT", "TvbZ[W");
			sendBroadcast(intent);
			break;
		case 4:
			// StatusFlag̃eXg
			StatusFlagTest.main(this);
			break;
		case 5:
			// NAAT[rX~
			StatusFlagFactory.getInstance().init(this);
			pref.remove(PREF_TRD_DELAY);
			pref.remove(PREF_TRD_DELAY_MSG);
			pref.update();

			stopService();

			setStatus();
			break;
		case 6:
			TrainTwitterAdapterTest.main(this);
			break;
		case 7:
			DelayReceiver r = new DelayReceiver();
			TrainDelayedActivityTest.main(this, r);
			break;
		case 8:
			// DB폜
			PrefectureDao.getInstance().delete();
			break;
		case 9:
			LinearLayout l = (LinearLayout) this
					.findViewById(R.id.linearLayout001);

			if (debugUpdateMsg) {
				l.setVisibility(View.GONE);
				linearLayout0.setVisibility(View.VISIBLE);
				textView0.setText("eXgł");

			} else {
				linearLayout0.setVisibility(View.GONE);
				l.setVisibility(View.VISIBLE);
			}
			debugUpdateMsg = !debugUpdateMsg;
		default:
			break;
		}
	}

	public Context getContext() {
		return this;
	}

	public List<Train> getTrains() {
		return null;
	}

	public List<Keyword> getKeywords() {
		return null;
	}

	public void notificate(String name) {

	}
}