package com.td;

import java.util.ArrayList;
import java.util.List;

import android.app.TimePickerDialog;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TimePicker;

import com.td.db.Monitor;
import com.td.db.MonitorDao;
import com.td.service.TrainDelayedServiceImpl;
import com.td.utility.BaseActivity;
import com.td.utility.DateUtil;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;
import com.td.utility.ExceptionUtil;

public class MonitorTimeActivity extends BaseActivity {
	private EditPrefUtil pref = new EditPrefUtil(this);
	private CheckBox[] checkBoxes = new CheckBox[DateUtil.WEEK];

	private MonitorDao dao;
	private List<Monitor> list = new ArrayList<Monitor>();
	private Monitor curMonitor = null;

	private View mode = null;
	private ListView listView;
	private ScrollView scrollView;
	private EditText editText1;
	private EditText editText2;
	private Button addButton;
	private Button updateButton;
	private Button deleteButton;
	private Button confButton;
	private Button cancelButton;
	private Button closeButton;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.monitor_time);

		try {
			listView = (ListView) findViewById(R.id.listView61);
			scrollView = (ScrollView) findViewById(R.id.scrollView61);
			editText1 = (EditText) findViewById(R.id.editText61);
			editText2 = (EditText) findViewById(R.id.editText62);
			addButton = (Button) findViewById(R.id.button61);
			updateButton = (Button) findViewById(R.id.button62);
			deleteButton = (Button) findViewById(R.id.button63);
			confButton = (Button) findViewById(R.id.button64);
			cancelButton = (Button) findViewById(R.id.button65);
			closeButton = (Button) findViewById(R.id.button66);
			CheckBox checkBox;
			for (int i = 0; i < DateUtil.WEEK; i++) {
				switch (i) {
				case 0:
					checkBox = (CheckBox) findViewById(R.id.checkBox61);
					break;
				case 1:
					checkBox = (CheckBox) findViewById(R.id.checkBox62);
					break;
				case 2:
					checkBox = (CheckBox) findViewById(R.id.checkBox63);
					break;
				case 3:
					checkBox = (CheckBox) findViewById(R.id.checkBox64);
					break;
				case 4:
					checkBox = (CheckBox) findViewById(R.id.checkBox65);
					break;
				case 5:
					checkBox = (CheckBox) findViewById(R.id.checkBox66);
					break;
				case 6:
					checkBox = (CheckBox) findViewById(R.id.checkBox67);
					break;
				default:
					checkBox = null;
					break;
				}
				checkBoxes[i] = checkBox;
				if (checkBox != null) {
					checkBox.setOnCheckedChangeListener(new OnCheckedChangeListener() {
						public void onCheckedChanged(CompoundButton view,
								boolean isChecked) {
							validation();
						}
					});
				}
			}

			editText1.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					String t = editText1.getText().toString();
					String strHour = DateUtil.getHour(t);
					String strMinute = DateUtil.getMinute(t);

					int hour = Integer.parseInt(strHour);
					int minute = Integer.parseInt(strMinute);
					TimePickerDialog timePickerDialog = new TimePickerDialog(
							MonitorTimeActivity.this,
							new TimePickerDialog.OnTimeSetListener() {
								public void onTimeSet(TimePicker view,
										int hourOfDay, int minute) {
									String s = DateUtil.formattedHm(DateUtil
											.getHm(hourOfDay, minute));
									editText1.setText(s);
									validation();
								}
							}, hour, minute, true);
					timePickerDialog.show();
				}
			});

			editText2.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					String t = editText2.getText().toString();
					String strHour = DateUtil.getHour(t);
					String strMinute = DateUtil.getMinute(t);

					int hour = Integer.parseInt(strHour);
					int minute = Integer.parseInt(strMinute);
					TimePickerDialog timePickerDialog = new TimePickerDialog(
							MonitorTimeActivity.this,
							new TimePickerDialog.OnTimeSetListener() {
								public void onTimeSet(TimePicker view,
										int hourOfDay, int minute) {
									String s = DateUtil.formattedHm(DateUtil
											.getHm(hourOfDay, minute));
									editText2.setText(s);
									validation();
								}
							}, hour, minute, true);
					timePickerDialog.show();
				}
			});

			dao = MonitorDao.getInstance();
			updateList();

			listView.setOnItemClickListener(new OnItemClickListener() {
				public void onItemClick(AdapterView<?> parent, View view,
						int position, long id) {
					selectedItemView(parent, view, position, id);
				}
			});
			listView.setOnItemSelectedListener(new OnItemSelectedListener() {
				public void onItemSelected(AdapterView<?> parent, View view,
						int position, long id) {
					selectedItemView(parent, view, position, id);
				}

				public void onNothingSelected(AdapterView<?> arg0) {
					;
				}
			});

			addButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickAddButton();
				}
			});

			updateButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickUpdateButton();
				}
			});

			deleteButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickDeleteButton();
				}
			});

			cancelButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickCancelButton();
				}
			});

			confButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					try {
						ExceptionUtil.getInstance().throwException(
								ExceptionUtil.TAG_E30);
						clickConfButton();
					}
					catch (Exception e){
						Debug.d(this, null, e);
						showDialog(this, e);
					}
				}
			});

			closeButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickCloseButton();
				}
			});
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	private void updateList() {
		list = dao.search();
		ArrayAdapter<Monitor> adapter = new ArrayAdapter<Monitor>(this,
				android.R.layout.simple_list_item_1, list);
		listView.setAdapter(adapter);
	}

	@Override
	protected void onStart() {
		super.onStart();

		try {
			setStatus(null);
		}
		catch (Exception e){
			Debug.d(this, null, e);
			showDialog(this, e);			
		}
	}

	private void selectedItemView(AdapterView<?> parent, View view,
			int position, long id) {
		curMonitor = list.get(position);
		// String text = curMonitor.getText();
		// editText.setText(text);
		setItems(curMonitor);

		setStatus(listView);
	}

	private void clickAddButton() {
		// editText.setText("");
		Monitor monitor = Monitor.getMonitor();
		setItems(monitor);

		curMonitor = null;
		setStatus(addButton);
		// changedEditText();
	}

	private void clickUpdateButton() {
		setStatus(updateButton);
		// changedEditText();
	}

	private void clickDeleteButton() {
		setStatus(deleteButton);
	}

	private void clickCancelButton() {
		curMonitor = null;
		setStatus(cancelButton);
	}

	private void clickConfButton() {
		Monitor monitor;
		long id;

		if (mode == addButton) {
			monitor = getMonitor(-1);
			dao.add(monitor);
			updateList();
		} else if (mode == updateButton) {
			if (curMonitor != null){
				monitor = getMonitor(curMonitor.getId());
				dao.set(monitor);
			}
			updateList();
		} else if (mode == deleteButton) {
			if (curMonitor != null){
				id = curMonitor.getId();
				dao.delete(id);
			}
			updateList();
		}
		curMonitor = null;
		setStatus(confButton);

		TrainDelayedServiceImpl.clearSchedule(this, pref);
	}

	private void clickCloseButton() {
		setStatus(closeButton);
		this.finish();
	}

	private void setStatus(View view) {
		mode = view;
		if (view == null) {
			listView.setEnabled(true);
			scrollView.setVisibility(View.GONE);
			setItemsEnabled(false);
			addButton.setVisibility(View.VISIBLE);
			addButton.setEnabled(true);
			updateButton.setVisibility(View.VISIBLE);
			updateButton.setEnabled(false);
			deleteButton.setVisibility(View.VISIBLE);
			deleteButton.setEnabled(false);
			confButton.setVisibility(View.GONE);
			confButton.setEnabled(true);
			cancelButton.setVisibility(View.GONE);
			closeButton.setVisibility(View.VISIBLE);
		} else if (view == listView) {
			scrollView.scrollTo(0, 0);
			scrollView.setVisibility(View.VISIBLE);
			setItemsEnabled(false);
			addButton.setEnabled(false);
			updateButton.setEnabled(true);
			deleteButton.setEnabled(true);
			cancelButton.setVisibility(View.VISIBLE);
			closeButton.setVisibility(View.GONE);
		} else if (view == addButton) {
			listView.setEnabled(false);
			scrollView.scrollTo(0, 0);
			scrollView.setVisibility(View.VISIBLE);
			setItemsEnabled(true);
			addButton.setVisibility(View.GONE);
			updateButton.setVisibility(View.GONE);
			deleteButton.setVisibility(View.GONE);
			confButton.setVisibility(View.VISIBLE);
			cancelButton.setVisibility(View.VISIBLE);
			closeButton.setVisibility(View.GONE);
			validation();
		} else if (view == updateButton) {
			setItemsEnabled(true);
			listView.setEnabled(false);
			addButton.setVisibility(View.GONE);
			updateButton.setVisibility(View.GONE);
			deleteButton.setVisibility(View.GONE);
			confButton.setVisibility(View.VISIBLE);
			cancelButton.setVisibility(View.VISIBLE);
			closeButton.setVisibility(View.GONE);
			validation();
		} else if (view == deleteButton) {
			listView.setEnabled(false);
			addButton.setVisibility(View.GONE);
			updateButton.setVisibility(View.GONE);
			deleteButton.setVisibility(View.GONE);
			confButton.setVisibility(View.VISIBLE);
			cancelButton.setVisibility(View.VISIBLE);
			closeButton.setVisibility(View.GONE);
		} else if (view == confButton) {
			setStatus(null);
		} else if (view == cancelButton) {
			setStatus(null);
		} else if (view == closeButton) {
			setStatus(null);
		}
	}

	private void setItemsEnabled(boolean enabled) {
		// listView.setEnabled(enabled);
		scrollView.setEnabled(enabled);
		editText1.setEnabled(enabled);
		editText2.setEnabled(enabled);
		for (int i = 0; i < DateUtil.WEEK; i++) {
			checkBoxes[i].setEnabled(enabled);
		}
	}

	private void setItems(Monitor monitor) {
		int from = monitor.getFrom();
		int to = monitor.getTo();

		editText1.setText(DateUtil.formattedHm(from));
		editText2.setText(DateUtil.formattedHm(to));
		for (int i = 0; i < DateUtil.WEEK; i++) {
			checkBoxes[i].setChecked(monitor.getWeek(i));
		}
	}

	private Monitor getMonitor(long id) {
		String t1 = editText1.getText().toString();
		int h1 = Integer.parseInt(DateUtil.getHour(t1));
		int m1 = Integer.parseInt(DateUtil.getMinute(t1));

		String t2 = editText2.getText().toString();
		int h2 = Integer.parseInt(DateUtil.getHour(t2));
		int m2 = Integer.parseInt(DateUtil.getMinute(t2));

		int hm1 = DateUtil.getHm(h1, m1);
		int hm2 = DateUtil.getHm(h2, m2);

		Monitor monitor = new Monitor(id, hm1, hm2);
		for (int i = 0; i < DateUtil.WEEK; i++) {
			monitor.setWeek(i, checkBoxes[i].isChecked());
		}
		return monitor;
	}

	private void validation() {
		String t1 = editText1.getText().toString();
		String t2 = editText2.getText().toString();

		if (t1 == null || t1.length() == 0){
			return;
		}
		if (t2 == null || t2.length() == 0){
			return;
		}

		int h1 = Integer.parseInt(DateUtil.getHour(t1));
		int m1 = Integer.parseInt(DateUtil.getMinute(t1));

		int h2 = Integer.parseInt(DateUtil.getHour(t2));
		int m2 = Integer.parseInt(DateUtil.getMinute(t2));

		int hm1 = DateUtil.getHm(h1, m1);
		int hm2 = DateUtil.getHm(h2, m2);

		boolean isChecked = false;
		for (int i = 0; i < DateUtil.WEEK; i++) {
			if (checkBoxes[i].isChecked()) {
				isChecked = true;
				break;
			}
		}

		if (mode == addButton || mode == updateButton) {
			if (hm1 <= hm2 && isChecked) {
				confButton.setEnabled(true);
			} else {
				confButton.setEnabled(false);
			}
		}
	}
}
