package com.td;

import com.td.db.SQLiteOpenHelperImpl;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;

public class HistoryContentProvider extends ContentProvider {
	private static final String UNKNOWN_URI = "Unknown URI ";

	public class Fields {
		public static final String ID = android.provider.BaseColumns._ID;
		public static final String ROUTE_ID = "ROUTE_ID";
		public static final String YMD = "YMD";
		public static final String HM = "HM";
		public static final String WEEK = "WEEK";
		public static final String PERIOD = "PERIOD";
		public static final String NUM = "NUM";
		public static final String STATUS = "STATUS";
	}

	public static class Projection {
		public static final String[] projection = { Fields.ID, Fields.ROUTE_ID,
				Fields.YMD, Fields.HM, Fields.WEEK, Fields.PERIOD, Fields.NUM,
				Fields.STATUS };
	}

	public static final String AUTHORITY = "com.td.history";
	public static final Uri CONTENT_URI = Uri.parse("content://" + AUTHORITY
			+ "/" + "numbers");

	private static final int CODE_NUMBERS = 1;
	private static final int CODE_NUMBER = 2;
	private static final String HISTORY_TABLE = "history";

	/** fBNgMIME^Cv */
	private static final String CONTENT_TYPE = "vnd.android.cursor.dir/com.td.history";

	/** PMIME^Cv */
	private static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/com.td.history";

	private UriMatcher uriMatcher;
	private SQLiteOpenHelperImpl sqlSupport;

	@Override
	public boolean onCreate() {
		uriMatcher = new UriMatcher(UriMatcher.NO_MATCH);
		uriMatcher.addURI(AUTHORITY, "numbers", CODE_NUMBERS);
		uriMatcher.addURI(AUTHORITY, "numbers/#", CODE_NUMBER);
		sqlSupport = new SQLiteOpenHelperImpl(getContext());
		return true;
	}

	@Override
	public String getType(Uri uri) {
		switch (uriMatcher.match(uri)) {
		case CODE_NUMBERS:
			return CONTENT_TYPE;
		case CODE_NUMBER:
			return CONTENT_ITEM_TYPE;
		default:
			throw new IllegalArgumentException(UNKNOWN_URI + uri);
		}
	}

	@Override
	public int delete(Uri uri, String selection, String[] selectionArgs) {
		final SQLiteDatabase db = sqlSupport.getWritableDatabase();
		final int deleteCount;
		switch (uriMatcher.match(uri)) {
		case CODE_NUMBERS:
			deleteCount = db.delete(HISTORY_TABLE, selection, selectionArgs);
			break;
		case CODE_NUMBER:
			final long id = Long.parseLong(uri.getPathSegments().get(1));
			final String idPlusSelection = android.provider.BaseColumns._ID
					+ "=" + Long.toString(id)
					+ (selection == null ? "" : "AND (" + selection + ")");
			deleteCount = db.delete(HISTORY_TABLE, idPlusSelection,
					selectionArgs);
			break;
		default:
			throw new IllegalArgumentException(UNKNOWN_URI + uri);
		}

		return deleteCount;
	}

	@Override
	public Uri insert(Uri uri, ContentValues values) {
		final SQLiteDatabase db = sqlSupport.getWritableDatabase();
		if (uriMatcher.match(uri) != CODE_NUMBERS) {
			throw new IllegalArgumentException(UNKNOWN_URI + uri);
		}

		final long id = db.insertOrThrow(HISTORY_TABLE, null, values);

		// ύXʒm
		final Uri newUri = ContentUris.withAppendedId(CONTENT_URI, id);
		getContext().getContentResolver().notifyChange(newUri, null);

		return newUri;
	}

	@Override
	public Cursor query(Uri uri, String[] projection, String selection,
			String[] selectionArgs, String sortOrder) {
		if (uriMatcher.match(uri) == CODE_NUMBER) {
			final long id = Long.parseLong(uri.getPathSegments().get(1));
			selection = android.provider.BaseColumns._ID + "="
					+ Long.toString(id)
					+ (selection == null ? "" : "AND (" + selection + ")");
		}
		final SQLiteDatabase db = sqlSupport.getWritableDatabase();
		Cursor cursor = db.query(HISTORY_TABLE, projection, selection,
				selectionArgs, null, null, sortOrder);

		cursor.setNotificationUri(getContext().getContentResolver(), uri);

		return cursor;
	}

	@Override
	public int update(Uri uri, ContentValues values, String selection,
			String[] selectionArgs) {
		final SQLiteDatabase db = sqlSupport.getWritableDatabase();
		final int updateCount;
		switch (uriMatcher.match(uri)) {
		case CODE_NUMBERS:
			updateCount = db.update(HISTORY_TABLE, values, selection,
					selectionArgs);
			break;
		case CODE_NUMBER:
			final long id = Long.parseLong(uri.getPathSegments().get(1));
			final String idPlusSelection = android.provider.BaseColumns._ID
					+ "=" + Long.toString(id)
					+ (selection == null ? "" : "AND (" + selection + ")");
			updateCount = db.update(HISTORY_TABLE, values, idPlusSelection,
					selectionArgs);
			break;
		default:
			throw new IllegalArgumentException(UNKNOWN_URI + uri);
		}

		// ύXʒm
		getContext().getContentResolver().notifyChange(uri, null);

		return updateCount;
	}
}
