/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import twitter4j.TwitterException;
import twitter4j.conf.ConfigurationContext;
import twitter4j.internal.http.HttpClientConfiguration;
import twitter4j.internal.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpResponse {
    private static final Logger logger = Logger.getLogger(class$twitter4j$internal$http$HttpResponseImpl == null ? (class$twitter4j$internal$http$HttpResponseImpl = HttpResponse.class$("twitter4j.internal.http.HttpResponseImpl")) : class$twitter4j$internal$http$HttpResponseImpl);
    protected final HttpClientConfiguration CONF;
    protected int statusCode;
    protected String responseAsString = null;
    protected InputStream is;
    private boolean streamConsumed = false;
    private JSONObject json = null;
    static /* synthetic */ Class class$twitter4j$internal$http$HttpResponseImpl;

    HttpResponse() {
        this.CONF = ConfigurationContext.getInstance();
    }

    public HttpResponse(HttpClientConfiguration conf) {
        this.CONF = conf;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public abstract String getResponseHeader(String var1);

    public abstract Map<String, List<String>> getResponseHeaderFields();

    public final InputStream asStream() {
        if (this.streamConsumed) {
            throw new IllegalStateException("Stream has already been consumed.");
        }
        return this.is;
    }

    public final String asString() throws TwitterException {
        if (null == this.responseAsString) {
            BufferedReader br = null;
            InputStream stream = null;
            try {
                String line;
                stream = this.asStream();
                if (null == stream) {
                    String string = null;
                    return string;
                }
                br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                StringBuffer buf = new StringBuffer();
                while (null != (line = br.readLine())) {
                    buf.append(line).append("\n");
                }
                this.responseAsString = buf.toString();
                logger.debug(this.responseAsString);
                stream.close();
                this.streamConsumed = true;
            }
            catch (IOException ioe) {
                throw new TwitterException(ioe.getMessage(), ioe);
            }
            finally {
                if (null != stream) {
                    try {
                        stream.close();
                    }
                    catch (IOException ignore) {}
                }
                if (null != br) {
                    try {
                        br.close();
                    }
                    catch (IOException ignore) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.responseAsString;
    }

    public final JSONObject asJSONObject() throws TwitterException {
        if (null == this.json) {
            InputStreamReader reader = null;
            try {
                if (logger.isDebugEnabled()) {
                    if (this.CONF.isPrettyDebugEnabled()) {
                        this.json = new JSONObject(this.asString());
                        logger.debug(this.json.toString(1));
                    } else {
                        this.json = new JSONObject(this.asString());
                    }
                } else {
                    this.json = new JSONObject(this.asString());
                }
            }
            catch (JSONException jsone) {
                if (logger.isDebugEnabled()) {
                    throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(this.responseAsString).toString(), jsone);
                }
                throw new TwitterException(jsone.getMessage(), jsone);
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.json;
    }

    public final JSONArray asJSONArray() throws TwitterException {
        JSONArray json = null;
        InputStreamReader reader = null;
        try {
            if (logger.isDebugEnabled()) {
                if (this.CONF.isPrettyDebugEnabled()) {
                    json = new JSONArray(this.asString());
                    logger.debug(json.toString(1));
                } else {
                    json = new JSONArray(this.asString());
                }
            } else {
                json = new JSONArray(this.asString());
            }
        }
        catch (JSONException jsone) {
            if (logger.isDebugEnabled()) {
                throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(this.responseAsString).toString(), jsone);
            }
            throw new TwitterException(jsone.getMessage(), jsone);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
            this.disconnectForcibly();
        }
        return json;
    }

    public final InputStreamReader asReader() {
        try {
            return new InputStreamReader(this.is, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new InputStreamReader(this.is);
        }
    }

    private void disconnectForcibly() {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void disconnect() throws IOException;

    public String toString() {
        return new StringBuffer().append("HttpResponse{statusCode=").append(this.statusCode).append(", responseAsString='").append(this.responseAsString).append('\'').append(", is=").append(this.is).append(", streamConsumed=").append(this.streamConsumed).append('}').toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

