/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import org.json.JSONObject;
import twitter4j.AccountTotals;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.util.ParseUtil;

class AccountTotalsJSONImpl
extends TwitterResponseImpl
implements AccountTotals,
Serializable {
    private static final long serialVersionUID = -2291419345865627123L;
    private final int updates;
    private final int followers;
    private final int favorites;
    private final int friends;

    private AccountTotalsJSONImpl(HttpResponse res, JSONObject json) {
        super(res);
        this.updates = ParseUtil.getInt("updates", json);
        this.followers = ParseUtil.getInt("followers", json);
        this.favorites = ParseUtil.getInt("favorites", json);
        this.friends = ParseUtil.getInt("friends", json);
    }

    AccountTotalsJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        this(res, res.asJSONObject());
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, res.asJSONObject());
        }
    }

    AccountTotalsJSONImpl(JSONObject json) throws TwitterException {
        this(null, json);
    }

    public int getUpdates() {
        return this.updates;
    }

    public int getFollowers() {
        return this.followers;
    }

    public int getFavorites() {
        return this.favorites;
    }

    public int getFriends() {
        return this.friends;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountTotalsJSONImpl that = (AccountTotalsJSONImpl)o;
        if (this.favorites != that.favorites) {
            return false;
        }
        if (this.followers != that.followers) {
            return false;
        }
        if (this.friends != that.friends) {
            return false;
        }
        return this.updates == that.updates;
    }

    public int hashCode() {
        int result = this.updates;
        result = 31 * result + this.followers;
        result = 31 * result + this.favorites;
        result = 31 * result + this.friends;
        return result;
    }

    public String toString() {
        return "AccountTotalsJSONImpl{updates=" + this.updates + ", followers=" + this.followers + ", favorites=" + this.favorites + ", friends=" + this.friends + '}';
    }
}

