/*
 * Decompiled with CFR 0.152.
 */
package org.afree.graphics.geom;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;

public class QuadCurveShape
implements Shape {
    private float mX1;
    private float mY1;
    private float mX2;
    private float mY2;
    private float mCtrlx;
    private float mCtrly;
    private Path mPath;
    private Region mRegion;
    private RectF rectBuffer = new RectF();

    public QuadCurveShape() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public QuadCurveShape(float x1, float y1, float ctrlx, float ctrly, float x2, float y2) {
        this.mX1 = x1;
        this.mY1 = y1;
        this.mCtrlx = ctrlx;
        this.mCtrly = ctrly;
        this.mX2 = x2;
        this.mY2 = y2;
        this.mPath = new Path();
        this.update();
    }

    public QuadCurveShape(QuadCurveShape curve) {
        this.mX1 = curve.mX1;
        this.mY1 = curve.mY1;
        this.mCtrlx = curve.mCtrlx;
        this.mCtrly = curve.mCtrly;
        this.mX2 = curve.mX2;
        this.mY2 = curve.mY2;
        this.mPath = curve.mPath;
    }

    public void clip(Canvas canvas) {
    }

    public boolean contains(float x, float y) {
        return false;
    }

    public boolean contains(float x, float y, float width, float height) {
        return false;
    }

    public boolean contains(PointF point) {
        return false;
    }

    public boolean contains(RectShape rect) {
        return false;
    }

    public void draw(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawPath(this.mPath, paint);
    }

    public void fill(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.mPath, paint);
    }

    public void fillAndStroke(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        canvas.drawPath(this.mPath, paint);
    }

    @Deprecated
    public RectShape getBounds() {
        return new RectShape(this.rectBuffer);
    }

    public void getBounds(RectShape rect) {
        rect.setRectF(this.rectBuffer);
    }

    public Path getPath() {
        return this.mPath;
    }

    public boolean intersects(float x, float y, float width, float height) {
        float tmph;
        float tmpy;
        float tmpw;
        float tmpx;
        Region region = new Region(this.mRegion);
        if (x < width + x) {
            tmpx = x;
            tmpw = width;
        } else {
            tmpx = width + x;
            tmpw = Math.abs(width);
        }
        if (y < height + y) {
            tmpy = y;
            tmph = height;
        } else {
            tmpy = height + y;
            tmph = Math.abs(height);
        }
        region.getBounds();
        return region.op((int)tmpx, (int)tmpy, (int)(tmpx + tmpw), (int)(tmpy + tmph), Region.Op.INTERSECT);
    }

    public boolean intersects(Rect rect) {
        return this.intersects(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public boolean intersects(RectShape rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void translate(float x, float y) {
        this.mX1 += x;
        this.mY1 += y;
        this.mCtrlx += x;
        this.mCtrly += y;
        this.mX2 += x;
        this.mY2 += y;
        this.update();
    }

    public void setCurve(float x1, float y1, float ctrlx, float ctrly, float x2, float y2) {
        this.mX1 = x1;
        this.mY1 = y1;
        this.mCtrlx = ctrlx;
        this.mCtrly = ctrly;
        this.mX2 = x2;
        this.mY2 = y2;
        this.update();
    }

    public void setCurve(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        this.mX1 = (float)x1;
        this.mY1 = (float)y1;
        this.mCtrlx = (float)ctrlx;
        this.mCtrly = (float)ctrly;
        this.mX2 = (float)x2;
        this.mY2 = (float)y2;
        this.update();
    }

    private void update() {
        this.mPath.reset();
        this.mPath.moveTo(this.mX1, this.mY1);
        this.mPath.quadTo(this.mCtrlx, this.mCtrly, this.mX2, this.mY2);
        this.mPath.computeBounds(this.rectBuffer, false);
        this.mRegion = new Region((int)this.rectBuffer.left, (int)this.rectBuffer.top, (int)this.rectBuffer.right, (int)this.rectBuffer.bottom);
        this.mPath.lineTo(this.mX2 + 1.0f, this.mY2);
        this.mPath.quadTo(this.mCtrlx + 1.0f, this.mCtrly, this.mX1 + 1.0f, this.mY1);
        this.mPath.close();
        this.mRegion.setPath(this.mPath, this.mRegion);
    }

    public boolean equals(Object o) {
        if (o instanceof QuadCurveShape) {
            QuadCurveShape quadCurveShape = (QuadCurveShape)o;
            if (this.mX1 == quadCurveShape.mX1 && this.mY1 == quadCurveShape.mY1 && this.mX2 == quadCurveShape.mX2 && this.mY2 == quadCurveShape.mY2 && this.mCtrlx == quadCurveShape.mCtrlx && this.mCtrly == quadCurveShape.mCtrly) {
                return true;
            }
        }
        return false;
    }

    public Shape clone() {
        return new QuadCurveShape(this);
    }
}

