/*
 * Decompiled with CFR 0.152.
 */
package org.afree.data.time.ohlc;

import java.util.Collections;
import org.afree.data.ComparableObjectItem;
import org.afree.data.ComparableObjectSeries;
import org.afree.data.time.RegularTimePeriod;
import org.afree.data.time.ohlc.OHLCItem;

public class OHLCSeries
extends ComparableObjectSeries {
    private static final long serialVersionUID = 1019559560481915160L;

    public OHLCSeries(Comparable key) {
        super(key, true, false);
    }

    public RegularTimePeriod getPeriod(int index) {
        OHLCItem item = (OHLCItem)this.getDataItem(index);
        return item.getPeriod();
    }

    public ComparableObjectItem getDataItem(int index) {
        return super.getDataItem(index);
    }

    public void add(RegularTimePeriod period, double open, double high, double low, double close) {
        if (this.getItemCount() > 0) {
            OHLCItem item0 = (OHLCItem)this.getDataItem(0);
            if (!period.getClass().equals(item0.getPeriod().getClass())) {
                throw new IllegalArgumentException("Can't mix RegularTimePeriod class types.");
            }
        }
        super.add(new OHLCItem(period, open, high, low, close), true);
    }

    public int getIndex(RegularTimePeriod period) {
        if (period == null) {
            throw new IllegalArgumentException("Null 'period' argument.");
        }
        OHLCItem dummy = new OHLCItem(period, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
        return Collections.binarySearch(this.data, dummy);
    }
}

