/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.text;

import android.graphics.Canvas;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.afree.chart.text.TextFragment;
import org.afree.graphics.PaintType;
import org.afree.graphics.geom.Font;
import org.afree.ui.Size2D;
import org.afree.ui.TextAnchor;

public class TextLine
implements Serializable {
    private static final long serialVersionUID = -3649650025605980613L;
    private List fragments;

    public TextLine() {
        this.fragments = new ArrayList();
    }

    public TextLine(String text) {
        this(text, TextFragment.DEFAULT_FONT);
    }

    public TextLine(String text, Font font) {
        this.fragments = new ArrayList();
        TextFragment fragment = new TextFragment(text, font);
        this.fragments.add(fragment);
    }

    public TextLine(String text, Font font, PaintType paintType) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.fragments = new ArrayList();
        TextFragment fragment = new TextFragment(text, font, paintType);
        this.fragments.add(fragment);
    }

    public void addFragment(TextFragment fragment) {
        this.fragments.add(fragment);
    }

    public void draw(Canvas canvas, float anchorX, float anchorY, TextAnchor anchor, float rotateX, float rotateY, double angle) {
        float x = anchorX;
        float yOffset = this.calculateBaselineOffset(anchor);
        for (TextFragment fragment : this.fragments) {
            Size2D d = fragment.calculateDimensions(canvas);
            fragment.draw(canvas, x, anchorY + yOffset, TextAnchor.BASELINE_LEFT, rotateX, rotateY, angle);
            x += (float)d.getWidth();
        }
    }

    public Size2D calculateDimensions(Canvas canvas) {
        double width = 0.0;
        double height = 0.0;
        for (TextFragment fragment : this.fragments) {
            Size2D dimension = fragment.calculateDimensions(canvas);
            width += dimension.getWidth();
            height = Math.max(height, dimension.getHeight());
        }
        return new Size2D(width, height);
    }

    public TextFragment getFirstTextFragment() {
        TextFragment result = null;
        if (this.fragments.size() > 0) {
            result = (TextFragment)this.fragments.get(0);
        }
        return result;
    }

    private float calculateBaselineOffset(TextAnchor anchor) {
        float result = 0.0f;
        TextFragment fragment = this.getFirstTextFragment();
        if (fragment != null) {
            result = fragment.calculateBaselineOffset(anchor);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TextLine) {
            TextLine line = (TextLine)obj;
            return this.fragments.equals(line.fragments);
        }
        return false;
    }
}

