/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.category;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.afree.chart.LegendItem;
import org.afree.chart.axis.CategoryAxis;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.event.RendererChangeListener;
import org.afree.chart.plot.CategoryPlot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.afree.chart.renderer.category.CategoryItemRendererState;
import org.afree.data.category.CategoryDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.util.BooleanList;
import org.afree.util.BooleanUtilities;
import org.afree.util.ShapeUtilities;

public class LineAndShapeRenderer
extends AbstractCategoryItemRenderer
implements Cloneable {
    private static final long serialVersionUID = -197749519869226398L;
    private Boolean linesVisible = null;
    private BooleanList seriesLinesVisible = new BooleanList();
    private boolean baseLinesVisible;
    private Boolean shapesVisible;
    private BooleanList seriesShapesVisible;
    private boolean baseShapesVisible;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private boolean baseShapesFilled;
    private boolean useFillPaint;
    private boolean drawOutlines;
    private boolean useOutlinePaintType;
    private boolean useSeriesOffset;
    private double itemMargin;

    public LineAndShapeRenderer() {
        this(true, true);
    }

    public LineAndShapeRenderer(boolean lines, boolean shapes) {
        this.baseLinesVisible = lines;
        this.shapesVisible = null;
        this.seriesShapesVisible = new BooleanList();
        this.baseShapesVisible = shapes;
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.baseShapesFilled = true;
        this.useFillPaint = false;
        this.drawOutlines = true;
        this.useOutlinePaintType = false;
        this.useSeriesOffset = false;
        this.itemMargin = 0.0;
    }

    public boolean getItemLineVisible(int series, int item) {
        Boolean flag = this.linesVisible;
        if (flag == null) {
            flag = this.getSeriesLinesVisible(series);
        }
        if (flag != null) {
            return flag;
        }
        return this.baseLinesVisible;
    }

    public void setLinesVisible(Boolean visible) {
        this.linesVisible = visible;
    }

    public void setLinesVisible(boolean visible) {
        this.setLinesVisible(BooleanUtilities.valueOf(visible));
    }

    public Boolean getSeriesLinesVisible(int series) {
        return this.seriesLinesVisible.getBoolean(series);
    }

    public void setSeriesLinesVisible(int series, Boolean flag) {
        this.seriesLinesVisible.setBoolean(series, flag);
    }

    public void setSeriesLinesVisible(int series, boolean visible) {
        this.setSeriesLinesVisible(series, BooleanUtilities.valueOf(visible));
    }

    public boolean getBaseLinesVisible() {
        return this.baseLinesVisible;
    }

    public void setBaseLinesVisible(boolean flag) {
        this.baseLinesVisible = flag;
    }

    public boolean getItemShapeVisible(int series, int item) {
        Boolean flag = this.shapesVisible;
        if (flag == null) {
            flag = this.getSeriesShapesVisible(series);
        }
        if (flag != null) {
            return flag;
        }
        return this.baseShapesVisible;
    }

    public void setShapesVisible(Boolean visible) {
        this.shapesVisible = visible;
    }

    public void setShapesVisible(boolean visible) {
        this.setShapesVisible(BooleanUtilities.valueOf(visible));
    }

    public Boolean getSeriesShapesVisible(int series) {
        return this.seriesShapesVisible.getBoolean(series);
    }

    public void setSeriesShapesVisible(int series, boolean visible) {
        this.setSeriesShapesVisible(series, BooleanUtilities.valueOf(visible));
    }

    public void setSeriesShapesVisible(int series, Boolean flag) {
        this.seriesShapesVisible.setBoolean(series, flag);
    }

    public boolean getBaseShapesVisible() {
        return this.baseShapesVisible;
    }

    public void setBaseShapesVisible(boolean flag) {
        this.baseShapesVisible = flag;
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean flag) {
        this.drawOutlines = flag;
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaintType;
    }

    public void setUseOutlinePaint(boolean use) {
        this.useOutlinePaintType = use;
    }

    public boolean getItemShapeFilled(int series, int item) {
        return this.getSeriesShapesFilled(series);
    }

    public boolean getSeriesShapesFilled(int series) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean flag = this.seriesShapesFilled.getBoolean(series);
        if (flag != null) {
            return flag;
        }
        return this.baseShapesFilled;
    }

    public Boolean getShapesFilled() {
        return this.shapesFilled;
    }

    public void setShapesFilled(boolean filled) {
        if (filled) {
            this.setShapesFilled(Boolean.TRUE);
        } else {
            this.setShapesFilled(Boolean.FALSE);
        }
    }

    public void setShapesFilled(Boolean filled) {
        this.shapesFilled = filled;
    }

    public void setSeriesShapesFilled(int series, Boolean filled) {
        this.seriesShapesFilled.setBoolean(series, filled);
    }

    public void setSeriesShapesFilled(int series, boolean filled) {
        this.setSeriesShapesFilled(series, BooleanUtilities.valueOf(filled));
    }

    public boolean getBaseShapesFilled() {
        return this.baseShapesFilled;
    }

    public void setBaseShapesFilled(boolean flag) {
        this.baseShapesFilled = flag;
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean flag) {
        this.useFillPaint = flag;
    }

    public boolean getUseSeriesOffset() {
        return this.useSeriesOffset;
    }

    public void setUseSeriesOffset(boolean offset) {
        this.useSeriesOffset = offset;
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double margin) {
        if (margin < 0.0 || margin >= 1.0) {
            throw new IllegalArgumentException("Requires 0.0 <= margin < 1.0.");
        }
        this.itemMargin = margin;
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        CategoryPlot cp = this.getPlot();
        if (cp == null) {
            return null;
        }
        if (this.isSeriesVisible(series) && this.isSeriesVisibleInLegend(series)) {
            String label;
            CategoryDataset dataset = cp.getDataset(datasetIndex);
            String description = label = this.getLegendItemLabelGenerator().generateLabel(dataset, series);
            Shape shape = this.lookupLegendShape(series);
            PaintType paintType = this.lookupSeriesPaintType(series);
            PaintType fillPaintType = this.useFillPaint ? this.getItemFillPaintType(series, 0) : paintType;
            boolean shapeOutlineVisible = this.drawOutlines;
            PaintType outlinePaintType = this.useOutlinePaintType ? this.getItemOutlinePaintType(series, 0) : paintType;
            Float outlineStroke = this.lookupSeriesOutlineStroke(series);
            boolean lineVisible = this.getItemLineVisible(series, 0);
            boolean shapeVisible = this.getItemShapeVisible(series, 0);
            LegendItem result = new LegendItem(label, description, "", "", shapeVisible, shape, this.getItemShapeFilled(series, 0), fillPaintType, shapeOutlineVisible, outlinePaintType, outlineStroke.floatValue(), lineVisible, (Shape)new LineShape(-7.0, 0.0, 7.0, 0.0), this.getItemStroke(series, 0).floatValue(), this.getItemPaintType(series, 0));
            result.setLabelFont(this.lookupLegendTextFont(series));
            PaintType labelPaintType = this.lookupLegendTextPaintType(series);
            if (labelPaintType != null) {
                result.setLabelPaintType(labelPaintType);
            }
            result.setDataset(dataset);
            result.setDatasetIndex(datasetIndex);
            result.setSeriesKey(dataset.getRowKey(series));
            result.setSeriesIndex(series);
            return result;
        }
        return null;
    }

    public int getPassCount() {
        return 2;
    }

    public void drawItem(Canvas canvas, CategoryItemRendererState state, RectShape dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        Number previousValue;
        if (!this.getItemVisible(row, column)) {
            return;
        }
        if (!this.getItemLineVisible(row, column) && !this.getItemShapeVisible(row, column)) {
            return;
        }
        Number v = dataset.getValue(row, column);
        if (v == null) {
            return;
        }
        int visibleRow = state.getVisibleSeriesIndex(row);
        if (visibleRow < 0) {
            return;
        }
        int visibleRowCount = state.getVisibleSeriesCount();
        PlotOrientation orientation = plot.getOrientation();
        double x1 = this.useSeriesOffset ? domainAxis.getCategorySeriesMiddle(column, dataset.getColumnCount(), visibleRow, visibleRowCount, this.itemMargin, dataArea, plot.getDomainAxisEdge()) : domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double value = v.doubleValue();
        double y1 = rangeAxis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        if (pass == 0 && this.getItemLineVisible(row, column) && column != 0 && (previousValue = dataset.getValue(row, column - 1)) != null) {
            double previous = previousValue.doubleValue();
            double x0 = this.useSeriesOffset ? domainAxis.getCategorySeriesMiddle(column - 1, dataset.getColumnCount(), visibleRow, visibleRowCount, this.itemMargin, dataArea, plot.getDomainAxisEdge()) : domainAxis.getCategoryMiddle(column - 1, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
            double y0 = rangeAxis.valueToJava2D(previous, dataArea, plot.getRangeAxisEdge());
            LineShape line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new LineShape(y0, x0, y1, x1);
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new LineShape(x0, y0, x1, y1);
            }
            Paint paint = PaintUtility.createPaint(1, this.getItemPaintType(row, column), this.getItemStroke(row, column).floatValue(), this.getItemEffect(row, column));
            paint.setStrokeCap(Paint.Cap.ROUND);
            line.draw(canvas, paint);
        }
        if (pass == 1) {
            Shape shape = this.getItemShape(row, column);
            if (orientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, y1, x1);
            } else if (orientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, x1, y1);
            }
            if (this.getItemShapeVisible(row, column)) {
                Paint paint;
                if (this.getItemShapeFilled(row, column)) {
                    PaintType paintType = this.useFillPaint ? this.getItemFillPaintType(row, column) : this.getItemPaintType(row, column);
                    paint = PaintUtility.createPaint(1, paintType);
                    shape.fillAndStroke(canvas, paint);
                }
                if (this.drawOutlines) {
                    PaintType paintType = this.useOutlinePaintType ? this.getItemOutlinePaintType(row, column) : this.getItemPaintType(row, column);
                    paint = PaintUtility.createPaint(1, paintType);
                    shape.draw(canvas, paint);
                }
            }
            if (this.isItemLabelVisible(row, column)) {
                if (orientation == PlotOrientation.HORIZONTAL) {
                    this.drawItemLabel(canvas, orientation, dataset, row, column, y1, x1, value < 0.0);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    this.drawItemLabel(canvas, orientation, dataset, row, column, x1, y1, value < 0.0);
                }
            }
            int datasetIndex = plot.indexOf(dataset);
            this.updateCrosshairValues(state.getCrosshairState(), dataset.getRowKey(row), dataset.getColumnKey(column), value, datasetIndex, x1, y1, orientation);
            EntityCollection entities = state.getEntityCollection();
            if (entities != null) {
                this.addItemEntity(entities, dataset, row, column, shape);
            }
        }
    }

    public void addChangeListener(RendererChangeListener listener) {
    }

    public void removeChangeListener(RendererChangeListener listener) {
    }
}

