/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.drawable.BitmapDrawable;
import java.io.Serializable;
import org.afree.chart.LegendItemCollection;
import org.afree.chart.LegendItemSource;
import org.afree.chart.axis.AxisLocation;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.entity.PlotEntity;
import org.afree.chart.event.ChartChangeEventType;
import org.afree.chart.event.PlotChangeEvent;
import org.afree.chart.event.PlotChangeListener;
import org.afree.chart.plot.DefaultDrawingSupplier;
import org.afree.chart.plot.DrawingSupplier;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.PlotState;
import org.afree.chart.text.G2TextMeasurer;
import org.afree.chart.text.TextBlock;
import org.afree.chart.text.TextBlockAnchor;
import org.afree.chart.text.TextUtilities;
import org.afree.data.general.DatasetChangeEvent;
import org.afree.data.general.DatasetChangeListener;
import org.afree.data.general.DatasetGroup;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.OvalShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;
import org.afree.util.ObjectUtilities;

public abstract class Plot
implements LegendItemSource,
Cloneable,
Serializable,
DatasetChangeListener {
    private static final long serialVersionUID = -8831571430103671324L;
    public static final Number ZERO = new Integer(0);
    public static final RectangleInsets DEFAULT_INSETS = new RectangleInsets(4.0, 8.0, 4.0, 8.0);
    public static final float DEFAULT_OUTLINE_STROKE = 0.5f;
    public static final PathEffect DEFAULT_OUTLINE_EFFECT = null;
    public static final PaintType DEFAULT_OUTLINE_PAINT_TYPE = new SolidColor(-12303292);
    public static final int DEFAULT_FOREGROUND_ALPHA = 255;
    public static final int DEFAULT_BACKGROUND_ALPHA = 255;
    public static final PaintType DEFAULT_BACKGROUND_PAINT_TYPE = new SolidColor(-1);
    public static final int MINIMUM_WIDTH_TO_DRAW = 10;
    public static final int MINIMUM_HEIGHT_TO_DRAW = 10;
    public static final Shape DEFAULT_LEGEND_ITEM_BOX = new RectShape(-4.0, -4.0, 8.0, 8.0);
    public static final Shape DEFAULT_LEGEND_ITEM_CIRCLE = new OvalShape(-4.0, -4.0, 8.0, 8.0);
    private Plot parent = null;
    private DatasetGroup datasetGroup;
    private String noDataMessage = null;
    private Font noDataMessageFont;
    private transient PaintType noDataMessagePaintType;
    private RectangleInsets insets = DEFAULT_INSETS;
    private boolean outlineVisible = true;
    private transient float outlineStroke = 0.5f;
    private transient PathEffect outlineEffect = null;
    private transient PaintType outlinePaintType;
    private transient PaintType backgroundPaintType = DEFAULT_BACKGROUND_PAINT_TYPE;
    private int foregroundAlpha = 255;
    private int backgroundAlpha = 255;
    private DrawingSupplier drawingSupplier;
    private boolean notify;
    private BitmapDrawable backgroundImage;

    protected Plot() {
        this.outlinePaintType = DEFAULT_OUTLINE_PAINT_TYPE;
        this.noDataMessageFont = new Font("SansSerif", 0, 12);
        this.noDataMessagePaintType = new SolidColor(Color.argb((int)0, (int)255, (int)255, (int)255));
        this.drawingSupplier = new DefaultDrawingSupplier();
    }

    public DatasetGroup getDatasetGroup() {
        return this.datasetGroup;
    }

    protected void setDatasetGroup(DatasetGroup group) {
        this.datasetGroup = group;
    }

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public void setNoDataMessage(String message) {
        this.noDataMessage = message;
    }

    public Font getNoDataMessageFont() {
        return this.noDataMessageFont;
    }

    public void setNoDataMessageFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.noDataMessageFont = font;
    }

    public PaintType getNoDataMessagePaintType() {
        return this.noDataMessagePaintType;
    }

    public void setNoDataMessagePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.noDataMessagePaintType = paintType;
    }

    public abstract String getPlotType();

    public Plot getParent() {
        return this.parent;
    }

    public void setParent(Plot parent) {
        this.parent = parent;
    }

    public Plot getRootPlot() {
        Plot p = this.getParent();
        if (p == null) {
            return this;
        }
        return p.getRootPlot();
    }

    public boolean isSubplot() {
        return this.getParent() != null;
    }

    public RectangleInsets getInsets() {
        return this.insets;
    }

    public void setInsets(RectangleInsets insets) {
        this.setInsets(insets, true);
    }

    public void setInsets(RectangleInsets insets, boolean notify) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        if (!this.insets.equals(insets)) {
            this.insets = insets;
        }
    }

    public PaintType getBackgroundPaintType() {
        return this.backgroundPaintType;
    }

    public void setBackgroundPaintType(PaintType paintType) {
        if (paintType == null) {
            if (this.backgroundPaintType != null) {
                this.backgroundPaintType = null;
            }
        } else {
            if (this.backgroundPaintType != null && this.backgroundPaintType.equals(paintType)) {
                return;
            }
            this.backgroundPaintType = paintType;
        }
    }

    public int getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(int alpha) {
        if (this.backgroundAlpha != alpha) {
            this.backgroundAlpha = alpha;
        }
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        Plot p = this.getParent();
        result = p != null ? p.getDrawingSupplier() : this.drawingSupplier;
        return result;
    }

    public void setDrawingSupplier(DrawingSupplier supplier) {
        this.drawingSupplier = supplier;
    }

    public void setDrawingSupplier(DrawingSupplier supplier, boolean notify) {
        this.drawingSupplier = supplier;
    }

    public boolean isOutlineVisible() {
        return this.outlineVisible;
    }

    public void setOutlineVisible(boolean visible) {
        this.outlineVisible = visible;
    }

    public float getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(float stroke) {
        this.outlineStroke = stroke;
    }

    public PathEffect getOutlineEffect() {
        return this.outlineEffect;
    }

    public void setOutlineEffect(PathEffect effect) {
        this.outlineEffect = effect;
    }

    public PaintType getOutlinePaintType() {
        return this.outlinePaintType;
    }

    public void setOutlinePaintType(PaintType paintType) {
        if (paintType == null) {
            if (this.outlinePaintType != null) {
                this.outlinePaintType = null;
            }
        } else {
            if (this.outlinePaintType != null && this.outlinePaintType.equals(paintType)) {
                return;
            }
            this.outlinePaintType = paintType;
        }
    }

    public int getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(int alpha) {
        if (this.foregroundAlpha != alpha) {
            this.foregroundAlpha = alpha;
        }
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public abstract void draw(Canvas var1, RectShape var2, PointF var3, PlotState var4, PlotRenderingInfo var5);

    public void drawBackground(Canvas canvas, RectShape area) {
        this.fillBackground(canvas, area);
        this.drawBackgroundImage(canvas, area);
    }

    protected void fillBackground(Canvas canvas, RectShape area) {
        this.fillBackground(canvas, area, PlotOrientation.VERTICAL);
    }

    protected void fillBackground(Canvas canvas, RectShape area, PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (this.backgroundPaintType == null) {
            return;
        }
        Paint p = PaintUtility.createPaint(1, this.backgroundPaintType);
        area.fill(canvas, p);
    }

    public void drawBackgroundImage(Canvas canvas, RectShape area) {
        if (this.backgroundImage != null) {
            this.backgroundImage.setBounds((int)area.getMinX(), (int)area.getMinY(), (int)area.getMaxX(), (int)area.getMaxY());
            this.backgroundImage.setAlpha(this.getBackgroundAlpha());
            this.backgroundImage.draw(canvas);
        }
    }

    public void drawOutline(Canvas canvas, RectShape area) {
        if (!this.outlineVisible) {
            return;
        }
        if (this.outlinePaintType != null) {
            Paint paint = PaintUtility.createPaint(this.getOutlinePaintType(), this.getOutlineStroke(), this.getOutlineEffect());
            paint.setStyle(Paint.Style.STROKE);
            canvas.drawRect(area.getMinX(), area.getMinY(), area.getMaxX(), area.getMaxY(), paint);
        }
    }

    protected void drawNoDataMessage(Canvas canvas, RectShape area) {
        canvas.save();
        canvas.clipRect(area.getMinX(), area.getMinY(), area.getMaxX(), area.getMaxY());
        String message = this.noDataMessage;
        if (message != null) {
            Paint paint = PaintUtility.createPaint(1, this.noDataMessagePaintType, this.noDataMessageFont);
            TextBlock block = TextUtilities.createTextBlock(this.noDataMessage, this.noDataMessageFont, this.noDataMessagePaintType, 0.9f * area.getWidth(), new G2TextMeasurer(paint));
            block.draw(canvas, area.getCenterX(), area.getCenterY(), TextBlockAnchor.CENTER);
        }
        canvas.restore();
    }

    protected void createAndAddEntity(RectShape dataArea, PlotRenderingInfo plotState, String toolTip, String urlText) {
        EntityCollection e;
        if (plotState != null && plotState.getOwner() != null && (e = plotState.getOwner().getEntityCollection()) != null) {
            e.add(new PlotEntity(dataArea, this, toolTip, urlText));
        }
    }

    public void handleClick(int x, int y, PlotRenderingInfo info) {
    }

    public void zoom(double percent) {
    }

    protected double getRectX(double x, double w1, double w2, RectangleEdge edge) {
        double result = x;
        if (edge == RectangleEdge.LEFT) {
            result += w1;
        } else if (edge == RectangleEdge.RIGHT) {
            result += w2;
        }
        return result;
    }

    protected double getRectY(double y, double h1, double h2, RectangleEdge edge) {
        double result = y;
        if (edge == RectangleEdge.TOP) {
            result += h1;
        } else if (edge == RectangleEdge.BOTTOM) {
            result += h2;
        }
        return result;
    }

    public static RectangleEdge resolveDomainAxisLocation(AxisLocation location, PlotOrientation orientation) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        RectangleEdge result = null;
        if (location == AxisLocation.TOP_OR_RIGHT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.RIGHT;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.TOP;
            }
        } else if (location == AxisLocation.TOP_OR_LEFT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.LEFT;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.TOP;
            }
        } else if (location == AxisLocation.BOTTOM_OR_RIGHT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.RIGHT;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.BOTTOM;
            }
        } else if (location == AxisLocation.BOTTOM_OR_LEFT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.LEFT;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.BOTTOM;
            }
        }
        if (result == null) {
            throw new IllegalStateException("resolveDomainAxisLocation()");
        }
        return result;
    }

    public static RectangleEdge resolveRangeAxisLocation(AxisLocation location, PlotOrientation orientation) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        RectangleEdge result = null;
        if (location == AxisLocation.TOP_OR_RIGHT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.TOP;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.RIGHT;
            }
        } else if (location == AxisLocation.TOP_OR_LEFT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.TOP;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.LEFT;
            }
        } else if (location == AxisLocation.BOTTOM_OR_RIGHT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.BOTTOM;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.RIGHT;
            }
        } else if (location == AxisLocation.BOTTOM_OR_LEFT) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                result = RectangleEdge.BOTTOM;
            } else if (orientation == PlotOrientation.VERTICAL) {
                result = RectangleEdge.LEFT;
            }
        }
        if (result == null) {
            throw new IllegalStateException("resolveRangeAxisLocation()");
        }
        return result;
    }

    public void datasetChanged(DatasetChangeEvent event) {
        PlotChangeEvent newEvent = new PlotChangeEvent(this);
        newEvent.setType(ChartChangeEventType.DATASET_UPDATED);
        this.notifyListeners(newEvent);
    }

    public void notifyListeners(PlotChangeEvent event) {
        if (!this.notify) {
            return;
        }
    }

    public void addChangeListener(PlotChangeListener listener) {
    }

    public void removeChangeListener(PlotChangeListener listener) {
    }

    public void setBackgroundImage(BitmapDrawable image) {
        this.backgroundImage = image;
    }

    public Object clone() throws CloneNotSupportedException {
        Plot clone = (Plot)super.clone();
        if (this.datasetGroup != null) {
            clone.datasetGroup = (DatasetGroup)ObjectUtilities.clone(this.datasetGroup);
        }
        clone.drawingSupplier = (DrawingSupplier)ObjectUtilities.clone(this.drawingSupplier);
        return clone;
    }
}

