/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.block;

import android.graphics.Canvas;
import java.io.Serializable;
import java.util.List;
import org.afree.chart.block.Arrangement;
import org.afree.chart.block.Block;
import org.afree.chart.block.BlockContainer;
import org.afree.chart.block.LengthConstraintType;
import org.afree.chart.block.RectangleConstraint;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.Size2D;

public class CenterArrangement
implements Arrangement,
Serializable {
    private static final long serialVersionUID = -353308149220382047L;

    public void add(Block block, Object key) {
    }

    public Size2D arrange(BlockContainer container, Canvas canvas, RectangleConstraint constraint) {
        LengthConstraintType w = constraint.getWidthConstraintType();
        LengthConstraintType h = constraint.getHeightConstraintType();
        if (w == LengthConstraintType.NONE) {
            if (h == LengthConstraintType.NONE) {
                return this.arrangeNN(container, canvas);
            }
            if (h == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not implemented.");
            }
            if (h == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not implemented.");
            }
        } else if (w == LengthConstraintType.FIXED) {
            if (h == LengthConstraintType.NONE) {
                return this.arrangeFN(container, canvas, constraint);
            }
            if (h == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not implemented.");
            }
            if (h == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not implemented.");
            }
        } else if (w == LengthConstraintType.RANGE) {
            if (h == LengthConstraintType.NONE) {
                return this.arrangeRN(container, canvas, constraint);
            }
            if (h == LengthConstraintType.FIXED) {
                return this.arrangeRF(container, canvas, constraint);
            }
            if (h == LengthConstraintType.RANGE) {
                return this.arrangeRR(container, canvas, constraint);
            }
        }
        throw new IllegalArgumentException("Unknown LengthConstraintType.");
    }

    protected Size2D arrangeFN(BlockContainer container, Canvas canvas, RectangleConstraint constraint) {
        List blocks = container.getBlocks();
        Block b = (Block)blocks.get(0);
        Size2D s = b.arrange(canvas, RectangleConstraint.NONE);
        double width = constraint.getWidth();
        RectShape bounds = new RectShape((width - s.width) / 2.0, 0.0, s.width, s.height);
        b.setBounds(bounds);
        return new Size2D((width - s.width) / 2.0, s.height);
    }

    protected Size2D arrangeFR(BlockContainer container, Canvas canvas, RectangleConstraint constraint) {
        Size2D s = this.arrangeFN(container, canvas, constraint);
        if (constraint.getHeightRange().contains(s.height)) {
            return s;
        }
        RectangleConstraint c = constraint.toFixedHeight(constraint.getHeightRange().constrain(s.getHeight()));
        return this.arrangeFF(container, canvas, c);
    }

    protected Size2D arrangeFF(BlockContainer container, Canvas canvas, RectangleConstraint constraint) {
        return this.arrangeFN(container, canvas, constraint);
    }

    protected Size2D arrangeRR(BlockContainer container, Canvas canvas, RectangleConstraint constraint) {
        Size2D s1 = this.arrangeNN(container, canvas);
        if (constraint.getWidthRange().contains(s1.width)) {
            return s1;
        }
        RectangleConstraint c = constraint.toFixedWidth(constraint.getWidthRange().getUpperBound());
        return this.arrangeFR(container, canvas, c);
    }

    protected Size2D arrangeRF(BlockContainer container, Canvas canvas, RectangleConstraint constraint) {
        Size2D s = this.arrangeNF(container, canvas, constraint);
        if (constraint.getWidthRange().contains(s.width)) {
            return s;
        }
        RectangleConstraint c = constraint.toFixedWidth(constraint.getWidthRange().constrain(s.getWidth()));
        return this.arrangeFF(container, canvas, c);
    }

    protected Size2D arrangeRN(BlockContainer container, Canvas canvas, RectangleConstraint constraint) {
        Size2D s1 = this.arrangeNN(container, canvas);
        if (constraint.getWidthRange().contains(s1.width)) {
            return s1;
        }
        RectangleConstraint c = constraint.toFixedWidth(constraint.getWidthRange().getUpperBound());
        return this.arrangeFN(container, canvas, c);
    }

    protected Size2D arrangeNN(BlockContainer container, Canvas canvas) {
        List blocks = container.getBlocks();
        Block b = (Block)blocks.get(0);
        Size2D s = b.arrange(canvas, RectangleConstraint.NONE);
        b.setBounds(new RectShape(0.0, 0.0, s.width, s.height));
        return new Size2D(s.width, s.height);
    }

    protected Size2D arrangeNF(BlockContainer container, Canvas canvas, RectangleConstraint constraint) {
        return this.arrangeNN(container, canvas);
    }

    public void clear() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof CenterArrangement;
    }
}

