/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.block;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import java.io.Serializable;
import org.afree.chart.block.BlockFrame;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleInsets;

public class BlockBorder
implements BlockFrame,
Serializable {
    private static final long serialVersionUID = 4961579220410228283L;
    public static final PaintType white = new SolidColor(Color.argb((int)255, (int)256, (int)256, (int)256));
    public static final PaintType black = new SolidColor(Color.argb((int)255, (int)0, (int)0, (int)0));
    public static final BlockBorder NONE = new BlockBorder(RectangleInsets.ZERO_INSETS, white);
    private RectangleInsets insets;
    private transient PaintType paintType;

    public BlockBorder() {
        this(black);
    }

    public BlockBorder(PaintType paintType) {
        this(new RectangleInsets(1.0, 1.0, 1.0, 1.0), paintType);
    }

    public BlockBorder(double top, double left, double bottom, double right) {
        this(new RectangleInsets(top, left, bottom, right), black);
    }

    public BlockBorder(double top, double left, double bottom, double right, PaintType paintType) {
        this(new RectangleInsets(top, left, bottom, right), paintType);
    }

    public BlockBorder(RectangleInsets insets, PaintType paintType) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.insets = insets;
        this.paintType = paintType;
    }

    public RectangleInsets getInsets() {
        return this.insets;
    }

    public PaintType getPaintType() {
        return this.paintType;
    }

    public void draw(Canvas canvas, RectShape area) {
        double t = this.insets.calculateTopInset(area.getHeight());
        double b = this.insets.calculateBottomInset(area.getHeight());
        double l = this.insets.calculateLeftInset(area.getWidth());
        double r = this.insets.calculateRightInset(area.getWidth());
        double x = area.getX();
        double y = area.getY();
        double w = area.getWidth();
        double h = area.getHeight();
        RectShape rect = new RectShape();
        Paint paint = PaintUtility.createPaint(1, this.paintType);
        paint.setStyle(Paint.Style.FILL);
        if (t > 0.0) {
            rect.setRect(x, y, w, t);
            canvas.drawRect(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY(), paint);
        }
        if (b > 0.0) {
            rect.setRect(x, y + h - b, w, b);
            canvas.drawRect(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY(), paint);
        }
        if (l > 0.0) {
            rect.setRect(x, y, l, h);
            canvas.drawRect(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY(), paint);
        }
        if (r > 0.0) {
            rect.setRect(x + w - r, y, r, h);
            canvas.drawRect(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY(), paint);
        }
    }
}

