/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.axis;

import android.graphics.Canvas;
import java.io.Serializable;
import org.afree.chart.Effect3D;
import org.afree.chart.axis.AxisState;
import org.afree.chart.axis.CategoryAnchor;
import org.afree.chart.axis.CategoryAxis;
import org.afree.chart.plot.CategoryPlot;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.renderer.category.CategoryItemRenderer;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;

public class CategoryAxis3D
extends CategoryAxis
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4114732251353700972L;

    public CategoryAxis3D() {
        this(null);
    }

    public CategoryAxis3D(String label) {
        super(label);
    }

    public AxisState draw(Canvas canvas, double cursor, RectShape plotArea, RectShape dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        if (!this.isVisible()) {
            return new AxisState(cursor);
        }
        CategoryPlot plot = (CategoryPlot)this.getPlot();
        RectShape adjustedDataArea = new RectShape();
        if (plot.getRenderer() instanceof Effect3D) {
            Effect3D e3D = (Effect3D)((Object)plot.getRenderer());
            double adjustedX = dataArea.getMinX();
            double adjustedY = dataArea.getMinY();
            double adjustedW = (double)dataArea.getWidth() - e3D.getXOffset();
            double adjustedH = (double)dataArea.getHeight() - e3D.getYOffset();
            if (edge == RectangleEdge.LEFT || edge == RectangleEdge.BOTTOM) {
                adjustedY += e3D.getYOffset();
            } else if (edge == RectangleEdge.RIGHT || edge == RectangleEdge.TOP) {
                adjustedX += e3D.getXOffset();
            }
            adjustedDataArea.setRect(adjustedX, adjustedY, adjustedW, adjustedH);
        } else {
            adjustedDataArea.setRect(dataArea);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(canvas, cursor, adjustedDataArea, edge);
        }
        AxisState state = new AxisState(cursor);
        if (this.isTickMarksVisible()) {
            this.drawTickMarks(canvas, cursor, adjustedDataArea, edge, state);
        }
        state = this.drawCategoryLabels(canvas, plotArea, adjustedDataArea, edge, state, plotState);
        state = this.drawLabel(this.getLabel(), canvas, plotArea, dataArea, edge, state);
        return state;
    }

    public double getCategoryJava2DCoordinate(CategoryAnchor anchor, int category, int categoryCount, RectShape area, RectangleEdge edge) {
        double result = 0.0;
        RectShape adjustedArea = area;
        CategoryPlot plot = (CategoryPlot)this.getPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof Effect3D) {
            Effect3D e3D = (Effect3D)((Object)renderer);
            double adjustedX = area.getMinX();
            double adjustedY = area.getMinY();
            double adjustedW = (double)area.getWidth() - e3D.getXOffset();
            double adjustedH = (double)area.getHeight() - e3D.getYOffset();
            if (edge == RectangleEdge.LEFT || edge == RectangleEdge.BOTTOM) {
                adjustedY += e3D.getYOffset();
            } else if (edge == RectangleEdge.RIGHT || edge == RectangleEdge.TOP) {
                adjustedX += e3D.getXOffset();
            }
            adjustedArea = new RectShape(adjustedX, adjustedY, adjustedW, adjustedH);
        }
        if (anchor == CategoryAnchor.START) {
            result = this.getCategoryStart(category, categoryCount, adjustedArea, edge);
        } else if (anchor == CategoryAnchor.MIDDLE) {
            result = this.getCategoryMiddle(category, categoryCount, adjustedArea, edge);
        } else if (anchor == CategoryAnchor.END) {
            result = this.getCategoryEnd(category, categoryCount, adjustedArea, edge);
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

