/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.afree.chart.ChartRenderingInfo;
import org.afree.chart.block.BlockParams;
import org.afree.chart.block.EntityBlockResult;
import org.afree.chart.block.LengthConstraintType;
import org.afree.chart.block.LineBorder;
import org.afree.chart.block.RectangleConstraint;
import org.afree.chart.entity.AFreeChartEntity;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.event.ChartChangeEvent;
import org.afree.chart.event.PlotChangeEvent;
import org.afree.chart.event.PlotChangeListener;
import org.afree.chart.event.TitleChangeEvent;
import org.afree.chart.event.TitleChangeListener;
import org.afree.chart.plot.CategoryPlot;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.title.LegendTitle;
import org.afree.chart.title.TextTitle;
import org.afree.chart.title.Title;
import org.afree.data.Range;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.Drawable;
import org.afree.ui.HorizontalAlignment;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;
import org.afree.ui.Size2D;
import org.afree.ui.VerticalAlignment;
import org.afree.util.ObjectUtilities;
import org.afree.util.PaintTypeUtilities;

public class AFreeChart
implements Drawable,
TitleChangeListener,
PlotChangeListener,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3470703747817429120L;
    public static final Font DEFAULT_TITLE_FONT = new Font("SansSerif", 1, 18);
    public static final PaintType DEFAULT_BACKGROUND_PAINT = new SolidColor(-3355444);
    public static final int DEFAULT_BACKGROUND_IMAGE_ALIGNMENT = 15;
    public static final float DEFAULT_BACKGROUND_IMAGE_ALPHA = 0.5f;
    private boolean borderVisible;
    private transient float borderStroke;
    private transient PaintType borderPaintType;
    private RectangleInsets padding;
    private TextTitle title;
    public static final PathEffect DEFAULT_BORDER_EFFECT = null;
    private transient PathEffect borderEffect;
    private List subtitles;
    private Plot plot;
    private transient PaintType backgroundPaintType;
    private boolean notify;

    public AFreeChart(String title, Font titleFont, Plot plot, boolean createLegend) {
        if (plot == null) {
            throw new NullPointerException("Null 'plot' argument.");
        }
        this.notify = true;
        this.borderVisible = true;
        this.borderStroke = 2.0f;
        this.borderPaintType = new SolidColor(-1);
        this.borderEffect = DEFAULT_BORDER_EFFECT;
        this.plot = plot;
        this.subtitles = new ArrayList();
        if (createLegend) {
            LegendTitle legend = new LegendTitle(this.plot);
            legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
            legend.setFrame(new LineBorder());
            SolidColor paintType = new SolidColor(-1);
            legend.setBackgroundPaintType(paintType);
            legend.setPosition(RectangleEdge.BOTTOM);
            this.subtitles.add(legend);
        }
        if (title != null) {
            if (titleFont == null) {
                titleFont = DEFAULT_TITLE_FONT;
            }
            this.title = new TextTitle(title, titleFont);
        }
        this.backgroundPaintType = DEFAULT_BACKGROUND_PAINT;
    }

    public AFreeChart(String title, Plot plot) {
        this(title, DEFAULT_TITLE_FONT, plot, true);
    }

    public AFreeChart(Plot plot) {
        this(null, null, plot, true);
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    public void setBorderVisible(boolean visible) {
        this.borderVisible = visible;
    }

    public float getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(float stroke) {
        this.borderStroke = stroke;
    }

    public PaintType getBorderPaintType() {
        return this.borderPaintType;
    }

    public void setBorderPaintType(PaintType paintType) {
        this.borderPaintType = paintType;
    }

    public RectangleInsets getPadding() {
        return this.padding;
    }

    public void setPadding(RectangleInsets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        this.padding = padding;
    }

    public TextTitle getTitle() {
        return this.title;
    }

    public void setTitle(TextTitle title) {
        this.title = title;
    }

    public void setBorderEffect(PathEffect effect) {
        this.borderEffect = effect;
    }

    public void setTitle(String text) {
        if (text != null) {
            if (this.title == null) {
                this.setTitle(new TextTitle(text, DEFAULT_TITLE_FONT));
            } else {
                this.title.setText(text);
            }
        } else {
            this.setTitle((TextTitle)null);
        }
    }

    public void addLegend(LegendTitle legend) {
        this.addSubtitle(legend);
    }

    public void addSubtitle(Title subtitle) {
        if (subtitle == null) {
            throw new IllegalArgumentException("Null 'subtitle' argument.");
        }
        this.subtitles.add(subtitle);
    }

    public LegendTitle getLegend() {
        return this.getLegend(0);
    }

    public LegendTitle getLegend(int index) {
        int seen = 0;
        for (Title subtitle : this.subtitles) {
            if (!(subtitle instanceof LegendTitle)) continue;
            if (seen == index) {
                return (LegendTitle)subtitle;
            }
            ++seen;
        }
        return null;
    }

    public void removeLegend() {
        this.removeSubtitle(this.getLegend());
    }

    public void removeSubtitle(Title title) {
        this.subtitles.remove(title);
    }

    public List getSubtitles() {
        return new ArrayList(this.subtitles);
    }

    public void setSubtitles(List subtitles) {
        if (subtitles == null) {
            throw new NullPointerException("Null 'subtitles' argument.");
        }
        this.clearSubtitles();
        for (Title t : subtitles) {
            if (t == null) continue;
            this.addSubtitle(t);
        }
    }

    public void clearSubtitles() {
        this.subtitles.clear();
    }

    public int getSubtitleCount() {
        return this.subtitles.size();
    }

    public Title getSubtitle(int index) {
        if (index < 0 || index >= this.getSubtitleCount()) {
            throw new IllegalArgumentException("Index out of range.");
        }
        return (Title)this.subtitles.get(index);
    }

    public Plot getPlot() {
        return this.plot;
    }

    public CategoryPlot getCategoryPlot() {
        return (CategoryPlot)this.plot;
    }

    public XYPlot getXYPlot() {
        return (XYPlot)this.plot;
    }

    public PathEffect getBorderEffect() {
        return this.borderEffect;
    }

    public PaintType getBackgroundPaintType() {
        return this.backgroundPaintType;
    }

    public void setBackgroundPaintType(PaintType paintType) {
        if (this.backgroundPaintType != null) {
            if (!this.backgroundPaintType.equals(paintType)) {
                this.backgroundPaintType = paintType;
            }
        } else if (paintType != null) {
            this.backgroundPaintType = paintType;
        }
    }

    public void draw(Canvas canvas, RectShape area) {
        this.draw(canvas, area, null, null);
    }

    public void draw(Canvas canvas, RectShape area, ChartRenderingInfo info) {
        this.draw(canvas, area, null, info);
    }

    public void draw(Canvas canvas, RectShape chartArea, PointF anchor, ChartRenderingInfo info) {
        EntityCollection e;
        PaintType paintType;
        EntityCollection entities = null;
        if (info != null) {
            info.clear();
            info.setChartArea(chartArea);
            entities = info.getEntityCollection();
        }
        if (entities != null) {
            entities.add(new AFreeChartEntity((Shape)chartArea.clone(), this));
        }
        Rect savedClip = canvas.getClipBounds();
        canvas.clipRect(chartArea.getMinX(), chartArea.getMinY(), chartArea.getMaxX(), chartArea.getMaxY());
        if (this.backgroundPaintType != null) {
            Paint paint = PaintUtility.createPaint(1, this.backgroundPaintType);
            chartArea.fill(canvas, paint);
        }
        if (this.isBorderVisible() && (paintType = this.getBorderPaintType()) != null) {
            RectShape borderArea = new RectShape((double)chartArea.getX(), (double)chartArea.getY(), (double)chartArea.getWidth() - 1.0, (double)chartArea.getHeight() - 1.0);
            Paint paint = PaintUtility.createPaint(this.borderPaintType, this.borderStroke, this.borderEffect);
            borderArea.draw(canvas, paint);
        }
        RectShape nonTitleArea = new RectShape();
        nonTitleArea.setRect(chartArea);
        if (this.padding != null) {
            this.padding.trim(nonTitleArea);
        }
        if (this.title != null && (e = this.drawTitle(this.title, canvas, nonTitleArea, entities != null)) != null) {
            entities.addAll(e);
        }
        for (Title currentTitle : this.subtitles) {
            EntityCollection e2;
            if (!currentTitle.isVisible() || (e2 = this.drawTitle(currentTitle, canvas, nonTitleArea, entities != null)) == null) continue;
            entities.addAll(e2);
        }
        RectShape plotArea = nonTitleArea;
        PlotRenderingInfo plotInfo = null;
        if (info != null) {
            plotInfo = info.getPlotInfo();
        }
        this.plot.draw(canvas, plotArea, anchor, null, plotInfo);
        canvas.clipRect(savedClip, Region.Op.REPLACE);
    }

    private RectShape createAlignedRectShape(Size2D dimensions, RectShape frame, HorizontalAlignment hAlign, VerticalAlignment vAlign) {
        double x = Double.NaN;
        double y = Double.NaN;
        if (hAlign == HorizontalAlignment.LEFT) {
            x = frame.getX();
        } else if (hAlign == HorizontalAlignment.CENTER) {
            x = (double)frame.getCenterX() - dimensions.width / 2.0;
        } else if (hAlign == HorizontalAlignment.RIGHT) {
            x = (double)frame.getMaxX() - dimensions.width;
        }
        if (vAlign == VerticalAlignment.TOP) {
            y = frame.getY();
        } else if (vAlign == VerticalAlignment.CENTER) {
            y = (double)frame.getCenterY() - dimensions.height / 2.0;
        } else if (vAlign == VerticalAlignment.BOTTOM) {
            y = (double)frame.getMaxY() - dimensions.height;
        }
        return new RectShape(x, y, dimensions.width, dimensions.height);
    }

    protected EntityCollection drawTitle(Title t, Canvas canvas, RectShape area, boolean entities) {
        Size2D size;
        if (t == null) {
            throw new IllegalArgumentException("Null 't' argument.");
        }
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        RectShape titleArea = new RectShape();
        RectangleEdge position = t.getPosition();
        double ww = area.getWidth();
        if (ww <= 0.0) {
            return null;
        }
        double hh = area.getHeight();
        if (hh <= 0.0) {
            return null;
        }
        RectangleConstraint constraint = new RectangleConstraint(ww, new Range(0.0, ww), LengthConstraintType.RANGE, hh, new Range(0.0, hh), LengthConstraintType.RANGE);
        Object retValue = null;
        BlockParams p = new BlockParams();
        p.setGenerateEntities(entities);
        if (position == RectangleEdge.TOP) {
            size = t.arrange(canvas, constraint);
            titleArea = this.createAlignedRectShape(size, area, t.getHorizontalAlignment(), VerticalAlignment.TOP);
            retValue = t.draw(canvas, titleArea, p);
            area.setRect((double)area.getX(), Math.min((double)area.getY() + size.height, (double)area.getMaxY()), (double)area.getWidth(), Math.max((double)area.getHeight() - size.height, 0.0));
        } else if (position == RectangleEdge.BOTTOM) {
            size = t.arrange(canvas, constraint);
            titleArea = this.createAlignedRectShape(size, area, t.getHorizontalAlignment(), VerticalAlignment.BOTTOM);
            retValue = t.draw(canvas, titleArea, p);
            area.setRect((double)area.getX(), (double)area.getY(), (double)area.getWidth(), (double)area.getHeight() - size.height);
        } else if (position == RectangleEdge.RIGHT) {
            size = t.arrange(canvas, constraint);
            titleArea = this.createAlignedRectShape(size, area, HorizontalAlignment.RIGHT, t.getVerticalAlignment());
            retValue = t.draw(canvas, titleArea, p);
            area.setRect((double)area.getX(), (double)area.getY(), (double)area.getWidth() - size.width, (double)area.getHeight());
        } else if (position == RectangleEdge.LEFT) {
            size = t.arrange(canvas, constraint);
            titleArea = this.createAlignedRectShape(size, area, HorizontalAlignment.LEFT, t.getVerticalAlignment());
            retValue = t.draw(canvas, titleArea, p);
            area.setRect((double)area.getX() + size.width, (double)area.getY(), (double)area.getWidth() - size.width, (double)area.getHeight());
        } else {
            throw new RuntimeException("Unrecognised title position.");
        }
        EntityCollection result = null;
        if (retValue instanceof EntityBlockResult) {
            EntityBlockResult ebr = (EntityBlockResult)retValue;
            result = ebr.getEntityCollection();
        }
        return result;
    }

    public void handleClick(int x, int y, ChartRenderingInfo info) {
        this.plot.handleClick(x, y, info.getPlotInfo());
    }

    public void titleChanged(TitleChangeEvent event) {
    }

    public void plotChanged(PlotChangeEvent event) {
    }

    public Object clone() throws CloneNotSupportedException {
        AFreeChart chart = (AFreeChart)super.clone();
        if (this.title != null) {
            chart.title = (TextTitle)this.title.clone();
        }
        chart.subtitles = new ArrayList();
        int i = 0;
        while (i < this.getSubtitleCount()) {
            Title subtitle = (Title)this.getSubtitle(i).clone();
            chart.subtitles.add(subtitle);
            ++i;
        }
        if (this.plot != null) {
            chart.plot = (Plot)this.plot.clone();
            chart.plot.addChangeListener(chart);
        }
        return chart;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.notifyListeners(new ChartChangeEvent(this));
        }
    }

    protected void notifyListeners(ChartChangeEvent event) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AFreeChart)) {
            return false;
        }
        AFreeChart that = (AFreeChart)obj;
        if (this.borderVisible != that.borderVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(Float.valueOf(this.borderStroke), Float.valueOf(that.borderStroke))) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.borderPaintType, that.borderPaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.title, that.title)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.subtitles, that.subtitles)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.plot, that.plot)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.backgroundPaintType, that.backgroundPaintType)) {
            return false;
        }
        return this.notify == that.notify;
    }
}

