﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;
using FDK;

namespace StrokeStyleT
{
	class CActGUI画像 : CActGUIBase
	{
		public CActGUI画像( CActGUIパネル ParentPanel, string stg画像ファイルパス )
			: base( ParentPanel )
		{
			// 画像がちゃんと生成できることを確認するついでにサイズを取得する。

			using( var bmp = new Bitmap( stg画像ファイルパス ) )
			{
				this.Size = new Size( bmp.Width, bmp.Height );
			}

			// 確認OK。

			this.stg画像ファイルパス = stg画像ファイルパス;
		}

		protected string stg画像ファイルパス = null;
		protected CTexture tx画像 = null;

		protected override void Onデバイスリソースの作成()
		{
			Global.tデバイスをロックして処理を行う( ( hDevice ) => {
				this.tx画像 = new CTexture( hDevice, this.stg画像ファイルパス );
			} );

			base.Onデバイスリソースの作成();
		}
		protected override void Onデバイスリソースの解放()
		{
			if( null != this.tx画像 )
			{
				this.tx画像.Dispose();
				this.tx画像 = null;
			}

			base.Onデバイスリソースの解放();
		}
		protected override void On描画( IntPtr hDevice )
		{
			// 自分を描画。
			CActGUIBase.t親パネル相対位置で描画する( hDevice, this, this.tx画像 );

			// 子Activityを持つならそれも描画。後から Add() した子ほど上に描画されることになる。
			base.On描画( hDevice );
		}
	}
}
