﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;
using System.Drawing.Imaging;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	class CActGUIパネル : CActGUIBase
	{
		public CActGUIパネル( string stgパネル画像ファイルパス )
			: base( null )
		{
			// 画像がちゃんと生成できることを確認するついでにサイズを取得する。

			using( var bmp = new Bitmap( stgパネル画像ファイルパス ) )
			{
				this.Size = new Size( bmp.Width, bmp.Height );
			}

			// 確認OK。

			this.stgパネル画像ファイルパス = stgパネル画像ファイルパス;
		}

		// パネルにおけるすべての EventHandler は、自分だけじゃなく子のイベントも受けるのでちゃんと判別すること（sender が自分か子のいずれかになる）。

		protected string stgパネル画像ファイルパス = null;
		protected CTexture txパネル = null;

		protected override void Onデバイスリソースの作成()
		{
			Global.tデバイスをロックして処理を行う( ( hDevice ) => {
				this.txパネル = new CTexture( hDevice, this.stgパネル画像ファイルパス );
			} );

			base.Onデバイスリソースの作成();
		}
		protected override void Onデバイスリソースの解放()
		{
			if( null != this.txパネル )
			{
				this.txパネル.Dispose();
				this.txパネル = null;
			}

			base.Onデバイスリソースの解放();
		}
		protected override void On描画( IntPtr hDevice )
		{
			// 自分を描画。
			if( null != this.txパネル )
				this.txパネル.t2D描画( hDevice, this.Location );

			
			// 子Activityを持つならそれも描画。後から Add() した子ほど上に描画されることになる。
			base.On描画( hDevice );
		}
	}
}
