#pragma once

namespace FDK
{
	/// RXgN^Ŏw肳ꂽXg[ɑ΂ Trace Oo͂郊Xi[B
	/// Trace::Listeners  Add() ΁AftHg̏o̓EBhEɉāAAdd Xi[ɂbZ[Wo͂悤ɂȂB
	public ref class CTraceLogListener : TraceListener
	{
	public:
		CTraceLogListener( StreamWriter^ stream, List<String^>^ listĂяoƂĕ\ȂO )
			: TraceListener()
		{
			this->Disposed = gcnew CDisposed();

			this->lockObject = gcnew Object();

			this->streamWriter = stream;
			this->dts̍ŏIo͓ = DateTime::Now;
			this->listĂяoƂĕ\ȂO = listĂяoƂĕ\ȂO;
		}
		~CTraceLogListener()
		{
			if( this->Disposed->bDisposeς݂܂͏ł )
				return;		// O𔭏oȂB

			if( !this->Disposed->tJn錾() )
				return;		// O𔭏oȂB


			//if( this->streamWriter != nullptr )		closedelete肵Ă͂Ȃ悤B
			//{
			//	this->streamWriter->Close();
			//	SAFE_REF_DELETE( this->streamWriter );
			//}

			//GC::SuppressFinalize( this );   --> RpCɂ
		}

		virtual void Flush() override
		{
			this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );

			lock l( this->lockObject );
			this->streamWriter->Flush();
		}
		virtual void TraceEvent( TraceEventCache^ eventCache, String^ source, TraceEventType eventType, int id, String^ message ) override
		{
			this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );

			lock l( this->lockObject );

			this->tKvȂso͂();
			this->to͂();
			this->tXbhIDo͂();
			this->tCxgʂo͂( eventType );
			this->tĂяoo͂();
			this->tCfgo͂();
			this->streamWriter->WriteLine( message );
		}
		virtual void TraceEvent( TraceEventCache^ eventCache, String^ source, TraceEventType eventType, int id, String^ format, ... array<Object^>^ args ) override
		{
			this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );

			lock l( this->lockObject );

			this->tKvȂso͂();
			this->to͂();
			this->tXbhIDo͂();
			this->tCxgʂo͂( eventType );
			this->tĂяoo͂();
			this->tCfgo͂();
			this->streamWriter->WriteLine( String::Format( format, args ) );
		}
		virtual void Write( String^ message ) override
		{
			this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );

			lock l( this->lockObject );
			this->streamWriter->Write( message );
		}
		virtual void WriteLine( String^ message ) override
		{
			this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );

			lock l( this->lockObject );
			this->streamWriter->WriteLine( message );
		}

	protected:
		StreamWriter^ streamWriter;

	private:
		CDisposed^		Disposed;
		List<String^>^	listĂяoƂĕ\ȂO;
		DateTime		dts̍ŏIo͓;
		Object^			lockObject;

		void tKvȂso͂()
		{
			//this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );		private Ȃ̂Ńm[`FbNB

			TimeSpan tss̏o͊Ԋu = TimeSpan::FromSeconds( 2.000 );	// 2bȏ゠sóB

			DateTime dtݓ = DateTime::Now;
			TimeSpan tsoߓ = ( dtݓ - this->dts̍ŏIo͓ ).Duration();

			if( tsoߓ >= tss̏o͊Ԋu )
			{
				this->streamWriter->WriteLine( "    :" );
				this->dts̍ŏIo͓ = dtݓ;
			}
		}
		void to͂()
		{
			//this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );		private Ȃ̂Ńm[`FbNB

			DateTime now = DateTime::Now;
			this->streamWriter->Write( String::Format( "{0:D4}/{1:D2}/{2:D2} {3:D2}:{4:D2}:{5:D2}.{6:D3} ", gcnew array<Object^> { now.Year, now.Month, now.Day, now.Hour, now.Minute, now.Second, now.Millisecond } ) );
		}
		void tXbhIDo͂()
		{
			//this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );		private Ȃ̂Ńm[`FbNB

			String^ name = Thread::CurrentThread->Name;
			
			if( String::IsNullOrEmpty( name ) )
				name = Thread::CurrentThread->ManagedThreadId.ToString("D4");
			
			this->streamWriter->Write( "[" + name + "]" );
		}
		void tCxgʂo͂( TraceEventType eventType )
		{
			//this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );		private Ȃ̂Ńm[`FbNB

			switch( eventType )
			{
			case TraceEventType::Critical:
				this->streamWriter->Write( "yvIz" );
				break;
			
			case TraceEventType::Error:
				this->streamWriter->Write( "yG[z" );
				break;

			case TraceEventType::Warning:
				this->streamWriter->Write( "yxz" );
				return;

			default:
				return;
			}
		}
		void tCfgo͂()
		{
			//this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );		private Ȃ̂Ńm[`FbNB

			if( 0 > this->IndentLevel )
				this->IndentLevel = 0;

			if( 0 > this->IndentSize )
				this->IndentSize = 0;

			for( int i = 0; i < this->IndentLevel; i++ )
				for( int j = 0; j < this->IndentSize; j++ )
					this->streamWriter->Write( ' ' );
		}
		void tĂяoo͂()
		{
			//this->Disposed->tDisposeς݂܂͎sȂO( "CTraceLogListener" );		private Ȃ̂Ńm[`FbNB

			// V{̓fobOo[Włߍ܂ȂB

#ifdef _DEBUG
			StackTrace^ stackTrace = gcnew StackTrace();

			for( int i = 0; i < stackTrace->FrameCount; i++ )
			{
				System::Reflection::MethodBase^ method = stackTrace->GetFrame( i )->GetMethod();
				String^ callerName = ( nullptr == method->DeclaringType ) ? method->Name : method->DeclaringType->FullName;		// O[o֐̏ꍇADeclaringType  null ɂȂB

				if( false == this->listĂяoƂĕ\ȂO->Contains( callerName ) )
				{
					if( nullptr != method->DeclaringType )
					{
						this->streamWriter->Write( "[" + callerName + "." + method->Name + "] " );
					}
					else
					{
						this->streamWriter->Write( "[" + callerName + "] " );
					}
					break;
				}
			}
#endif
		}
	};
}
