#pragma once

#include "refCTimerBase.h"

namespace FDK
{
	public ref class CTimer : CTimerBase
	{
	public:
		enum class E
		{
			Unknown = -1,
			PerformanceCounter = 0,
			MultiMedia = 1,
			GetTickCount = 2,
		};
		
		property E e^C}
		{
			E get()
			{ 
				this->Disposed->tDisposeς݂܂͎sȂO( "CTimer" );

				lock l( this->lockObject );
				return this->_e^C};
			}
		protected:
			void set( E value )
			{ 
				this->Disposed->tDisposeς݂܂͎sȂO( "CTimer" );

				lock l( this->lockObject );
				this->_e^C} = value;
			}
		};
		virtual property Int64 nVXems
		{
			Int64 get() override
			{
				this->Disposed->tDisposeς݂܂͎sȂO( "CTimer" );

				switch( this->e^C} )
				{
				case E::PerformanceCounter:
					{
						lock l( this->lockObject );
					
						Double num = 0.0;
						if( 0L != this->n݂̎g )
						{
							LARGE_INTEGER x;
							::QueryPerformanceCounter( &x );
							num = ( (Double) x.QuadPart ) / ( ( (Double) this->n݂̎g ) / 1000.0 );
						}
						return (Int64) num;
					}
				case E::MultiMedia:
					return (Int64) ::timeGetTime();

				case E::GetTickCount:
					return (Int64) Environment::TickCount;
				}
				return 0;
			}
		}

		CTimer( E e^C} )
			: CTimerBase()
		{
			this->Disposed = gcnew CDisposed();

			this->lockObject = gcnew Object();

			this->e^C} = e^C};

			if( this->nQƃJEg[ (int) this->e^C} ] == 0 )
			{
				switch( this->e^C} )
				{
				case E::PerformanceCounter:
					if( !this->bmFƐݒ_PerformanceCounter() && !this->bmFƐݒ_MultiMedia() )
						this->bmFƐݒ_GetTickCount();
					break;

				case E::MultiMedia:
					if( !this->bmFƐݒ_MultiMedia() && !this->bmFƐݒ_PerformanceCounter() )
						this->bmFƐݒ_GetTickCount();
					break;

				case E::GetTickCount:
					this->bmFƐݒ_GetTickCount();
					break;

					default:
						throw gcnew ArgumentException( String::Format( "m̃^C}ʂłB[{0}]", this->e^C} ) );
				}
			}
	
			this->tZbg();

			this->nQƃJEg[ (int) this->e^C} ]++;
		}
		~CTimer()
		{
			if( this->Disposed->bDisposeς݂܂͏ł )
				return;		// O͔oȂB

			if( !this->Disposed->tJn錾() )
				return;		// O͔oȂB


			lock l( this->lockObject );

			if( E::Unknown == this->_e^C} )
				return;

			int type = (int) this->_e^C};

			this->nQƃJEg[ type ] = Math::Max( this->nQƃJEg[ type ] - 1, 0 );

			if( 0 == this->nQƃJEg[ type ] )
			{
				if( E::MultiMedia == this->_e^C} )
					::timeEndPeriod( ( UINT ) this->timeCaps.wPeriodMin );
			}

			this->_e^C} = E::Unknown;

			//GC::SuppressFinalize( this );   --> RpCɂ
		}

	protected:
		Int64 n݂̎g;
		static array<int>^ nQƃJEg = gcnew array<int>(3);

		value class TimeCaps
		{
		public:
			WORD wPeriodMin;
			WORD wPeriodMax;
		};
		
		TimeCaps timeCaps;

	private:
		CDisposed^ Disposed;
		E _e^C};
		Object^ lockObject;		// bNp

		bool bmFƐݒ_GetTickCount()
		{
			//this->Disposed->tDisposeς݂܂͎sȂO( "CTimer" );		private Ȃ̂Ńm[`FbN

			this->e^C} = E::GetTickCount;
			return true;
		}
		bool bmFƐݒ_MultiMedia()
		{
			//this->Disposed->tDisposeς݂܂͎sȂO( "CTimer" );		private Ȃ̂Ńm[`FbN

			TIMECAPS tc;

			if( ( 0 == ::timeGetDevCaps( &tc, (UINT) Marshal::SizeOf( TimeCaps::typeid ) ) ) && ( 10 > tc.wPeriodMin ) )
			{
				this->timeCaps = TimeCaps();
				this->timeCaps.wPeriodMax = tc.wPeriodMax;
				this->timeCaps.wPeriodMin = tc.wPeriodMin;

				this->e^C} = E::MultiMedia;
				::timeBeginPeriod( tc.wPeriodMin );
				return true;
			}
			return false;
		}
		bool bmFƐݒ_PerformanceCounter()
		{
			//this->Disposed->tDisposeς݂܂͎sȂO( "CTimer" );		private Ȃ̂Ńm[`FbN

			LARGE_INTEGER li;
			if( 0 != ::QueryPerformanceFrequency( &li ) )
			{
				this->n݂̎g = (Int64) li.QuadPart;
				this->e^C} = E::PerformanceCounter;
				return true;
			}
			return false;
		}
	};
}
