#pragma once

#include "CMediaSessionNative.h"
#include "Sound\refCSound.h"

namespace FDK
{
	public ref class CMediaSession
	{
	public:
		enum class EMediaSession̏
		{
			ĐI,		// ԁA܂ MESessionEnded CxgMB
			Đ,		// 񓯊\bh@IMFMediaSession::Start() sB
			Đ,			// MESessionStarted CxgMB
			~,		// 񓯊\bh IMFMediaSession::Stop() sB
			~,			// MESessionStopped CxgMB
			ꎞ~,	// 񓯊\bh IMFMediaSession::Pause() sB
			ꎞ~		// MESessionPaused CxgMB
		};
		property EMediaSession̏ eMediaSession̏
		{
			EMediaSession̏ get()
			{
				this->Disposed->tDisposeς݂܂͎sȂO( "CMediaSession" );

				switch( this->pMediaSessionNative->Status.Get() )
				{
				case CMediaSessionNative::CStatus::EStatus::ĐI:
					return EMediaSession̏::ĐI;

				case CMediaSessionNative::CStatus::EStatus::Đ:
					return EMediaSession̏::Đ;

				case CMediaSessionNative::CStatus::EStatus::Đ:
					return EMediaSession̏::Đ;

				case CMediaSessionNative::CStatus::EStatus::~:
					return EMediaSession̏::~;

				case CMediaSessionNative::CStatus::EStatus::~:
					return EMediaSession̏::~;

				case CMediaSessionNative::CStatus::EStatus::ꎞ~:
					return EMediaSession̏::ꎞ~;

				case CMediaSessionNative::CStatus::EStatus::ꎞ~:
					return EMediaSession̏::ꎞ~;

				default:
					return EMediaSession̏::ĐI;
				}
			}
		}
		property bool bĐ
		{
			bool get() 
			{
				this->Disposed->tDisposeς݂܂͎sȂO( "CMediaSession" );
				return this->pMediaSessionNative->bĐł();
			}
		}
		property Size sz摜TCY
		{
			Size get()
			{
				this->Disposed->tDisposeς݂܂͎sȂO( "CMediaSession" );

				SIZE size;
				this->pMediaSessionNative->t摜TCY擾( &size );
				return Size( size.cx, size.cy );
			}
		}
		property long ñ݂Ot̍Đʒums
		{
			long get()
			{
				this->Disposed->tDisposeς݂܂͎sȂO( "CMediaSession" );

				UInt64 clock = this->pMediaSessionNative->ñ݂NbNԂ();	// 100ns PʁB
				return (long)(clock / ( 10 * 1000 ));	// 100nsP  1ms PʂɂĕԂB
			}
		}
		property UInt32 nx
		{
			void set( UInt32 val )
			{
				this->Disposed->tDisposeς݂܂͎sȂO( "CMediaSession" );
				this->pMediaSessionNative->txݒ肷( val );
			}
		}
		property bool bZ
		{
			void set( bool val )
			{
				this->Disposed->tDisposeς݂܂͎sȂO( "CMediaSession" );
				this->pMediaSessionNative->tZ( val );
			}
		}

		CMediaSession();
		CMediaSession( IntPtr hWnd, DWORD dwMediaSessionCxgXbhID, String^ stgt@C, bool b, bool b[v );
		~CMediaSession();
		!CMediaSession();

		void t\z( IntPtr hWnd, DWORD dwMediaSessionCxgXbhID, String^ stgt@C, bool b, bool b[v );
		void tĐ( UInt64 nĐJnʒu100ns );
		void tĐ( UInt64 nĐJnʒu100ns, CSound^ sound );	// sound ͓ƓčĐTEhB
		void t~();
		void tꎞ~();
		void tĐĊJ();
		void tĐ܂őҋ@();

		void t̃Tvv();
		void tŐṼTv`悷();
		void tŐṼTv`悷( System::Drawing::Rectangle rc` );
		void tŐṼTv`悷( int x, int y, int w, int h );

		static void tSCX^XEVRփfoCXύXʒm𑗂();				// XbhZ[t
		static void tSCX^X֎̃Tvv();					// XbhZ[t
		static void tSCX^X~();								// XbhZ[t

	private:
		CDisposed^ Disposed;
		CMediaSessionNative* pMediaSessionNative;

		void t̍ĐɓăTEhĐ( Object^ state );
	};
}
