#pragma once

#include "\CUnknown.h"

namespace FDK
{
	// CCEwp֐

	inline MFOffset MakeOffset( float v )
	{
		MFOffset offset;
		offset.value = short( v );
		offset.fract = WORD( 65536 * ( v - offset.value ) );
		return offset;
	}
	inline MFVideoArea MakeArea( float x, float y, DWORD width, DWORD height )
	{
		MFVideoArea area;
		area.OffsetX = MakeOffset( x );
		area.OffsetY = MakeOffset( y );
		area.Area.cx = width;
		area.Area.cy = height;
		return area;
	}
	inline LONG GetOffset( const MFOffset& offset )
	{
		return (LONG) ( (float) offset.value + offset.fract / 65536.0f );
	}
	inline HRESULT tfBA^Cv̑t[[gԂ( IMFMediaType *pType, MFRatio *pRatio )
	{
		return ::MFGetAttributeRatio( pType, MF_MT_FRAME_RATE, (UINT32*) &pRatio->Numerator, (UINT32*) &pRatio->Denominator );
	}
	inline HRESULT GetVideoDisplayAreaAux( IMFMediaType *pType, MFVideoArea *pArea )
	{
		HRESULT hr = S_OK;
		BOOL bPanScan = FALSE;
		UINT32 width = 0, height = 0;

		bPanScan = ::MFGetAttributeUINT32( pType, MF_MT_PAN_SCAN_ENABLED, FALSE );

		// pan/scan [h̏ꍇA pan/scan ̈̎擾݂B
		if( bPanScan )
			hr = pType->GetBlob( MF_MT_PAN_SCAN_APERTURE, (UINT8*) pArea, sizeof( MFVideoArea ), NULL );

		// pan/scan [hł͂ȂꍇA܂́Apan/scan ̈悪Ȃꍇ́AWIgbNAp`̎擾݂B
		if( !bPanScan || hr == MF_E_ATTRIBUTENOTFOUND )
			hr = pType->GetBlob( MF_MT_GEOMETRIC_APERTURE, (UINT8*) pArea, sizeof( MFVideoArea ), NULL );

		// ftHgł͑ŜgB
		if( !bPanScan || hr == MF_E_ATTRIBUTENOTFOUND )
		{
			if( SUCCEEDED( hr = ::MFGetAttributeSize( pType, MF_MT_FRAME_SIZE, &width, &height ) ) )
				*pArea = MakeArea( 0.0, 0.0, width, height );
		}

		return S_OK;
	}

	private class MediaTypeBuilder : public CUnknown
	{
	public:
		
		// static Ȑ\bhBVfBA^Cvꍇ͂̃o[WgƁB
		template <class T>
		static HRESULT Create( T** ppTypeBuilder )
		{
			if( ppTypeBuilder == NULL )
				return E_POINTER;
			
			HRESULT hr = S_OK;

			T *pTypeBuilder = new T( hr );

			if( pTypeBuilder == NULL )
				return E_OUTOFMEMORY;
			
			if( SUCCEEDED( hr ) )
			{
				*ppTypeBuilder = pTypeBuilder;
				(*ppTypeBuilder)->AddRef();
			}
		
			SAFE_COM_RELEASE( pTypeBuilder );
			return hr;
		}
		
		// ̃fBA^Cv珉ꍇ͂̃o[WgƁB
		template <class T>
		static HRESULT Create( IMFMediaType *pType, T** ppTypeBuilder )
		{
			if( ppTypeBuilder == NULL )
				return E_POINTER;
			
			HRESULT hr = S_OK;
			
			T *pTypeBuilder = new T( pType, hr );

			if( pTypeBuilder == NULL )
				return E_OUTOFMEMORY;
			
			if( SUCCEEDED( hr ) )
			{
				*ppTypeBuilder = pTypeBuilder;
				(*ppTypeBuilder)->AddRef();
			}
			
			SAFE_COM_RELEASE( pTypeBuilder );
			return hr;
		}
		
		/// <summary>W[^Cv GUID ԂB</summary>
		HRESULT GetMajorType( GUID *pGuid );
		
		/// <summary>fBAf[^kĂ邩ԂB</summary>
		HRESULT IsCompressedFormat( BOOL *pbCompressed );
		
		/// <summary>w肳ꂽfBA^CvƓł邩ׂB</summary>
		HRESULT IsEqual( IMFMediaType *pType, DWORD *pdwFlags );
		
		/// <summary>fBA^Cv̂P̃v[e[V擾B</summary>
		HRESULT GetRepresentation( GUID guidRepresentation, LPVOID *ppvRepresentation );
		
		/// <summary>GetRepresentation() ŊmۂꂽB</summary>
		HRESULT FreeRepresentation( GUID guidRepresentation, LPVOID pvRepresentation );


		// wp\bh
		
		// CopyFrom \bh; w肳ꂽfBA^Cvׂ̑ this ɃRs[B
		HRESULT CopyFrom( MediaTypeBuilder *pType );
		HRESULT CopyFrom( IMFMediaType *pType );
		
		HRESULT SetMajorType( GUID guid );
		HRESULT GetMediaType( IMFMediaType **ppType );
		HRESULT SetSubType( GUID guid );
		HRESULT GetSubType( GUID *pGuid );
		
		/// <summary>Tu^Cv FOURCC 𒊏oBׂẴTu^Cṽp^[ɓĂ͂܂ł͂ȂB</summary>
		HRESULT GetFourCC( DWORD *pFourCC );

		/// <summary>eTvAXg[̑̃TvƗĂ邩𒲂ׂB</summary>
		HRESULT GetAllSamplesIndependent( BOOL* pbIndependent );
		
		/// <summary>eTvAXg[̑̃TvƗĂ邩ۂw肷B</summary>
		HRESULT SetAllSamplesIndependent( BOOL bIndependent );
		
		/// <summary>TvŒTCYH</summary>
		HRESULT GetFixedSizeSamples( BOOL *pbFixed );
		
		/// <summary>TvŒTCYǂݒ肷B</summary>
		HRESULT SetFixedSizeSamples( BOOL bFixed );
		
		/// <summary>TṽTCYioCgPʁj擾B</summary>
		HRESULT GetSampleSize( UINT32 *pnSize );
		
		/// <summary>TṽTCYioCgPʁjݒ肷B</summary>
		HRESULT SetSampleSize( UINT32 nSize );
		
		/// <summary>MFWrapMediaType() ֐ŃbvꂽfBA^Cv擾B</summary>
		HRESULT Unwrap( IMFMediaType **ppOriginal );
		
		BOOL AllSamplesIndependent();
		BOOL FixedSizeSamples();
		UINT32 SampleSize();

	protected:
		IMFMediaType *m_pType;

		MediaTypeBuilder( IMFMediaType* pType, HRESULT& hr );
		MediaTypeBuilder( HRESULT& hr );

		BOOL IsValid( );
		IMFMediaType *GetMediaType( );
		virtual ~MediaTypeBuilder( );
	};
	class VideoTypeBuilder : public MediaTypeBuilder
	{
		friend class MediaTypeBuilder; 

	protected:

		VideoTypeBuilder( IMFMediaType *pType, HRESULT& hr );
		VideoTypeBuilder( HRESULT& hr );

	public:

		/// <summary>t[ǂ̂悤ɃC^[XĂ邩̏󋵂擾B</summary>
		HRESULT GetInterlaceMode( MFVideoInterlaceMode *pmode );

		/// <summary>t[ǂ̂悤ɃC^[XĂ邩̏󋵂ݒ肷B</summary>
		HRESULT SetInterlaceMode( MFVideoInterlaceMode mode );

		/// <summary>ftHgXgCh擾邩AZo݂B</summmary>
		HRESULT GetDefaultStride( INT32 *pnStride );

		/// <summary>ftHgXgChݒ肷B̒ĺA񈳏kf[^tH[}bgɑ΂Ă݈̂ӖB</summary>
		HRESULT SetDefaultStride( INT32 nStride );
		
		/// <summary>rfIt[̕ƍ擾B</summary>
		HRESULT GetFrameDimensions( UINT32 *pdwWidthInPixels, UINT32 *pdwHeightInPixels );

		/// <summary>rfIt[̕ƍݒ肷B</summary>
		HRESULT SetFrameDimensions( UINT32 dwWidthInPixels, UINT32 dwHeightInPixels );

		/// <summary>f[^G[iBitG[/bj擾B</summary>
		HRESULT GetDataBitErrorRate( UINT32 *pRate );

		/// <summary>f[^G[ibitG[/bjݒ肷B</summary>
		HRESULT SetDataBitErrorRate( UINT32 rate );

		/// <summary> Retrieves the c data rate of the video stream.
		HRESULT GetAverageBitRate( UINT32 *pRate );

		/// <summary>rfIXg[̂悻̃f[^[gݒ肷B</summary>
		HRESULT SetAvgerageBitRate( UINT32 rate );

		/// <summary>JX^J[̏l擾B</summary>
		HRESULT GetCustomVideoPrimaries( MT_CUSTOM_VIDEO_PRIMARIES *pPrimaries );

		/// <summary>JX^J[̏lݒ肷B</summary>
		HRESULT SetCustomVideoPrimaries( const MT_CUSTOM_VIDEO_PRIMARIES& primary );

		/// <summary>t[[giFPSj擾B</summary>
		HRESULT GetFrameRate( UINT32 *pnNumerator, UINT32 *pnDenominator );
		
		/// <summary>t[[g䗦Ŏ擾B</summary>
		HRESULT GetFrameRate( MFRatio *pRatio );

		/// <summary>t[[giFPSjݒ肷B</summary>
		HRESULT SetFrameRate( UINT32 nNumerator, UINT32 nDenominator );
		
		/// <summary>t[[g䗦Őݒ肷B</summary>
		HRESULT SetFrameRate( const MFRatio& ratio );

		/// <summary>WIgbNAp`擾B</summary>
		HRESULT GetGeometricAperture( MFVideoArea *pArea );

		/// <summary>WIgbNAp`ݒ肷B</summary>
		HRESULT SetGeometricAperture( const MFVideoArea& area );
		
		/// <summary>L[t[Ԃ̍őt[擾B</summary>
		HRESULT GetMaxKeyframeSpacing( UINT32 *pnSpacing );

		/// <summary>L[t[Ԃ̍őt[ݒ肷B</summary>
		HRESULT SetMaxKeyframeSpacing( UINT32 nSpacing );

		/// <summary>M͈̔͂܂ޗ̈擾B</summary>
		HRESULT GetMinDisplayAperture( MFVideoArea *pArea );

		/// <summary>M͈̔͂܂ޗ̈ݒ肷B</summary>
		HRESULT SetMinDisplayAperture( const MFVideoArea& area );

		/// <summary>rfIfBA^Cvɑ΂o͋`̃AXyNg擾B</summary>
		HRESULT GetPadControlFlags( MFVideoPadFlags *pFlags );
		
		/// <summary>rfIfBA^Cvɑ΂āAo͋`̃AXyNgݒ肷B</summary>
		HRESULT SetPadControlFlags( MFVideoPadFlags flags );

		/// <summary>rfIfBA^Cvɑ΂pbgGg̔z擾B</summary>
		HRESULT GetPaletteEntries( MFPaletteEntry *paEntries, UINT32 nEntries );

		/// <summary>rfIfBA^Cvɑ΂āApbgGg̔zݒ肷B</summary>
		HRESULT SetPaletteEntries( MFPaletteEntry *paEntries, UINT32 nEntries );

		/// <summary>pbgGg擾B</summary>
		HRESULT GetNumPaletteEntries( UINT32 *pnEntries );
		
		/// <summary>pan/scan[hɂāA\ׂrfÏ̗擾B</summary>
		HRESULT GetPanScanAperture( MFVideoArea *pArea );

		/// <summary>pan/scan[hɂāA\ׂrfÏ̗ݒ肷B</summary>
		HRESULT SetPanScanAperture( const MFVideoArea& area );

		/// <symmary>pan/scan[hp\ǂ₢킹B</summary>
		HRESULT IsPanScanEnabled( BOOL *pBool );

		/// <summary>pan/scan[h̗LEݒ肷B</summary>
		HRESULT SetPanScanEnabled( BOOL bEnabled );

		/// <summary>sNZAXyNg擾B</summary>
		HRESULT GetPixelAspectRatio( UINT32 *pnNumerator, UINT32 *pnDenominator );

		/// <summary>sNZAXyNgݒ肷B</summary>
		HRESULT SetPixelAspectRatio( UINT32 nNumerator, UINT32 nDenominator );

		/// <summary>sNZAXyNgݒ肷B</summary>
		HRESULT SetPixelAspectRatio( const MFRatio& ratio );

		/// <summary>̃AXyNg擾B</summary>
		HRESULT GetSourceContentHint( MFVideoSrcContentHintFlags *pFlags );
		
		/// <summary>̃AXyNgݒ肷B</summary>
		HRESULT SetSourceContentHint( MFVideoSrcContentHintFlags nFlags );

		/// <summary>RGBR'G'B'ɕϊ֐񋓂B</summary>
		HRESULT GetTransferFunction( MFVideoTransferFunction *pnFxn );

		/// <summary>RGBR'G'B'ɕϊ֐̗ݒ肷B</summary>
		HRESULT SetTransferFunction( MFVideoTransferFunction nFxn );

		/// <summary>Y'Cb'Cr'rfIfBA^CvɂāAN}Tv@擾B</summary>
		HRESULT GetChromaSiting( MFVideoChromaSubsampling *pSampling );

		/// <summary>Y'Cb'Cr'rfIfBA^CvɂāAN}Tv@ݒ肷B</summary>
		HRESULT SetChromaSiting( MFVideoChromaSubsampling nSampling );

		/// <summary>r[̃CeBOԂ擾B</summary>
		HRESULT GetVideoLighting( MFVideoLighting *pLighting );

		/// <summary>r[̃CeBOԂݒ肷B</summary>
		HRESULT SetVideoLighting( MFVideoLighting nLighting );

		/// <summary>rfIfBA^CvɂF͈̔͂擾B</summary>
		HRESULT GetVideoNominalRange( MFNominalRange *pRange );

		/// <summary>rfIfBA^Cvɑ΂āAF͈̔͂ݒ肷B</summary>
		HRESULT SetVideoNominalRange( MFNominalRange nRange );

		/// <summary>rfIfBA^Cvɂ鏉F擾B</summary>
		HRESULT GetVideoPrimaries( MFVideoPrimaries *pPrimaries );

		/// <summary>rfIfBA^Cvɂ鏉Fݒ肷B</summary>
		HRESULT SetVideoPrimaries( MFVideoPrimaries nPrimaries );

		/// <summary>Y'Cb'Cr' FԂ R'G'B' FԂɕϊs񋓂B</summary>
		HRESULT GetYUVMatrix( MFVideoTransferMatrix *pMatrix );

		/// <summary>Y'Cb'Cr' FԂ R'G'B' FԂɕϊsݒ肷B</summary>
		HRESULT SetYUVMatrix( MFVideoTransferMatrix nMatrix );
		
		MFRatio GetPixelAspectRatio();	// ftHg 1:1i`sNZjB
		BOOL IsPanScanEnabled();		// ftHg FALSEB
		
		/// <summary>
		/// ߂liD揇jF
		/// 1. pan/scan [hL̏ꍇɂ́Apan/scan ̈ԂB
		/// 2. WIgbNAp`ԂB
		/// 3. rfÏŜԂB
		/// </summary>
		HRESULT GetVideoDisplayArea( MFVideoArea *pArea );
	};
	class AudioTypeBuilder : public MediaTypeBuilder
	{
		friend class MediaTypeBuilder;
	
	protected:

		AudioTypeBuilder( IMFMediaType* pType, HRESULT& hr );
		AudioTypeBuilder( HRESULT& hr );
	
	public:
		
		/// <summary>σrbg[g(bps)擾B</summary>
		HRESULT GetAvgerageBytesPerSecond( UINT32 *pBytes );

		/// <summary>σrbg[g(bps)ݒ肷B</summary>
		HRESULT SetAvgerageBytesPerSecond( UINT32 nBytes );

		/// <summary>I[fBĨTvrbg擾B</summary>
		HRESULT GetBitsPerSample( UINT32 *pBits );
		
		/// <summary>I[fBĨTvrbgݒ肷B</summary>
		HRESULT SetBitsPerSample( UINT32 nBits );

		/// <summary>ubNEoCgPʂŎ擾B</summary>
		HRESULT GetBlockAlignment( UINT32 *pBytes );

		/// <summary>ubNEoCgPʂŐݒ肷B</summary>
		HRESULT SetBlockAlignment( UINT32 nBytes );

		/// <summary>I[fBI`l̃Xs[J[zuʒu擾B</summary>
		HRESULT GetChannelMask( UINT32 *pMask );

		/// <summary>I[fBI`l̃Xs[J[zuʒuݒ肷B</summary>
		HRESULT SetChannelMask( UINT32 nMask );

		/// <summary>bƂ̃I[fBITv𕂓lŎ擾B</summary>
		HRESULT GetFloatSamplesPerSecond( double *pfSampleRate );

		/// <summary>bƂ̃I[fBITv𕂓lŐݒ肷B</summary>
		HRESULT SetFloatSamplesPerSecond( double fSampleRate );

		/// <summary>I[fBI`l擾B</summary>
		HRESULT GetNumChannels( UINT32 *pnChannels );

		/// <summary>I[fBI`lݒ肷B</summary>
		HRESULT SetNumChannels( UINT32 nChannels );

		/// <summary>I[fBIf[^̈kubN܂łTv̐擾B</summary>
		HRESULT GetSamplesPerBlock( UINT32 *pnSamples );

		/// <summary>I[fBIf[^̈kubN܂łTv̐ݒ肷B</summary>
		HRESULT SetSamplesPerBlock( UINT32 nSamples );

		/// <summary>bƂ̃I[fBITv𐮐lŎ擾B</summary>
		HRESULT GetSamplesPerSecond( UINT32 *pnSampleRate );

		/// <summary>bƂ̃I[fBITv𐮐lŐݒ肷B</summary>
		HRESULT SetSamplesPerSecond( UINT32 nSampleRate );

		/// <summary>eI[fBITvɂLrbg擾B</summary>
		HRESULT GetValidBitsPerSample( UINT32 *pnBits );

		/// <summary>eI[fBITvɂLrbgݒ肷B</summary>
		HRESULT SetValidBitsPerSample( UINT32 nBits );
		
		UINT32 AvgerageBytesPerSecond();
		UINT32 BitsPerSample();
		UINT32 GetBlockAlignment();
		double FloatSamplesPerSecond();
		UINT32 NumChannels();
		UINT32 SamplesPerSecond();
	};
}